/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.digitalsignature;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.interactive.digitalsignature.SMSeedValueMDP;
import com.plpdf.smmodel.interactive.digitalsignature.SMSeedValueTimeStamp;
import com.plpdf.util.BitFlagHelper;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMSeedValue
implements OMObjectable {
    public static final int FLAG_FILTER = 1;
    public static final int FLAG_SUBFILTER = 2;
    public static final int FLAG_V = 4;
    public static final int FLAG_REASON = 8;
    public static final int FLAG_LEGAL_ATTESTATION = 16;
    public static final int FLAG_ADD_REV_INFO = 32;
    public static final int FLAG_DIGEST_METHOD = 64;
    private OMDictionary dictionary;

    public SMSeedValue() {
        this.dictionary = new OMDictionary();
        this.dictionary.setItem(OMName.TYPE, (OMBase)OMName.SV);
        this.dictionary.setDirect(true);
    }

    public SMSeedValue(OMDictionary dict) {
        this.dictionary = dict;
        this.dictionary.setDirect(true);
    }

    @Override
    public OMBase getOMObject() {
        return this.getDictionary();
    }

    public OMDictionary getDictionary() {
        return this.dictionary;
    }

    public boolean isFilterRequired() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.FF, 1);
    }

    public void setFilterRequired(boolean flag) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.FF, 1, flag);
    }

    public boolean isSubFilterRequired() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.FF, 2);
    }

    public void setSubFilterRequired(boolean flag) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.FF, 2, flag);
    }

    public boolean isDigestMethodRequired() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.FF, 64);
    }

    public void setDigestMethodRequired(boolean flag) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.FF, 64, flag);
    }

    public boolean isVRequired() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.FF, 4);
    }

    public void setVRequired(boolean flag) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.FF, 4, flag);
    }

    public boolean isReasonRequired() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.FF, 8);
    }

    public void setReasonRequired(boolean flag) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.FF, 8, flag);
    }

    public boolean isLegalAttestationRequired() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.FF, 16);
    }

    public void setLegalAttestationRequired(boolean flag) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.FF, 16, flag);
    }

    public boolean isAddRevInfoRequired() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.FF, 32);
    }

    public void setAddRevInfoRequired(boolean flag) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.FF, 32, flag);
    }

    public String getFilter() {
        return this.dictionary.getNameAsString(OMName.FILTER);
    }

    public void setFilter(OMName filter) {
        this.dictionary.setItem(OMName.FILTER, (OMBase)filter);
    }

    public List<String> getSubFilter() {
        OMArrayList retval = null;
        OMArray fields = (OMArray)this.dictionary.getDictionaryObject(OMName.SUBFILTER);
        if (fields != null) {
            ArrayList<String> actuals = new ArrayList<String>();
            int i = 0;
            while (i < fields.size()) {
                String element = fields.getName(i);
                if (element != null && element != null) {
                    actuals.add(element);
                }
                ++i;
            }
            retval = new OMArrayList(actuals, fields);
        }
        return retval;
    }

    public void setSubFilter(List<OMName> subfilter) {
        this.dictionary.setItem(OMName.SUBFILTER, (OMBase)OMArrayList.converterToOMArray(subfilter));
    }

    public List<String> getDigestMethod() {
        OMArrayList retval = null;
        OMArray fields = (OMArray)this.dictionary.getDictionaryObject(OMName.DIGEST_METHOD);
        if (fields != null) {
            ArrayList<String> actuals = new ArrayList<String>();
            int i = 0;
            while (i < fields.size()) {
                String element = fields.getName(i);
                if (element != null && element != null) {
                    actuals.add(element);
                }
                ++i;
            }
            retval = new OMArrayList(actuals, fields);
        }
        return retval;
    }

    public void setDigestMethod(List<OMName> digestMethod) {
        for (OMName cosName : digestMethod) {
            if (cosName.equals(OMName.DIGEST_SHA1) || cosName.equals(OMName.DIGEST_SHA256) || cosName.equals(OMName.DIGEST_SHA384) || cosName.equals(OMName.DIGEST_SHA512) || cosName.equals(OMName.DIGEST_RIPEMD160)) continue;
            throw new IllegalArgumentException("Specified digest " + cosName.getName() + " isn't allowed.");
        }
        this.dictionary.setItem(OMName.DIGEST_METHOD, (OMBase)OMArrayList.converterToOMArray(digestMethod));
    }

    public float getV() {
        return this.dictionary.getFloat(OMName.V);
    }

    public void setV(float minimumRequiredCapability) {
        this.dictionary.setFloat(OMName.V, minimumRequiredCapability);
    }

    public List<String> getReasons() {
        OMArrayList retval = null;
        OMArray fields = (OMArray)this.dictionary.getDictionaryObject(OMName.REASONS);
        if (fields != null) {
            ArrayList<String> actuals = new ArrayList<String>();
            int i = 0;
            while (i < fields.size()) {
                String element = fields.getString(i);
                if (element != null && element != null) {
                    actuals.add(element);
                }
                ++i;
            }
            retval = new OMArrayList(actuals, fields);
        }
        return retval;
    }

    public void setReasonsd(List<String> reasons) {
        this.dictionary.setItem(OMName.REASONS, (OMBase)OMArrayList.converterToOMArray(reasons));
    }

    public SMSeedValueMDP getMDP() {
        OMDictionary dict = (OMDictionary)this.dictionary.getDictionaryObject(OMName.MDP);
        SMSeedValueMDP mdp = null;
        if (dict != null) {
            mdp = new SMSeedValueMDP(dict);
        }
        return mdp;
    }

    public void setMPD(SMSeedValueMDP mdp) {
        if (mdp != null) {
            this.dictionary.setItem(OMName.MDP, mdp.getOMObject());
        }
    }

    public SMSeedValueTimeStamp getTimeStamp() {
        OMDictionary dict = (OMDictionary)this.dictionary.getDictionaryObject(OMName.TIME_STAMP);
        SMSeedValueTimeStamp timestamp = null;
        if (dict != null) {
            timestamp = new SMSeedValueTimeStamp(dict);
        }
        return timestamp;
    }

    public void setTimeStamp(SMSeedValueTimeStamp timestamp) {
        if (timestamp != null) {
            this.dictionary.setItem(OMName.TIME_STAMP, timestamp.getOMObject());
        }
    }

    public List<String> getLegalAttestation() {
        OMArrayList retval = null;
        OMArray fields = (OMArray)this.dictionary.getDictionaryObject(OMName.LEGAL_ATTESTATION);
        if (fields != null) {
            ArrayList<String> actuals = new ArrayList<String>();
            int i = 0;
            while (i < fields.size()) {
                String element = fields.getString(i);
                if (element != null && element != null) {
                    actuals.add(element);
                }
                ++i;
            }
            retval = new OMArrayList(actuals, fields);
        }
        return retval;
    }

    public void setLegalAttestation(List<String> legalAttestation) {
        this.dictionary.setItem(OMName.LEGAL_ATTESTATION, (OMBase)OMArrayList.converterToOMArray(legalAttestation));
    }
}

