/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.annotation;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.graphics.SMLineDashPattern;

public class SMBorderStyleDictionary
implements OMObjectable {
    public static final String STYLE_SOLID = "S";
    public static final String STYLE_DASHED = "D";
    public static final String STYLE_BEVELED = "B";
    public static final String STYLE_INSET = "I";
    public static final String STYLE_UNDERLINE = "U";
    private OMDictionary dictionary;

    public SMBorderStyleDictionary() {
        this.dictionary = new OMDictionary();
    }

    public SMBorderStyleDictionary(OMDictionary dict) {
        this.dictionary = dict;
    }

    public OMDictionary getDictionary() {
        return this.dictionary;
    }

    public OMBase getOMObject() {
        return this.dictionary;
    }

    public void setWidth(float w) {
        this.getDictionary().setFloat("W", w);
    }

    public float getWidth() {
        return this.getDictionary().getFloat("W", 1.0f);
    }

    public void setStyle(String s) {
        this.getDictionary().setName(STYLE_SOLID, s);
    }

    public String getStyle() {
        return this.getDictionary().getNameAsString(STYLE_SOLID, STYLE_SOLID);
    }

    public void setDashStyle(SMLineDashPattern d) {
        OMArray array = null;
        if (d != null) {
            array = d.getOMDashPattern();
        }
        this.getDictionary().setItem(STYLE_DASHED, (OMBase)array);
    }

    public SMLineDashPattern getDashStyle() {
        OMArray d = (OMArray)this.getDictionary().getDictionaryObject(STYLE_DASHED);
        if (d == null) {
            d = new OMArray();
            d.add(OMInteger.THREE);
            this.getDictionary().setItem(STYLE_DASHED, (OMBase)d);
        }
        return new SMLineDashPattern(d, 0);
    }
}

