/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.annotation;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMResources;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.util.Matrix;
import java.awt.geom.AffineTransform;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMAppearanceStream
implements OMObjectable {
    private OMStream stream = null;

    public SMAppearanceStream(OMStream s) {
        this.stream = s;
    }

    public OMStream getStream() {
        return this.stream;
    }

    @Override
    public OMBase getOMObject() {
        return this.stream;
    }

    public SMRectangle getBoundingBox() {
        SMRectangle box = null;
        OMArray bbox = (OMArray)this.stream.getDictionaryObject(OMName.BBOX);
        if (bbox != null) {
            box = new SMRectangle(bbox);
        }
        return box;
    }

    public void setBoundingBox(SMRectangle rectangle) {
        OMArray array = null;
        if (rectangle != null) {
            array = rectangle.getOMArray();
        }
        this.stream.setItem(OMName.BBOX, (OMBase)array);
    }

    public SMResources getResources() {
        SMResources retval = null;
        OMDictionary dict = (OMDictionary)this.stream.getDictionaryObject(OMName.RESOURCES);
        if (dict != null) {
            retval = new SMResources(dict);
        }
        return retval;
    }

    public void setResources(SMResources resources) {
        OMDictionary dict = null;
        if (resources != null) {
            dict = resources.getOMDictionary();
        }
        this.stream.setItem(OMName.RESOURCES, (OMBase)dict);
    }

    public Matrix getMatrix() {
        Matrix retval = null;
        OMArray array = (OMArray)this.stream.getDictionaryObject(OMName.MATRIX);
        if (array != null) {
            retval = new Matrix();
            retval.setValue(0, 0, ((OMNumber)array.get(0)).floatValue());
            retval.setValue(0, 1, ((OMNumber)array.get(1)).floatValue());
            retval.setValue(1, 0, ((OMNumber)array.get(2)).floatValue());
            retval.setValue(1, 1, ((OMNumber)array.get(3)).floatValue());
            retval.setValue(2, 0, ((OMNumber)array.get(4)).floatValue());
            retval.setValue(2, 1, ((OMNumber)array.get(5)).floatValue());
        }
        return retval;
    }

    public void setMatrix(AffineTransform transform) {
        if (transform != null) {
            OMArray matrix = new OMArray();
            double[] values = new double[6];
            transform.getMatrix(values);
            double[] dArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                double v = dArray[n2];
                matrix.add(new OMFloat((float)v));
                ++n2;
            }
            this.stream.setItem(OMName.MATRIX, (OMBase)matrix);
        } else {
            this.stream.removeItem(OMName.MATRIX);
        }
    }

    public void setFilters(List<OMName> filters) {
        OMArray obj = OMArrayList.converterToOMArray(filters);
        this.stream.setItem(OMName.FILTER, (OMBase)obj);
    }
}

