/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.annotation;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.interactive.action.SMActionFactory;
import com.plpdf.smmodel.interactive.action.SMAnnotationAdditionalActions;
import com.plpdf.smmodel.interactive.action.type.SMAction;
import com.plpdf.smmodel.interactive.annotation.SMAnnotation;
import com.plpdf.smmodel.interactive.annotation.SMAppearanceCharacteristicsDictionary;
import com.plpdf.smmodel.interactive.annotation.SMBorderStyleDictionary;

public class SMAnnotationWidget
extends SMAnnotation {
    public static final String SUB_TYPE = "Widget";

    public SMAnnotationWidget() {
        this.getDictionary().setName(OMName.SUBTYPE, SUB_TYPE);
    }

    public SMAnnotationWidget(OMDictionary field) {
        super(field);
    }

    public String getHighlightingMode() {
        return this.getDictionary().getNameAsString(OMName.H, "I");
    }

    public void setHighlightingMode(String highlightingMode) {
        if (!(highlightingMode == null || "N".equals(highlightingMode) || "I".equals(highlightingMode) || "O".equals(highlightingMode) || "P".equals(highlightingMode) || "T".equals(highlightingMode))) {
            throw new IllegalArgumentException("Valid values for highlighting mode are 'N', 'N', 'O', 'P' or 'T'");
        }
        this.getDictionary().setName(OMName.H, highlightingMode);
    }

    public SMAppearanceCharacteristicsDictionary getAppearanceCharacteristics() {
        OMBase mk = this.getDictionary().getDictionaryObject(OMName.getPDFName("MK"));
        if (mk instanceof OMDictionary) {
            return new SMAppearanceCharacteristicsDictionary((OMDictionary)mk);
        }
        return null;
    }

    public void setAppearanceCharacteristics(SMAppearanceCharacteristicsDictionary appearanceCharacteristics) {
        this.getDictionary().setItem("MK", (OMObjectable)appearanceCharacteristics);
    }

    public SMAction getAction() {
        OMDictionary action = (OMDictionary)this.getDictionary().getDictionaryObject(OMName.A);
        return SMActionFactory.createAction(action);
    }

    public void setAction(SMAction action) {
        this.getDictionary().setItem(OMName.A, (OMObjectable)action);
    }

    public SMAnnotationAdditionalActions getActions() {
        OMDictionary aa = (OMDictionary)this.getDictionary().getDictionaryObject("AA");
        SMAnnotationAdditionalActions retval = null;
        if (aa != null) {
            retval = new SMAnnotationAdditionalActions(aa);
        }
        return retval;
    }

    public void setActions(SMAnnotationAdditionalActions actions) {
        this.getDictionary().setItem("AA", (OMObjectable)actions);
    }

    public void setBorderStyle(SMBorderStyleDictionary bs) {
        this.getDictionary().setItem("BS", (OMObjectable)bs);
    }

    public SMBorderStyleDictionary getBorderStyle() {
        OMDictionary bs = (OMDictionary)this.getDictionary().getItem(OMName.getPDFName("BS"));
        if (bs != null) {
            return new SMBorderStyleDictionary(bs);
        }
        return null;
    }
}

