/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.annotation;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMTextStream;
import com.plpdf.smmodel.interactive.annotation.SMAnnotation;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationPopup;
import com.plpdf.smmodel.interactive.annotation.SMExternalDataDictionary;
import java.io.IOException;
import java.util.Calendar;

public class SMAnnotationMarkup
extends SMAnnotation {
    public static final String SUB_TYPE_FREETEXT = "FreeText";
    public static final String SUB_TYPE_POLYGON = "Polygon";
    public static final String SUB_TYPE_POLYLINE = "PolyLine";
    public static final String SUB_TYPE_CARET = "Caret";
    public static final String SUB_TYPE_INK = "Ink";
    public static final String SUB_TYPE_SOUND = "Sound";
    public static final String RT_REPLY = "R";
    public static final String RT_GROUP = "Group";

    public SMAnnotationMarkup() {
    }

    public SMAnnotationMarkup(OMDictionary dict) {
        super(dict);
    }

    public String getTitlePopup() {
        return this.getDictionary().getString("T");
    }

    public void setTitlePopup(String t) throws IOException {
        this.getDictionary().setString("T", t);
    }

    public SMAnnotationPopup getPopup() {
        OMDictionary popup = (OMDictionary)this.getDictionary().getDictionaryObject("Popup");
        if (popup != null) {
            return new SMAnnotationPopup(popup);
        }
        return null;
    }

    public void setPopup(SMAnnotationPopup popup) {
        this.getDictionary().setItem("Popup", (OMObjectable)popup);
    }

    public float getConstantOpacity() {
        return this.getDictionary().getFloat("CA", 1.0f);
    }

    public void setConstantOpacity(float ca) {
        this.getDictionary().setFloat("CA", ca);
    }

    public SMTextStream getRichContents() {
        OMBase rc = this.getDictionary().getDictionaryObject("RC");
        if (rc != null) {
            return SMTextStream.createTextStream(rc);
        }
        return null;
    }

    public void setRichContents(SMTextStream rc) {
        this.getDictionary().setItem("RC", (OMObjectable)rc);
    }

    public Calendar getCreationDate() throws IOException {
        return this.getDictionary().getDate("CreationDate");
    }

    public void setCreationDate(Calendar creationDate) throws IOException {
        this.getDictionary().setDate("CreationDate", creationDate);
    }

    public SMAnnotation getInReplyTo() throws IOException {
        OMBase irt = this.getDictionary().getDictionaryObject("IRT");
        return SMAnnotation.createAnnotation(irt);
    }

    public void setInReplyTo(SMAnnotation irt) {
        this.getDictionary().setItem("IRT", (OMObjectable)irt);
    }

    public String getSubject() {
        return this.getDictionary().getString("Subj");
    }

    public void setSubject(String subj) throws IOException {
        this.getDictionary().setString("Subj", subj);
    }

    public String getReplyType() {
        return this.getDictionary().getNameAsString("RT", RT_REPLY);
    }

    public void setReplyType(String rt) {
        this.getDictionary().setName("RT", rt);
    }

    public String getIntent() {
        return this.getDictionary().getNameAsString("IT");
    }

    public void setIntent(String it) {
        this.getDictionary().setName("IT", it);
    }

    public SMExternalDataDictionary getExternalData() {
        OMBase exData = this.getDictionary().getDictionaryObject("ExData");
        if (exData instanceof OMDictionary) {
            return new SMExternalDataDictionary((OMDictionary)exData);
        }
        return null;
    }

    public void setExternalData(SMExternalDataDictionary externalData) {
        this.getDictionary().setItem("ExData", (OMObjectable)externalData);
    }
}

