/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.annotation;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.graphics.optionalcontent.SMOptionalContentGroup;
import com.plpdf.smmodel.interactive.action.SMActionFactory;
import com.plpdf.smmodel.interactive.action.type.SMAction;
import com.plpdf.smmodel.interactive.action.type.SMActionURI;
import com.plpdf.smmodel.interactive.annotation.SMAnnotation;
import com.plpdf.smmodel.interactive.annotation.SMBorderStyleDictionary;
import com.plpdf.smmodel.interactive.documentnavigation.destination.SMDestination;
import java.io.IOException;

public class SMAnnotationLink
extends SMAnnotation {
    public static final String HIGHLIGHT_MODE_NONE = "N";
    public static final String HIGHLIGHT_MODE_INVERT = "I";
    public static final String HIGHLIGHT_MODE_OUTLINE = "O";
    public static final String HIGHLIGHT_MODE_PUSH = "P";
    public static final String SUB_TYPE = "Link";

    public SMAnnotationLink() {
        this.getDictionary().setItem(OMName.SUBTYPE, (OMBase)OMName.getPDFName(SUB_TYPE));
    }

    public SMAnnotationLink(OMDictionary field) {
        super(field);
    }

    public SMAction getAction() {
        OMDictionary action = (OMDictionary)this.getDictionary().getDictionaryObject(OMName.A);
        return SMActionFactory.createAction(action);
    }

    public void setAction(SMAction action) {
        this.getDictionary().setItem(OMName.A, (OMObjectable)action);
    }

    public void setBorderStyle(SMBorderStyleDictionary bs) {
        this.getDictionary().setItem("BS", (OMObjectable)bs);
    }

    public SMBorderStyleDictionary getBorderStyle() {
        OMDictionary bs = (OMDictionary)this.getDictionary().getItem(OMName.getPDFName("BS"));
        if (bs != null) {
            return new SMBorderStyleDictionary(bs);
        }
        return null;
    }

    public SMDestination getDestination() throws IOException {
        OMBase base = this.getDictionary().getDictionaryObject(OMName.DEST);
        SMDestination retval = SMDestination.create(base);
        return retval;
    }

    public void setDestination(SMDestination dest) {
        this.getDictionary().setItem(OMName.DEST, (OMObjectable)dest);
    }

    public String getHighlightMode() {
        return this.getDictionary().getNameAsString(OMName.H, HIGHLIGHT_MODE_INVERT);
    }

    public void setHighlightMode(String mode) {
        this.getDictionary().setName(OMName.H, mode);
    }

    public void setPreviousURI(SMActionURI pa) {
        this.getDictionary().setItem("PA", (OMObjectable)pa);
    }

    public SMActionURI getPreviousURI() {
        OMDictionary pa = (OMDictionary)this.getDictionary().getDictionaryObject("PA");
        if (pa != null) {
            return new SMActionURI(pa);
        }
        return null;
    }

    public void setQuadPoints(float[] quadPoints) {
        OMArray newQuadPoints = new OMArray();
        newQuadPoints.setFloatArray(quadPoints);
        this.getDictionary().setItem("QuadPoints", (OMBase)newQuadPoints);
    }

    public float[] getQuadPoints() {
        OMArray quadPoints = (OMArray)this.getDictionary().getDictionaryObject("QuadPoints");
        if (quadPoints != null) {
            return quadPoints.toFloatArray();
        }
        return null;
    }

    public void setLayer(SMOptionalContentGroup layer) {
        this.getDictionary().setItem("OC", (OMObjectable)layer);
    }
}

