/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.annotation;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.graphics.color.SMGamma;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationMarkup;
import com.plpdf.smmodel.interactive.annotation.SMBorderStyleDictionary;
import java.io.IOException;

public class SMAnnotationLine
extends SMAnnotationMarkup {
    public static final String IT_LINE_ARROW = "LineArrow";
    public static final String IT_LINE_DIMENSION = "LineDimension";
    public static final String LE_SQUARE = "Square";
    public static final String LE_CIRCLE = "Circle";
    public static final String LE_DIAMOND = "Diamond";
    public static final String LE_OPEN_ARROW = "OpenArrow";
    public static final String LE_CLOSED_ARROW = "ClosedArrow";
    public static final String LE_NONE = "None";
    public static final String LE_BUTT = "Butt";
    public static final String LE_R_OPEN_ARROW = "ROpenArrow";
    public static final String LE_R_CLOSED_ARROW = "RClosedArrow";
    public static final String LE_SLASH = "Slash";
    public static final String SUB_TYPE = "Line";

    public SMAnnotationLine() {
        this.getDictionary().setItem(OMName.SUBTYPE, (OMBase)OMName.getPDFName(SUB_TYPE));
        this.setLine(new float[]{0.0f, 0.0f, 0.0f, 0.0f});
    }

    public SMAnnotationLine(OMDictionary field) {
        super(field);
    }

    public void setLine(float[] l) {
        OMArray newL = new OMArray();
        newL.setFloatArray(l);
        this.getDictionary().setItem("L", (OMBase)newL);
    }

    public float[] getLine() {
        OMArray l = (OMArray)this.getDictionary().getDictionaryObject("L");
        return l.toFloatArray();
    }

    public void setStartPointEndingStyle(String style) {
        OMArray array;
        if (style == null) {
            style = LE_NONE;
        }
        if ((array = (OMArray)this.getDictionary().getDictionaryObject("LE")) == null) {
            array = new OMArray();
            array.add(OMName.getPDFName(style));
            array.add(OMName.getPDFName(LE_NONE));
            this.getDictionary().setItem("LE", (OMBase)array);
        } else {
            array.setName(0, style);
        }
    }

    public String getStartPointEndingStyle() {
        String retval = LE_NONE;
        OMArray array = (OMArray)this.getDictionary().getDictionaryObject("LE");
        if (array != null) {
            retval = array.getName(0);
        }
        return retval;
    }

    public void setEndPointEndingStyle(String style) {
        OMArray array;
        if (style == null) {
            style = LE_NONE;
        }
        if ((array = (OMArray)this.getDictionary().getDictionaryObject("LE")) == null) {
            array = new OMArray();
            array.add(OMName.getPDFName(LE_NONE));
            array.add(OMName.getPDFName(style));
            this.getDictionary().setItem("LE", (OMBase)array);
        } else {
            array.setName(1, style);
        }
    }

    public String getEndPointEndingStyle() {
        String retval = LE_NONE;
        OMArray array = (OMArray)this.getDictionary().getDictionaryObject("LE");
        if (array != null) {
            retval = array.getName(1);
        }
        return retval;
    }

    public void setInteriorColour(SMGamma ic) {
        this.getDictionary().setItem("IC", (OMObjectable)ic);
    }

    public SMGamma getInteriorColour() {
        OMArray ic = (OMArray)this.getDictionary().getDictionaryObject("IC");
        if (ic != null) {
            return new SMGamma(ic);
        }
        return null;
    }

    public void setCaption(boolean cap) {
        this.getDictionary().setBoolean("Cap", cap);
    }

    public boolean getCaption() {
        return this.getDictionary().getBoolean("Cap", false);
    }

    public void setBorderStyle(SMBorderStyleDictionary bs) {
        this.getDictionary().setItem("BS", (OMObjectable)bs);
    }

    public SMBorderStyleDictionary getBorderStyle() {
        OMDictionary bs = (OMDictionary)this.getDictionary().getItem(OMName.getPDFName("BS"));
        if (bs != null) {
            return new SMBorderStyleDictionary(bs);
        }
        return null;
    }

    public float getLeaderLineLength() {
        return this.getDictionary().getFloat("LL");
    }

    public void setLeaderLineLength(float leaderLineLength) {
        this.getDictionary().setFloat("LL", leaderLineLength);
    }

    public float getLeaderLineExtensionLength() {
        return this.getDictionary().getFloat("LLE");
    }

    public void setLeaderLineExtensionLength(float leaderLineExtensionLength) {
        this.getDictionary().setFloat("LLE", leaderLineExtensionLength);
    }

    public float getLeaderLineOffsetLength() {
        return this.getDictionary().getFloat("LLO");
    }

    public void setLeaderLineOffsetLength(float leaderLineOffsetLength) {
        this.getDictionary().setFloat("LLO", leaderLineOffsetLength);
    }

    public String getCaptionPositioning() {
        return this.getDictionary().getString("CP");
    }

    public void setCaptionPositioning(String captionPositioning) throws IOException {
        this.getDictionary().setString("CP", captionPositioning);
    }

    public void setCaptionHorizontalOffset(float offset) {
        OMArray array = (OMArray)this.getDictionary().getDictionaryObject("CO");
        if (array == null) {
            array = new OMArray();
            array.setFloatArray(new float[]{offset, 0.0f});
            this.getDictionary().setItem("CO", (OMBase)array);
        } else {
            array.set(0, new OMFloat(offset));
        }
    }

    public float getCaptionHorizontalOffset() {
        float retval = 0.0f;
        OMArray array = (OMArray)this.getDictionary().getDictionaryObject("CO");
        if (array != null) {
            retval = array.toFloatArray()[0];
        }
        return retval;
    }

    public void setCaptionVerticalOffset(float offset) {
        OMArray array = (OMArray)this.getDictionary().getDictionaryObject("CO");
        if (array == null) {
            array = new OMArray();
            array.setFloatArray(new float[]{0.0f, offset});
            this.getDictionary().setItem("CO", (OMBase)array);
        } else {
            array.set(1, new OMFloat(offset));
        }
    }

    public float getCaptionVerticalOffset() {
        float retval = 0.0f;
        OMArray array = (OMArray)this.getDictionary().getDictionaryObject("CO");
        if (array != null) {
            retval = array.toFloatArray()[1];
        }
        return retval;
    }
}

