/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.annotation;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.graphics.color.SMGamma;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationFileAttachment;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationLine;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationLink;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationMarkup;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationPopup;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationRubberStamp;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationSquareCircle;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationText;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationTextMarkup;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationUnknown;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationWidget;
import com.plpdf.smmodel.interactive.annotation.SMAppearanceCharacteristicsDictionary;
import com.plpdf.smmodel.interactive.annotation.SMAppearanceDictionary;
import com.plpdf.util.BitFlagHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class SMAnnotation
implements OMObjectable {
    public static final int FLAG_INVISIBLE = 1;
    public static final int FLAG_HIDDEN = 2;
    public static final int FLAG_PRINTED = 4;
    public static final int FLAG_NO_ZOOM = 8;
    public static final int FLAG_NO_ROTATE = 16;
    public static final int FLAG_NO_VIEW = 32;
    public static final int FLAG_READ_ONLY = 64;
    public static final int FLAG_LOCKED = 128;
    public static final int FLAG_TOGGLE_NO_VIEW = 256;
    private OMDictionary dictionary;

    public static SMAnnotation createAnnotation(OMBase base) throws IOException {
        SMAnnotation annot = null;
        if (base instanceof OMDictionary) {
            OMDictionary annotDic = (OMDictionary)base;
            String subtype = annotDic.getNameAsString(OMName.SUBTYPE);
            annot = "FileAttachment".equals(subtype) ? new SMAnnotationFileAttachment(annotDic) : ("Line".equals(subtype) ? new SMAnnotationLine(annotDic) : ("Link".equals(subtype) ? new SMAnnotationLink(annotDic) : ("Popup".equals(subtype) ? new SMAnnotationPopup(annotDic) : ("Stamp".equals(subtype) ? new SMAnnotationRubberStamp(annotDic) : ("Square".equals(subtype) || "Circle".equals(subtype) ? new SMAnnotationSquareCircle(annotDic) : ("Text".equals(subtype) ? new SMAnnotationText(annotDic) : ("Highlight".equals(subtype) || "Underline".equals(subtype) || "Squiggly".equals(subtype) || "StrikeOut".equals(subtype) ? new SMAnnotationTextMarkup(annotDic) : ("Link".equals(subtype) ? new SMAnnotationLink(annotDic) : ("Widget".equals(subtype) ? new SMAnnotationWidget(annotDic) : ("FreeText".equals(subtype) || "Polygon".equals(subtype) || "PolyLine".equals(subtype) || "Caret".equals(subtype) || "Ink".equals(subtype) || "Sound".equals(subtype) ? new SMAnnotationMarkup(annotDic) : new SMAnnotationUnknown(annotDic)))))))))));
        } else {
            throw new IOException("Error: Unknown annotation type " + base);
        }
        return annot;
    }

    public SMAnnotation() {
        this.dictionary = new OMDictionary();
        this.dictionary.setItem(OMName.TYPE, (OMBase)OMName.ANNOT);
    }

    public SMAnnotation(OMDictionary dict) {
        this.dictionary = dict;
    }

    public OMDictionary getDictionary() {
        return this.dictionary;
    }

    public SMRectangle getRectangle() {
        OMArray rectArray = (OMArray)this.dictionary.getDictionaryObject(OMName.RECT);
        SMRectangle rectangle = null;
        if (rectArray != null) {
            rectangle = new SMRectangle(rectArray);
        }
        return rectangle;
    }

    public void setRectangle(SMRectangle rectangle) {
        this.dictionary.setItem(OMName.RECT, (OMBase)rectangle.getOMArray());
    }

    public void setRectangle(float x, float y, float width, float height) {
        SMRectangle r = new SMRectangle(width, height);
        r.move(x, y);
        this.setRectangle(r);
    }

    public int getAnnotationFlags() {
        return this.getDictionary().getInt(OMName.F, 0);
    }

    public void setAnnotationFlags(int flags) {
        this.getDictionary().setInt(OMName.F, flags);
    }

    public OMBase getOMObject() {
        return this.getDictionary();
    }

    public String getAppearanceStream() {
        String retval = null;
        OMName name = (OMName)this.getDictionary().getDictionaryObject(OMName.AS);
        if (name != null) {
            retval = name.getName();
        }
        return retval;
    }

    public void setAppearanceStream(String as) {
        if (as == null) {
            this.getDictionary().removeItem(OMName.AS);
        } else {
            this.getDictionary().setItem(OMName.AS, (OMBase)OMName.getPDFName(as));
        }
    }

    public SMAppearanceDictionary getAppearance() {
        SMAppearanceDictionary ap = null;
        OMDictionary apDic = (OMDictionary)this.dictionary.getDictionaryObject(OMName.AP);
        if (apDic != null) {
            ap = new SMAppearanceDictionary(apDic);
        }
        return ap;
    }

    public void setAppearance(SMAppearanceDictionary appearance) {
        OMDictionary ap = null;
        if (appearance != null) {
            ap = appearance.getDictionary();
        }
        this.dictionary.setItem(OMName.AP, (OMBase)ap);
    }

    public boolean isInvisible() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.F, 1);
    }

    public void setInvisible(boolean invisible) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.F, 1, invisible);
    }

    public boolean isHidden() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.F, 2);
    }

    public void setHidden(boolean hidden) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.F, 2, hidden);
    }

    public boolean isPrinted() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.F, 4);
    }

    public void setPrinted(boolean printed) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.F, 4, printed);
    }

    public boolean isNoZoom() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.F, 8);
    }

    public void setNoZoom(boolean noZoom) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.F, 8, noZoom);
    }

    public boolean isNoRotate() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.F, 16);
    }

    public void setNoRotate(boolean noRotate) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.F, 16, noRotate);
    }

    public boolean isNoView() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.F, 32);
    }

    public void setNoView(boolean noView) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.F, 32, noView);
    }

    public boolean isReadOnly() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.F, 64);
    }

    public void setReadOnly(boolean readOnly) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.F, 64, readOnly);
    }

    public boolean isLocked() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.F, 128);
    }

    public void setLocked(boolean locked) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.F, 128, locked);
    }

    public boolean isToggleNoView() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.F, 256);
    }

    public void setToggleNoView(boolean toggleNoView) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.F, 256, toggleNoView);
    }

    public String getContents() {
        return this.dictionary.getString(OMName.CONTENTS);
    }

    public void setContents(String value) throws IOException {
        this.dictionary.setString(OMName.CONTENTS, value);
    }

    public String getModifiedDate() {
        return this.getDictionary().getString(OMName.M);
    }

    public void setModifiedDate(String m) throws IOException {
        this.getDictionary().setString(OMName.M, m);
    }

    public String getAnnotationName() {
        return this.getDictionary().getString(OMName.NM);
    }

    public void setAnnotationName(String nm) throws IOException {
        this.getDictionary().setString(OMName.NM, nm);
    }

    public int getStructParent() {
        return this.getDictionary().getInt(OMName.STRUCT_PARENT, 0);
    }

    public void setStructParent(int structParent) {
        this.getDictionary().setInt(OMName.STRUCT_PARENT, structParent);
    }

    public void setColour(SMGamma c) {
        this.getDictionary().setItem(OMName.C, (OMObjectable)c);
    }

    public SMGamma getColour() {
        OMArray c = (OMArray)this.getDictionary().getItem(OMName.C);
        if (c != null) {
            return new SMGamma(c);
        }
        return null;
    }

    public String getSubtype() {
        return this.getDictionary().getNameAsString(OMName.SUBTYPE);
    }

    public void setPage(SMPage page) {
        this.getDictionary().setItem(OMName.P, (OMObjectable)page);
    }

    public SMPage getPage() {
        OMDictionary p = (OMDictionary)this.getDictionary().getDictionaryObject(OMName.P);
        if (p != null) {
            return new SMPage(p);
        }
        return null;
    }

    public void setBorder(List items) throws IOException, PlpdfException {
        this.getDictionary().setItem(OMName.BORDER, (OMBase)OMArrayList.converterToOMArray(items));
    }

    public void setNoBorder() throws IOException, PlpdfException {
        ArrayList<OMInteger> items = new ArrayList<OMInteger>();
        items.add(new OMInteger(0));
        items.add(new OMInteger(0));
        items.add(new OMInteger(0));
        this.setBorder(items);
    }

    public SMAppearanceCharacteristicsDictionary getAppearanceCharacteristics() {
        OMBase mk = this.getDictionary().getDictionaryObject(OMName.getPDFName("MK"));
        if (mk instanceof OMDictionary) {
            return new SMAppearanceCharacteristicsDictionary((OMDictionary)mk);
        }
        return null;
    }
}

