/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.xobject.png;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.graphics.xobject.SMXObjectImage;
import com.plpdf.smmodel.graphics.xobject.png.ImageParser;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SMImageRaw
extends SMXObjectImage {
    private static final String CLASS_NAME = SMXObjectImage.class.getName();

    public SMImageRaw(SMDocument doc, ImageParser image, SMXObjectImage maskImage) throws PlpdfException, IOException {
        super(new SMStream(doc, image.getData(), false), "png");
        OMStream dic = this.getOMStream();
        dic.setItem(OMName.SUBTYPE, (OMBase)OMName.IMAGE);
        dic.setItem(OMName.FILTER, (OMBase)OMName.FLATE_DECODE);
        dic.getFilteredStream();
        dic.setItem(OMName.WIDTH, (OMBase)new OMFloat(image.getWidth()));
        dic.setItem(OMName.HEIGHT, (OMBase)new OMFloat(image.getHeight()));
        if (image.isMask() && (image.getBpc() == 1 || image.getBpc() > 255)) {
            dic.setBoolean(OMName.IMAGEMASK, true);
        }
        if (maskImage != null) {
            if (image.isSmask()) {
                dic.setItem(OMName.SMASK, (OMObjectable)maskImage);
            } else {
                dic.setItem(OMName.MASK, (OMObjectable)maskImage);
            }
        }
        if (image.isMask() && image.isInverted()) {
            dic.setString(OMName.DECODE, "[1 0]");
        }
        if (image.isInterpolation()) {
            dic.setBoolean(OMName.INTERPOLATE, true);
        }
        InputStream is = null;
        try {
            if (image.isImgRaw()) {
                int bpc;
                int k;
                int colorspace = image.getColorspace();
                int[] transparency = image.getTransparency();
                if (transparency != null && !image.isMask() && maskImage == null) {
                    String s = "[";
                    k = 0;
                    while (k < transparency.length) {
                        s = String.valueOf(s) + transparency[k] + " ";
                        ++k;
                    }
                    s = String.valueOf(s) + "]";
                    dic.setString(OMName.MASK, s);
                }
                if ((bpc = image.getBpc()) > 255) {
                    if (!image.isMask()) {
                        dic.setItem(OMName.COLORSPACE, (OMBase)OMName.DEVICEGRAY);
                    }
                    dic.setInt(OMName.BITSPERCOMPONENT, 1);
                    dic.setItem(OMName.FILTER, (OMBase)OMName.CCITTFAXDECODE);
                    k = bpc - 257;
                    OMDictionary decodeparms = new OMDictionary();
                    if (k != 0) {
                        decodeparms.setInt(OMName.K, k);
                    }
                    if ((colorspace & 1) != 0) {
                        decodeparms.setBoolean(OMName.BLACKIS1, true);
                    }
                    if ((colorspace & 2) != 0) {
                        decodeparms.setBoolean(OMName.ENCODEDBYTEALIGN, true);
                    }
                    if ((colorspace & 4) != 0) {
                        decodeparms.setBoolean(OMName.ENDOFLINE, true);
                    }
                    if ((colorspace & 8) != 0) {
                        decodeparms.setBoolean(OMName.ENDOFBLOCK, true);
                    }
                    decodeparms.setFloat(OMName.COLUMNS, image.getWidth());
                    decodeparms.setFloat(OMName.ROWS, image.getHeight());
                    dic.setItem(OMName.DECODEPARMS, (OMBase)decodeparms);
                } else {
                    OMDictionary additional;
                    switch (colorspace) {
                        case 1: {
                            dic.setItem(OMName.COLORSPACE, (OMBase)OMName.DEVICEGRAY);
                            if (!image.isInverted()) break;
                            dic.setString(OMName.DECODE, "[1 0]");
                            break;
                        }
                        case 3: {
                            dic.setItem(OMName.COLORSPACE, (OMBase)OMName.DEVICERGB);
                            if (!image.isInverted()) break;
                            dic.setString(OMName.DECODE, "[1 0 1 0 1 0]");
                            break;
                        }
                        default: {
                            dic.setItem(OMName.COLORSPACE, (OMBase)OMName.DEVICECMYK);
                            if (!image.isInverted()) break;
                            dic.setString(OMName.DECODE, "[1 0 1 0 1 0 1 0]");
                        }
                    }
                    if ((additional = image.getAdditional()) != null) {
                        dic.addAll(additional);
                    }
                    if (image.isMask() && (image.getBpc() == 1 || image.getBpc() > 8)) {
                        dic.removeItem(OMName.COLORSPACE);
                    }
                    dic.setInt(OMName.BITSPERCOMPONENT, image.getBpc());
                }
                return;
            }
            try {
                throw new PlpdfException(CLASS_NAME, "1IsAnUnknownImageFormat");
            }
            catch (IOException ioe) {
                throw new PlpdfException(CLASS_NAME, ioe.getMessage());
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public BufferedImage getRGBImage() throws IOException {
        return null;
    }

    public void write2OutputStream(OutputStream out) throws IOException {
    }
}

