/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.xobject.png;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMDictionary;
import com.plpdf.smmodel.graphics.xobject.SMXObjectImage;
import com.plpdf.smmodel.graphics.xobject.png.ImageRaw;
import com.plpdf.smmodel.graphics.xobject.png.PngParser;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ImageParser {
    private static final String CLASS_NAME = SMXObjectImage.class.getName();
    public static final int CCITTG4 = 256;
    public static final int CCITT_BLACKIS1 = 1;
    public static final int IMGRAW = 34;
    public static final int CCITTG3_1D = 257;
    public static final int CCITTG3_2D = 258;
    public static final int CCITT_ENCODEDBYTEALIGN = 2;
    public static final int CCITT_ENDOFLINE = 4;
    public static final int CCITT_ENDOFBLOCK = 8;
    protected int type;
    protected byte[] rawData;
    protected int bpc = 1;
    protected float plainWidth;
    protected float plainHeight;
    protected boolean interpolation;
    protected byte[] originalData;
    protected int dpiX = 0;
    protected int dpiY = 0;
    private float XYRatio = 0.0f;
    protected int colorspace = -1;
    protected boolean invert = false;
    protected ICC_Profile profile = null;
    private OMDictionary additional = null;
    protected boolean mask = false;
    protected ImageParser imageMask;
    private boolean smask;
    protected int[] transparency;

    public ImageParser() {
    }

    protected ImageParser(ImageParser image) {
        this.type = image.type;
        this.rawData = image.rawData;
        this.bpc = image.bpc;
        this.plainWidth = image.plainWidth;
        this.plainHeight = image.plainHeight;
        this.interpolation = image.interpolation;
        this.originalData = image.originalData;
        this.dpiX = image.dpiX;
        this.dpiY = image.dpiY;
        this.XYRatio = image.XYRatio;
        this.colorspace = image.colorspace;
        this.invert = image.invert;
        this.profile = image.profile;
        this.additional = image.additional;
        this.mask = image.mask;
        this.imageMask = image.imageMask;
        this.smask = image.smask;
        this.transparency = image.transparency;
    }

    public static ImageParser getInstance(byte[] imgb) throws PlpdfException, IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(imgb);
        return ImageParser.getInstance(is);
    }

    public static ImageParser getInstance(InputStream is) throws PlpdfException, IOException {
        return PngParser.getImage(is);
    }

    public static ImageParser getInstance(int width, int height, int components, int bpc, byte[] data) throws PlpdfException {
        return ImageParser.getInstance(width, height, components, bpc, data, null);
    }

    public static ImageParser getInstance(int width, int height, int components, int bpc, byte[] data, int[] transparency) throws PlpdfException {
        if (transparency != null && transparency.length != components * 2) {
            throw new PlpdfException(CLASS_NAME, "TransparencyLengthMustBeEqualToComponentes2");
        }
        if (components == 1 && bpc == 1) {
            throw new PlpdfException(CLASS_NAME, "TCCITTG4EncoderNotSupported");
        }
        ImageRaw img = new ImageRaw(width, height, components, bpc, data);
        img.transparency = transparency;
        return img;
    }

    public static ImageParser getInstance(int width, int height, boolean reverseBits, int typeCCITT, int parameters, byte[] data, int[] transparency) throws PlpdfException {
        if (transparency != null && transparency.length != 2) {
            throw new PlpdfException(CLASS_NAME, "TransparencyLengthMustBeEqualTo2WithCcittImages");
        }
        throw new PlpdfException(CLASS_NAME, "ImgCCITTIsNotSupported");
    }

    public void setAdditional(OMDictionary additional) {
        this.additional = additional;
    }

    public void tagICC(ICC_Profile profile) {
        this.profile = profile;
    }

    public void makeMask() throws PlpdfException {
        if (!this.isMaskCandidate()) {
            throw new PlpdfException(CLASS_NAME, "ThisImageCanNotBeAnImageMask");
        }
        this.mask = true;
    }

    public boolean isMaskCandidate() {
        if (this.type == 34 && this.bpc > 255) {
            return true;
        }
        return this.colorspace == 1;
    }

    public void setImageMask(ImageParser mask) throws PlpdfException {
        if (this.mask) {
            throw new PlpdfException(CLASS_NAME, "AnImageMaskCannotContainAnotherImageMask");
        }
        if (!mask.mask) {
            throw new PlpdfException(CLASS_NAME, "TheImageMaskIsNotAMaskDidYouDoMakemask");
        }
        this.imageMask = mask;
        this.smask = mask.bpc > 1 && mask.bpc <= 8;
    }

    public ImageParser getimageMask() {
        return this.imageMask;
    }

    public void setDpi(int dpiX, int dpiY) {
        this.dpiX = dpiX;
        this.dpiY = dpiY;
    }

    public void setXYRatio(float XYRatio) {
        this.XYRatio = XYRatio;
    }

    public void setOriginalData(byte[] originalData) {
        this.originalData = originalData;
    }

    public boolean isMask() {
        return this.mask;
    }

    public int getBpc() {
        return this.bpc;
    }

    public boolean isSmask() {
        return this.smask;
    }

    public boolean isInverted() {
        return this.invert;
    }

    public boolean isInterpolation() {
        return this.interpolation;
    }

    public boolean isImgRaw() {
        return this.type == 34;
    }

    public int getColorspace() {
        return this.colorspace;
    }

    public int[] getTransparency() {
        return this.transparency;
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    public byte[] getData() {
        if (this.getRawData() == null) {
            return this.originalData;
        }
        return this.rawData;
    }

    public OMDictionary getAdditional() {
        return this.additional;
    }

    public int type() {
        return this.type;
    }

    public byte[] getOriginalData() {
        return this.originalData;
    }

    public float getWidth() {
        return this.plainWidth;
    }

    public float getHeight() {
        return this.plainHeight;
    }

    public boolean hasICCProfile() {
        return this.profile != null;
    }

    public ICC_Profile getICCProfile() {
        return this.profile;
    }
}

