/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.xobject.png;

import java.io.IOException;
import java.io.OutputStream;

public class ByteBuffer
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public ByteBuffer() {
        this(128);
    }

    public ByteBuffer(int size) {
        if (size < 1) {
            size = 128;
        }
        this.buf = new byte[size];
    }

    public ByteBuffer append_i(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
        return this;
    }

    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public ByteBuffer append(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0 || len == 0) {
            return this;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
        return this;
    }

    public ByteBuffer append(byte b) {
        return this.append_i(b);
    }

    public ByteBuffer append(byte[] b) {
        return this.append(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        this.append((byte)b);
    }

    public void write(byte[] b, int off, int len) {
        this.append(b, off, len);
    }

    public void reset() {
        this.count = 0;
    }

    public ByteBuffer append(ByteBuffer buf) {
        return this.append(buf.buf, 0, buf.count);
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int size() {
        return this.count;
    }
}

