/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.xobject;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMColorSpaceFactory;
import com.plpdf.smmodel.graphics.color.SMColorState;
import com.plpdf.smmodel.graphics.color.SMDeviceGray;
import com.plpdf.smmodel.graphics.xobject.CompositeImage;
import com.plpdf.smmodel.graphics.xobject.SMXObject;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class SMXObjectImage
extends SMXObject {
    public static final String SUB_TYPE = "Image";
    private String suffix;
    private SMColorState stencilColor;

    public SMXObjectImage(SMStream imageStream, String fileSuffix) {
        super(imageStream);
        this.suffix = fileSuffix;
    }

    public SMXObjectImage(SMDocument doc, String fileSuffix) {
        super(doc);
        this.getOMStream().setName(OMName.SUBTYPE, SUB_TYPE);
        this.suffix = fileSuffix;
    }

    public static SMXObject createThumbnailXObject(OMBase xobject) throws IOException {
        SMXObject retval = SMXObjectImage.commonXObjectCreation(xobject, true);
        return retval;
    }

    public abstract BufferedImage getRGBImage() throws IOException;

    public SMXObjectImage getSMaskImage() throws IOException {
        OMStream cosStream = this.getSMStream().getStream();
        OMBase smask = cosStream.getDictionaryObject(OMName.SMASK);
        if (smask == null) {
            return null;
        }
        return (SMXObjectImage)SMXObject.createXObject(smask);
    }

    public BufferedImage applyMasks(BufferedImage baseImage) throws IOException {
        if (this.getImageMask()) {
            return this.imageMask(baseImage);
        }
        if (this.getMask() != null) {
            return this.mask(baseImage);
        }
        SMXObjectImage smask = this.getSMaskImage();
        if (smask != null) {
            BufferedImage smaskBI = smask.getRGBImage();
            OMArray decodeArray = smask.getDecode();
            CompositeImage compositeImage = new CompositeImage(baseImage, smaskBI);
            BufferedImage rgbImage = compositeImage.createMaskedImage(decodeArray);
            return rgbImage;
        }
        return baseImage;
    }

    public boolean hasMask() throws IOException {
        return this.getImageMask() || this.getMask() != null || this.getSMaskImage() != null;
    }

    public BufferedImage imageMask(BufferedImage baseImage) throws IOException {
        BufferedImage stencilMask = new BufferedImage(baseImage.getWidth(), baseImage.getHeight(), 2);
        Graphics2D graphics = (Graphics2D)stencilMask.getGraphics();
        if (this.getStencilColor() != null) {
            graphics.setColor(this.getStencilColor().getJavaColor());
        } else {
            graphics.setColor(Color.BLACK);
        }
        graphics.fillRect(0, 0, baseImage.getWidth(), baseImage.getHeight());
        graphics.setComposite(AlphaComposite.DstIn);
        graphics.drawImage(baseImage, null, 0, 0);
        return stencilMask;
    }

    public BufferedImage mask(BufferedImage baseImage) throws IOException {
        OMBase mask = this.getMask();
        if (mask instanceof OMStream) {
            SMXObjectImage maskImageRef = (SMXObjectImage)SMXObject.createXObject((OMStream)mask);
            BufferedImage maskImage = maskImageRef.getRGBImage();
            if (maskImage == null) {
                return baseImage;
            }
            BufferedImage newImage = new BufferedImage(maskImage.getWidth(), maskImage.getHeight(), 2);
            Graphics2D graphics = (Graphics2D)newImage.getGraphics();
            graphics.drawImage(baseImage, 0, 0, maskImage.getWidth(), maskImage.getHeight(), 0, 0, baseImage.getWidth(), baseImage.getHeight(), null);
            graphics.setComposite(AlphaComposite.DstIn);
            graphics.drawImage(maskImage, null, 0, 0);
            return newImage;
        }
        return baseImage;
    }

    public abstract void write2OutputStream(OutputStream var1) throws IOException;

    public void write2file(String filename) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(String.valueOf(filename) + "." + this.suffix);
            this.write2OutputStream(out);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public void write2file(File file) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            this.write2OutputStream(out);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public int getHeight() {
        return this.getOMStream().getInt(OMName.HEIGHT, -1);
    }

    public void setHeight(int height) {
        this.getOMStream().setInt(OMName.HEIGHT, height);
    }

    public int getWidth() {
        return this.getOMStream().getInt(OMName.WIDTH, -1);
    }

    public void setWidth(int width) {
        this.getOMStream().setInt(OMName.WIDTH, width);
    }

    public int getBitsPerComponent() {
        return this.getOMStream().getInt(OMName.BITS_PER_COMPONENT, OMName.BPC, -1);
    }

    public void setBitsPerComponent(int bpc) {
        this.getOMStream().setInt(OMName.BITS_PER_COMPONENT, bpc);
    }

    public SMColorSpace getColorSpace() throws IOException {
        OMBase cs = this.getOMStream().getDictionaryObject(OMName.COLORSPACE, OMName.CS);
        SMColorSpace retval = null;
        if (cs != null) {
            retval = SMColorSpaceFactory.createColorSpace(cs);
        } else {
            OMBase filter = this.getOMStream().getDictionaryObject(OMName.FILTER);
            if (OMName.CCITTFAX_DECODE.equals(filter) || OMName.CCITTFAX_DECODE_ABBREVIATION.equals(filter)) {
                retval = new SMDeviceGray();
            } else if (OMName.JBIG2_DECODE.equals(filter)) {
                retval = new SMDeviceGray();
            } else if (this.getImageMask()) {
                retval = new SMDeviceGray();
            }
        }
        return retval;
    }

    public void setColorSpace(SMColorSpace cs) {
        OMBase base = null;
        if (cs != null) {
            base = cs.getOMObject();
        }
        this.getOMStream().setItem(OMName.COLORSPACE, base);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean getImageMask() {
        return this.getOMStream().getBoolean(OMName.IMAGE_MASK, false);
    }

    public void setStencilColor(SMColorState stencilColorValue) {
        this.stencilColor = stencilColorValue;
    }

    public SMColorState getStencilColor() {
        return this.stencilColor;
    }

    public OMArray getDecode() {
        OMBase decode = this.getOMStream().getDictionaryObject(OMName.DECODE);
        if (decode != null && decode instanceof OMArray) {
            return (OMArray)decode;
        }
        return null;
    }

    public OMBase getMask() {
        OMBase mask = this.getOMStream().getDictionaryObject(OMName.MASK);
        if (mask != null) {
            return mask;
        }
        return null;
    }
}

