/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.xobject;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMResources;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.graphics.xobject.SMXObject;
import com.plpdf.util.Matrix;
import java.awt.geom.AffineTransform;

public class SMXObjectForm
extends SMXObject {
    public static final String SUB_TYPE = "Form";

    public SMXObjectForm(SMStream formStream) {
        super(formStream);
        this.getOMStream().setName(OMName.SUBTYPE, SUB_TYPE);
    }

    public SMXObjectForm(OMStream formStream) {
        super(formStream);
        this.getOMStream().setName(OMName.SUBTYPE, SUB_TYPE);
    }

    public int getFormType() {
        return this.getOMStream().getInt("FormType", 1);
    }

    public void setFormType(int formType) {
        this.getOMStream().setInt("FormType", formType);
    }

    public SMResources getResources() {
        SMResources retval = null;
        OMDictionary resources = (OMDictionary)this.getOMStream().getDictionaryObject(OMName.RESOURCES);
        if (resources != null) {
            retval = new SMResources(resources);
        }
        return retval;
    }

    public void setResources(SMResources resources) {
        this.getOMStream().setItem(OMName.RESOURCES, (OMObjectable)resources);
    }

    public SMRectangle getBBox() {
        SMRectangle retval = null;
        OMArray array = (OMArray)this.getOMStream().getDictionaryObject(OMName.BBOX);
        if (array != null) {
            retval = new SMRectangle(array);
        }
        return retval;
    }

    public void setBBox(SMRectangle bbox) {
        if (bbox == null) {
            this.getOMStream().removeItem(OMName.BBOX);
        } else {
            this.getOMStream().setItem(OMName.BBOX, (OMBase)bbox.getOMArray());
        }
    }

    public Matrix getMatrix() {
        Matrix retval = null;
        OMArray array = (OMArray)this.getOMStream().getDictionaryObject(OMName.MATRIX);
        if (array != null) {
            retval = new Matrix();
            retval.setValue(0, 0, ((OMNumber)array.get(0)).floatValue());
            retval.setValue(0, 1, ((OMNumber)array.get(1)).floatValue());
            retval.setValue(1, 0, ((OMNumber)array.get(2)).floatValue());
            retval.setValue(1, 1, ((OMNumber)array.get(3)).floatValue());
            retval.setValue(2, 0, ((OMNumber)array.get(4)).floatValue());
            retval.setValue(2, 1, ((OMNumber)array.get(5)).floatValue());
        }
        return retval;
    }

    public void setMatrix(AffineTransform transform) {
        OMArray matrix = new OMArray();
        double[] values = new double[6];
        transform.getMatrix(values);
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            matrix.add(new OMFloat((float)v));
            ++n2;
        }
        this.getOMStream().setItem(OMName.MATRIX, (OMBase)matrix);
    }

    public SMXObjectForm(SMDocument doc) throws PlpdfException {
        super(doc);
        this.getOMStream().setName(OMName.SUBTYPE, SUB_TYPE);
    }

    public void setBBox(float x, float y, float width, float height) throws PlpdfException {
        SMRectangle r = new SMRectangle(width, height);
        r.move(x, y);
        this.getOMStream().setItem(OMName.BBOX, (OMBase)r.getOMArray());
    }

    public int getStructParents() {
        return this.getOMStream().getInt(OMName.STRUCT_PARENTS, 0);
    }

    public void setStructParents(int structParent) {
        this.getOMStream().setInt(OMName.STRUCT_PARENTS, structParent);
    }
}

