/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.xobject;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMResources;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMMetadata;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.graphics.xobject.SMCcitt;
import com.plpdf.smmodel.graphics.xobject.SMJpeg;
import com.plpdf.smmodel.graphics.xobject.SMPixelMap;
import com.plpdf.smmodel.graphics.xobject.SMXObjectForm;
import java.io.IOException;
import java.util.List;

public abstract class SMXObject
implements OMObjectable {
    private SMStream xobject;

    public SMXObject(OMStream xobj) {
        this.xobject = new SMStream(xobj);
        this.getOMStream().setItem(OMName.TYPE, (OMBase)OMName.XOBJECT);
    }

    public SMXObject(SMStream xobj) {
        this.xobject = xobj;
        this.getOMStream().setItem(OMName.TYPE, (OMBase)OMName.XOBJECT);
    }

    public SMXObject(SMDocument doc) {
        this.xobject = new SMStream(doc);
        this.xobject.getStream().setName(OMName.TYPE, "XObject");
    }

    public OMBase getOMObject() {
        return this.xobject.getOMObject();
    }

    public OMStream getOMStream() {
        return this.xobject.getStream();
    }

    public SMStream getSMStream() {
        return this.xobject;
    }

    public static SMXObject createXObject(OMBase xobject) throws IOException {
        return SMXObject.commonXObjectCreation(xobject, false);
    }

    protected static SMXObject commonXObjectCreation(OMBase xobject, boolean isThumb) {
        SMXObject retval = null;
        if (xobject == null) {
            retval = null;
        } else if (xobject instanceof OMStream) {
            OMStream xstream = (OMStream)xobject;
            String subtype = xstream.getNameAsString(OMName.SUBTYPE);
            if ("Image".equals(subtype) || subtype == null && isThumb) {
                SMStream image = new SMStream(xstream);
                List<OMName> filters = image.getFilters();
                if (filters != null && filters.contains(OMName.DCT_DECODE)) {
                    return new SMJpeg(image);
                }
                if (filters != null && filters.contains(OMName.CCITTFAX_DECODE)) {
                    return new SMCcitt(image);
                }
                if (filters != null && filters.contains(OMName.JPX_DECODE)) {
                    return new SMPixelMap(image);
                }
                retval = new SMPixelMap(image);
            } else if ("Form".equals(subtype)) {
                retval = new SMXObjectForm(xstream);
            }
        }
        return retval;
    }

    public SMMetadata getMetadata() {
        SMMetadata retval = null;
        OMStream mdStream = (OMStream)this.getOMStream().getDictionaryObject(OMName.METADATA);
        if (mdStream != null) {
            retval = new SMMetadata(mdStream);
        }
        return retval;
    }

    public void setMetadata(SMMetadata meta) {
        this.getOMStream().setItem(OMName.METADATA, (OMObjectable)meta);
    }

    public void setSMStream(SMStream xobj) throws PlpdfException {
        this.xobject = xobj;
    }

    public int getStructParent() {
        return this.getOMStream().getInt(OMName.STRUCT_PARENT, 0);
    }

    public void setStructParent(int structParent) {
        this.getOMStream().setInt(OMName.STRUCT_PARENT, structParent);
    }

    public SMResources getResources() {
        SMResources res = null;
        OMDictionary resources = (OMDictionary)this.getOMStream().getDictionaryObject(OMName.RESOURCES);
        if (resources != null) {
            res = new SMResources(resources);
        }
        return res;
    }

    public String getSubtype() {
        return this.getOMStream().getString(OMName.SUBTYPE);
    }
}

