/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.xobject;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMResources;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.edit.SMPageContentStream;
import com.plpdf.smmodel.font.SMFont;
import com.plpdf.smmodel.graphics.SMShadingPattern;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMDeviceCMYK;
import com.plpdf.smmodel.graphics.color.SMDeviceGray;
import com.plpdf.smmodel.graphics.color.SMDeviceRGB;
import com.plpdf.smmodel.graphics.xobject.SMXObject;
import com.plpdf.smmodel.graphics.xobject.SMXObjectForm;
import com.plpdf.smmodel.graphics.xobject.SMXObjectImage;
import com.plpdf.util.MapUtil;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SMTemplateXObject
extends SMXObjectForm {
    private static final String CLASS_NAME = SMPageContentStream.class.getName();
    private NumberFormat formatDecimal = NumberFormat.getNumberInstance(Locale.US);
    public static final int FILL_TEXT = 0;
    public static final int STROKE_TEXT = 1;
    public static final int FILL_THEN_STROKE_TEXT = 2;
    protected ByteArrayOutputStream content = new ByteArrayOutputStream();
    private SMResources resources;
    private Map fontMappings = new HashMap();
    private Map fonts;
    private OutputStream output;
    private boolean inTextMode = false;
    private float[] colorComponents = new float[4];
    private Map opacityMappings = new HashMap();
    private Map opacities;
    private Map xobjectMappings = new HashMap();
    private Map xobjects;
    private Map shadingMappings = new HashMap();
    private Map shadings;

    public SMTemplateXObject(SMDocument doc) throws PlpdfException, IOException {
        super(doc);
        this.resources = this.getResources();
        if (this.resources == null) {
            this.resources = new SMResources();
            this.setResources(this.resources);
        }
        this.fonts = this.resources.getFonts();
        this.opacities = this.resources.getGraphicsStates();
        this.xobjects = this.resources.getImages();
        this.shadings = this.resources.getShadings();
        this.getOMStream().setItem("Filter", (OMBase)OMName.FLATE_DECODE);
        OMStream oms = this.getOMStream();
        this.output = this.getSMStream().createOutputStream();
        OMArray marr = new OMArray();
        marr.add(new OMInteger(1));
        marr.add(new OMInteger(0));
        marr.add(new OMInteger(0));
        marr.add(new OMInteger(1));
        marr.add(new OMInteger(0));
        marr.add(new OMInteger(0));
        this.getOMStream().setItem("Matrix", (OMBase)marr);
        OMArray parr = new OMArray();
        parr.add(new OMName("PDF"));
        parr.add(new OMName("Text"));
        parr.add(new OMName("ImageB"));
        parr.add(new OMName("ImageC"));
        parr.add(new OMName("ImageI"));
        this.resources.getOMDictionary().setItem("ProcSet", (OMBase)parr);
        this.setFormType(1);
        this.formatDecimal.setMaximumFractionDigits(2);
        this.formatDecimal.setGroupingUsed(false);
    }

    public void writeToFile(FileOutputStream newOut) throws IOException, PlpdfException {
        newOut.write(this.content.toByteArray());
        newOut.close();
    }

    public void writeToStream() throws IOException, PlpdfException {
        this.content.flush();
        ByteArrayInputStream ba = new ByteArrayInputStream(this.content.toByteArray());
        byte[] buffer = new byte[1024];
        int amountRead = -1;
        while ((amountRead = ba.read(buffer)) != -1) {
            this.output.write(buffer, 0, amountRead);
        }
        this.output.close();
        this.getOMStream().getFilteredStream();
    }

    public void writeToStream(InputStream cont) throws IOException, PlpdfException {
        byte[] buffer = new byte[1024];
        int amountRead = -1;
        while ((amountRead = cont.read(buffer)) != -1) {
            this.output.write(buffer, 0, amountRead);
        }
        this.output.close();
        this.getOMStream().getFilteredStream();
    }

    public SMResources getResources() {
        SMResources retval = null;
        OMDictionary resources = (OMDictionary)this.getOMStream().getDictionaryObject(OMName.RESOURCES);
        if (resources != null) {
            retval = new SMResources(resources);
        }
        return retval;
    }

    public void setResources(SMResources resources) {
        this.getOMStream().setItem(OMName.RESOURCES, (OMObjectable)resources);
    }

    public void appendRawCommands(String commands) throws IOException {
        this.appendRawCommands(commands.getBytes("ISO-8859-1"));
    }

    public void appendRawCommands(int data) throws IOException {
        this.content.write(data);
    }

    public void appendRawCommands(byte[] commands) throws IOException {
        this.content.write(commands);
    }

    public void saveState() throws IOException {
        this.appendRawCommands("q");
        this.appendRawCommands(32);
    }

    public void beginVariableText() throws IOException {
        this.appendRawCommands("/Tx BMC");
        this.appendRawCommands(32);
    }

    public void endVariableText() throws IOException {
        this.appendRawCommands("EMC");
        this.appendRawCommands(32);
    }

    public void beginText() throws IOException, PlpdfException {
        if (this.inTextMode) {
            throw new PlpdfException(CLASS_NAME, "NestedBeginTextNotAllowed");
        }
        this.appendRawCommands("BT\n");
        this.inTextMode = true;
    }

    public void endText() throws IOException, PlpdfException {
        if (!this.inTextMode) {
            throw new PlpdfException(CLASS_NAME, "BeginTextRequired", new String[]{"endText()"});
        }
        this.appendRawCommands("ET\n");
        this.inTextMode = false;
    }

    public void setFont(SMFont font, float fontSize) throws IOException {
        String fontMapping = (String)this.fontMappings.get(font);
        if (fontMapping == null) {
            fontMapping = MapUtil.getNextUniqueKey(this.fonts, "F");
            this.fontMappings.put(font, fontMapping);
            this.fonts.put(fontMapping, font);
        }
        this.appendRawCommands("/");
        this.appendRawCommands(fontMapping);
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(fontSize));
        this.appendRawCommands(32);
        this.appendRawCommands("Tf\n");
    }

    public void setTextMatrix(float a, float b, float c, float d, float x, float y) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(a));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(b));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(c));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(d));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands("Tm\n");
    }

    public void setHorizontalScaling(float scale) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(scale));
        this.appendRawCommands(" Tz");
        this.appendRawCommands(32);
    }

    public void setTextRenderingMode(int mode) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(mode));
        this.appendRawCommands(32);
        this.appendRawCommands("Tr\n");
    }

    public void setLineWidth(float w) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(w));
        this.appendRawCommands(32);
        this.appendRawCommands("w\n");
    }

    public void startOpacity(OMDictionary op) throws IOException {
        String opacityMapping = (String)this.opacityMappings.get(op);
        if (opacityMapping == null) {
            if (this.opacities == null) {
                this.opacities = this.resources.crExtGState();
            }
            opacityMapping = MapUtil.getNextUniqueKey(this.opacities, "GS");
            this.opacityMappings.put(op, opacityMapping);
            this.opacities.put(opacityMapping, op);
        }
        this.appendRawCommands("q");
        this.appendRawCommands(32);
        this.appendRawCommands("/");
        this.appendRawCommands(opacityMapping);
        this.appendRawCommands(32);
        this.appendRawCommands("gs");
        this.appendRawCommands(32);
    }

    public void setStrokingColorSpace(SMColorSpace colorSpace) throws IOException {
        this.writeColorSpace(colorSpace);
        this.appendRawCommands("CS\n");
    }

    private void writeColorSpace(SMColorSpace colorSpace) throws IOException {
        OMName key = null;
        if (colorSpace instanceof SMDeviceGray || colorSpace instanceof SMDeviceRGB || colorSpace instanceof SMDeviceCMYK) {
            key = OMName.getPDFName(colorSpace.getName());
        } else {
            OMDictionary colorSpaces = (OMDictionary)this.resources.getOMDictionary().getDictionaryObject(OMName.COLORSPACE);
            if (colorSpaces == null) {
                colorSpaces = new OMDictionary();
                this.resources.getOMDictionary().setItem(OMName.COLORSPACE, (OMBase)colorSpaces);
            }
            if ((key = colorSpaces.getKeyForValue(colorSpace.getOMObject())) == null) {
                int counter = 0;
                String csName = "CS";
                while (colorSpaces.containsValue(String.valueOf(csName) + counter)) {
                    ++counter;
                }
                key = OMName.getPDFName(String.valueOf(csName) + counter);
                colorSpaces.setItem(key, (OMObjectable)colorSpace);
            }
        }
        key.writePDF(this.output);
        this.appendRawCommands(32);
    }

    public void setCharacterSpacing(float charSpace) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(charSpace));
        this.appendRawCommands(" Tc");
        this.appendRawCommands(32);
    }

    public void drawString(String text) throws IOException, PlpdfException {
        if (!this.inTextMode) {
            throw new PlpdfException(CLASS_NAME, "BeginTextRequired", new String[]{"drawString()"});
        }
        OMString string = new OMString(text, "ISO-8859-1");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        string.writePDF(buffer);
        this.appendRawCommands(new String(buffer.toByteArray(), "ISO-8859-1"));
        this.appendRawCommands(32);
        this.appendRawCommands("Tj\n");
    }

    public void setStrokingColor(Color color) throws IOException, PlpdfException {
        ColorSpace colorSpace = color.getColorSpace();
        if (colorSpace.getType() == 5) {
            this.setStrokingColor(color.getRed(), color.getGreen(), color.getBlue());
        } else if (colorSpace.getType() == 6) {
            color.getColorComponents(this.colorComponents);
            this.setStrokingColor(this.colorComponents[0]);
        } else if (colorSpace.getType() == 9) {
            color.getColorComponents(this.colorComponents);
            this.setStrokingColor(this.colorComponents[0], this.colorComponents[2], this.colorComponents[2], this.colorComponents[3]);
        } else {
            throw new PlpdfException(CLASS_NAME, "UnknownColorspace", new String[]{colorSpace.toString()});
        }
    }

    public void setStrokingColor(double g) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(g));
        this.appendRawCommands(32);
        this.appendRawCommands("G\n");
    }

    public void setStrokingColor(float[] components) throws IOException {
        int i = 0;
        while (i < components.length) {
            this.appendRawCommands(this.formatDecimal.format(components[i]));
            this.appendRawCommands(32);
            ++i;
        }
        this.appendRawCommands("SC\n");
    }

    public void setStrokingColor(int r, int g, int b) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)r / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)g / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)b / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands("RG\n");
    }

    public void setStrokingColor(int g) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)g / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands("G\n");
    }

    public void setStrokingColor(int c, int m, int y, int k) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)c / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)m / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)y / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)k / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands("K\n");
    }

    public void setStrokingColor(double c, double m, double y, double k) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(c));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(m));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(k));
        this.appendRawCommands(32);
        this.appendRawCommands("K\n");
    }

    public void setLineCap(int style) throws IOException {
        if (style >= 0 && style <= 2) {
            this.appendRawCommands(this.formatDecimal.format(style));
            this.appendRawCommands(" J");
            this.appendRawCommands(32);
        }
    }

    public void setLineJoin(int style) throws IOException {
        if (style >= 0 && style <= 2) {
            this.appendRawCommands(this.formatDecimal.format(style));
            this.appendRawCommands(" j");
            this.appendRawCommands(32);
        }
    }

    public void setMiterLimit(float miterLimit) throws IOException {
        if (miterLimit > 1.0f) {
            this.appendRawCommands(this.formatDecimal.format(miterLimit));
            this.appendRawCommands(" M");
            this.appendRawCommands(32);
        }
    }

    public void setLiteral(String s) throws IOException {
        this.appendRawCommands(s);
    }

    public void setLiteral(char c) throws IOException {
        this.appendRawCommands(c);
    }

    public void setLiteral(float f) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(f));
    }

    public ByteArrayOutputStream getInternalBuffer() {
        return this.content;
    }

    public void restoreState() throws IOException {
        this.appendRawCommands("Q");
        this.appendRawCommands(32);
    }

    public void closePath() throws IOException {
        this.appendRawCommands("h");
        this.appendRawCommands(32);
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x1));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y1));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x2));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y2));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x3));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y3));
        this.appendRawCommands(32);
        this.appendRawCommands("c");
        this.appendRawCommands(32);
    }

    public void lineTo(float x, float y) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands("l");
        this.appendRawCommands(32);
    }

    public void moveTo(float x, float y) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands("m");
        this.appendRawCommands(32);
    }

    public void curveTo(float x2, float y2, float x3, float y3) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x2));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y2));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x3));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y3));
        this.appendRawCommands(32);
        this.appendRawCommands("v");
        this.appendRawCommands(32);
    }

    public void eoFill() throws IOException {
        this.appendRawCommands("f*");
        this.appendRawCommands(32);
    }

    public void fill() throws IOException {
        this.appendRawCommands("f");
        this.appendRawCommands(32);
    }

    public void stroke() throws IOException {
        this.appendRawCommands("S");
        this.appendRawCommands(32);
    }

    public void rectangle(float x, float y, float width, float height) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(width));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(height));
        this.appendRawCommands(32);
        this.appendRawCommands("re\n");
    }

    public void eoClip() throws IOException {
        this.appendRawCommands("W*");
        this.appendRawCommands(32);
    }

    public void clip() throws IOException {
        this.appendRawCommands("W");
        this.appendRawCommands(32);
    }

    public void newPath() throws IOException {
        this.appendRawCommands("n");
        this.appendRawCommands(32);
    }

    public void drawXObject(SMXObject xobject, float x, float y, float width, float height) throws IOException {
        String xObjectPrefix = null;
        xObjectPrefix = xobject instanceof SMXObjectImage ? "Im" : "Form";
        String objMapping = (String)this.xobjectMappings.get(xobject);
        if (objMapping == null) {
            objMapping = MapUtil.getNextUniqueKey(this.xobjects, xObjectPrefix);
            this.xobjectMappings.put(xobject, objMapping);
            this.xobjects.put(objMapping, xobject);
        }
        this.appendRawCommands("q\n");
        this.appendRawCommands(this.formatDecimal.format(width));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(0L));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(0L));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(height));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands("cm\n");
        this.appendRawCommands(32);
        this.appendRawCommands("/");
        this.appendRawCommands(objMapping);
        this.appendRawCommands(32);
        this.appendRawCommands("Do\n");
        this.appendRawCommands(32);
        this.appendRawCommands("Q\n");
    }

    public void setNonStrokingColor(Color color) throws IOException, PlpdfException {
        ColorSpace colorSpace = color.getColorSpace();
        if (colorSpace.getType() == 5) {
            this.setNonStrokingColor(color.getRed(), color.getGreen(), color.getBlue());
        } else if (colorSpace.getType() == 6) {
            color.getColorComponents(this.colorComponents);
            this.setNonStrokingColor(this.colorComponents[0]);
        } else if (colorSpace.getType() == 9) {
            color.getColorComponents(this.colorComponents);
            this.setNonStrokingColor(this.colorComponents[0], this.colorComponents[2], this.colorComponents[2], this.colorComponents[3]);
        } else {
            throw new PlpdfException(CLASS_NAME, "UnknownColorspace", new String[]{colorSpace.toString()});
        }
    }

    public void setNonStrokingColor(int r, int g, int b) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)r / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)g / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)b / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands("rg\n");
    }

    public void setNonStrokingColor(double g) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(g));
        this.appendRawCommands(32);
        this.appendRawCommands("g\n");
    }

    public void setNonStrokingColor(double c, double m, double y, double k) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(c));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(m));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(k));
        this.appendRawCommands(32);
        this.appendRawCommands("k\n");
    }

    public void setShadingFill(SMShadingPattern shading) throws IOException {
        String shadingMapping = (String)this.shadingMappings.get(shading);
        if (shadingMapping == null) {
            shadingMapping = MapUtil.getNextUniqueKey(this.shadings, "P");
            this.shadingMappings.put(shading, shadingMapping);
            this.shadings.put(shadingMapping, shading);
        }
        this.appendRawCommands("Pattern");
        this.appendRawCommands(" cs ");
        this.appendRawCommands(shadingMapping.getBytes());
        this.appendRawCommands(" scn");
        this.appendRawCommands(32);
    }

    public void setShadingStroke(SMShadingPattern shading) throws IOException {
        String shadingMapping = (String)this.shadingMappings.get(shading);
        if (shadingMapping == null) {
            shadingMapping = MapUtil.getNextUniqueKey(this.shadings, "P");
            this.shadingMappings.put(shading, shadingMapping);
            this.shadings.put(shadingMapping, shading);
        }
        this.appendRawCommands("Pattern");
        this.appendRawCommands(" CS ");
        this.appendRawCommands(shadingMapping.getBytes());
        this.appendRawCommands(" SCN");
        this.appendRawCommands(32);
    }

    public OMStream getStream() throws PlpdfException {
        return this.getOMStream();
    }

    public void DrawLine(float x1, float y1, float x2, float y2) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x1));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y1));
        this.appendRawCommands(32);
        this.appendRawCommands("m\n");
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x2));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y2));
        this.appendRawCommands(32);
        this.appendRawCommands("l\n");
        this.appendRawCommands(32);
        this.appendRawCommands("S\n");
    }

    public void fillRect(float x, float y, float width, float height) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(width));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(height));
        this.appendRawCommands(32);
        this.appendRawCommands("re\n");
        this.appendRawCommands("f\n");
    }

    public void drawXObject(SMXObject xobject, float a, float b, float c, float d, float e, float f) throws IOException {
        String xObjectPrefix = null;
        xObjectPrefix = xobject instanceof SMXObjectImage ? "Im" : "Form";
        String objMapping = (String)this.xobjectMappings.get(xobject);
        if (objMapping == null) {
            objMapping = MapUtil.getNextUniqueKey(this.xobjects, xObjectPrefix);
            this.xobjectMappings.put(xobject, objMapping);
            this.xobjects.put(objMapping, xobject);
        }
        this.appendRawCommands("q\n");
        this.appendRawCommands(this.formatDecimal.format(a));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(b));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(c));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(d));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(e));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(f));
        this.appendRawCommands(32);
        this.appendRawCommands("cm\n");
        this.appendRawCommands(32);
        this.appendRawCommands("/");
        this.appendRawCommands(objMapping);
        this.appendRawCommands(32);
        this.appendRawCommands("Do\n");
        this.appendRawCommands(32);
        this.appendRawCommands("Q\n");
    }
}

