/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.xobject;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.common.function.SMFunction;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMDeviceGray;
import com.plpdf.smmodel.graphics.color.SMDeviceRGB;
import com.plpdf.smmodel.graphics.color.SMICCBased;
import com.plpdf.smmodel.graphics.color.SMIndexed;
import com.plpdf.smmodel.graphics.color.SMSeparation;
import com.plpdf.smmodel.graphics.xobject.SMXObjectImage;
import com.plpdf.util.ImageIOUtil;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;

public class SMPixelMap
extends SMXObjectImage {
    private BufferedImage image = null;
    private static final String PNG = "png";

    public SMPixelMap(SMStream pdStream) {
        super(pdStream, PNG);
    }

    public SMPixelMap(SMDocument doc, BufferedImage bi) throws IOException {
        super(doc, PNG);
        this.createImageStream(doc, bi);
    }

    private void createImageStream(SMDocument doc, BufferedImage bi) throws IOException {
        BufferedImage alphaImage = null;
        BufferedImage rgbImage = null;
        int width = bi.getWidth();
        int height = bi.getHeight();
        if (bi.getColorModel().hasAlpha()) {
            WritableRaster alphaRaster = bi.getAlphaRaster();
            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
            alphaImage = new BufferedImage(cm, alphaRaster, false, null);
            rgbImage = new BufferedImage(width, height, 5);
            Graphics2D g = rgbImage.createGraphics();
            g.setComposite(AlphaComposite.Src);
            g.drawImage((Image)bi, 0, 0, null);
        } else {
            rgbImage = bi;
        }
        OutputStream os = null;
        try {
            int numberOfComponents = rgbImage.getColorModel().getNumComponents();
            if (numberOfComponents == 3) {
                try {
                    this.setColorSpace(SMDeviceRGB.INSTANCE);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (numberOfComponents == 1) {
                try {
                    this.setColorSpace(new SMDeviceGray());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                throw new IllegalStateException();
            }
            byte[] outData = new byte[width * height * numberOfComponents];
            rgbImage.getData().getDataElements(0, 0, width, height, outData);
            try {
                this.getSMStream().addCompression();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                os = this.getOMStream().createUnfilteredStream();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            os.write(outData);
            OMStream dic = this.getOMStream();
            dic.setItem(OMName.FILTER, (OMBase)OMName.FLATE_DECODE);
            dic.setItem(OMName.SUBTYPE, (OMBase)OMName.IMAGE);
            dic.setItem(OMName.TYPE, (OMBase)OMName.XOBJECT);
            if (alphaImage != null) {
                SMPixelMap smask = new SMPixelMap(doc, alphaImage);
                dic.setItem(OMName.SMASK, (OMObjectable)smask);
            }
            this.setBitsPerComponent(8);
            this.setHeight(height);
            this.setWidth(width);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    public BufferedImage getRGBImage() throws IOException {
        SMColorSpace colorspace;
        int bpc;
        int height;
        int width;
        byte[] array;
        block27: {
            block26: {
                if (this.image != null) {
                    return this.image;
                }
                array = this.getSMStream().getByteArray();
                if (array.length != 0) break block26;
                return null;
            }
            width = this.getWidth();
            height = this.getHeight();
            bpc = this.getBitsPerComponent();
            colorspace = this.getColorSpace();
            if (colorspace != null) break block27;
            return null;
        }
        try {
            byte[] map;
            ColorModel cm = null;
            if (colorspace instanceof SMIndexed) {
                SMIndexed csIndexed = (SMIndexed)colorspace;
                OMBase maskArray = this.getMask();
                cm = maskArray != null && maskArray instanceof OMArray ? csIndexed.createColorModel(bpc, ((OMArray)maskArray).getInt(0)) : csIndexed.createColorModel(bpc);
            } else if (colorspace instanceof SMSeparation) {
                SMSeparation csSeparation = (SMSeparation)colorspace;
                int numberOfComponents = csSeparation.getAlternateColorSpace().getNumberOfComponents();
                SMFunction tintTransformFunc = csSeparation.getTintTransform();
                OMArray decode = this.getDecode();
                boolean invert = decode != null && decode.getInt(0) == 1;
                int maxValue = (int)Math.pow(2.0, bpc) - 1;
                byte[] mappedData = new byte[width * height * numberOfComponents];
                int rowLength = width * numberOfComponents;
                float[] input = new float[1];
                int i = 0;
                while (i < height) {
                    int rowOffset = i * rowLength;
                    int j = 0;
                    while (j < width) {
                        int value = (array[i * width + j] + 256) % 256;
                        input[0] = invert ? (float)(1 - value / maxValue) : (float)(value / maxValue);
                        float[] mappedColor = tintTransformFunc.eval(input);
                        int columnOffset = j * numberOfComponents;
                        int k = 0;
                        while (k < numberOfComponents) {
                            float mappedValue = mappedColor[k];
                            mappedData[rowOffset + columnOffset + k] = (byte)(mappedValue * (float)maxValue);
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                array = mappedData;
                cm = colorspace.createColorModel(bpc);
            } else if (bpc == 1) {
                map = null;
                if (colorspace instanceof SMDeviceGray) {
                    OMArray decode = this.getDecode();
                    if (decode != null && decode.getInt(0) == 1) {
                        map = new byte[]{-1};
                    } else {
                        byte[] byArray = new byte[2];
                        byArray[1] = -1;
                        map = byArray;
                    }
                } else if (colorspace instanceof SMICCBased) {
                    if (((SMICCBased)colorspace).getNumberOfComponents() == 1) {
                        map = new byte[]{-1};
                    } else {
                        byte[] byArray = new byte[2];
                        byArray[1] = -1;
                        map = byArray;
                    }
                } else {
                    byte[] byArray = new byte[2];
                    byArray[1] = -1;
                    map = byArray;
                }
                cm = new IndexColorModel(bpc, map.length, map, map, map, 1);
            } else if (colorspace instanceof SMICCBased) {
                if (((SMICCBased)colorspace).getNumberOfComponents() == 1) {
                    map = new byte[]{-1};
                    cm = new IndexColorModel(bpc, 1, map, map, map, 1);
                } else {
                    cm = colorspace.createColorModel(bpc);
                }
            } else {
                cm = colorspace.createColorModel(bpc);
            }
            WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
            DataBufferByte buffer = (DataBufferByte)raster.getDataBuffer();
            byte[] bufferData = buffer.getData();
            System.arraycopy(array, 0, bufferData, 0, array.length < bufferData.length ? array.length : bufferData.length);
            this.image = new BufferedImage(cm, raster, false, null);
            return this.applyMasks(this.image);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void write2OutputStream(OutputStream out) throws IOException {
        this.getRGBImage();
        if (this.image != null) {
            ImageIOUtil.writeImage(this.image, PNG, out);
        }
    }

    public OMDictionary getDecodeParams() {
        OMBase decodeParms = this.getOMStream().getDictionaryObject(OMName.DECODE_PARMS);
        if (decodeParms != null) {
            if (decodeParms instanceof OMDictionary) {
                return (OMDictionary)decodeParms;
            }
            if (decodeParms instanceof OMArray) {
                return null;
            }
            return null;
        }
        return null;
    }

    public int getPredictor() {
        int i;
        OMDictionary decodeParms = this.getDecodeParams();
        if (decodeParms != null && (i = decodeParms.getInt(OMName.PREDICTOR)) != -1) {
            return i;
        }
        return 1;
    }
}

