/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.xobject;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.common.function.SMFunction;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMDeviceCMYK;
import com.plpdf.smmodel.graphics.color.SMDeviceGray;
import com.plpdf.smmodel.graphics.color.SMDeviceN;
import com.plpdf.smmodel.graphics.color.SMDeviceRGB;
import com.plpdf.smmodel.graphics.color.SMICCBased;
import com.plpdf.smmodel.graphics.color.SMSeparation;
import com.plpdf.smmodel.graphics.xobject.SMXObjectImage;
import com.plpdf.util.ImageIOUtil;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SMJpeg
extends SMXObjectImage {
    private static final String CLASS_NAME = SMXObjectImage.class.getName();
    private BufferedImage image = null;
    private static final String JPG = "jpg";
    private static final List<String> DCT_FILTERS = new ArrayList<String>();
    private static final float DEFAULT_COMPRESSION_LEVEL = 0.75f;

    static {
        DCT_FILTERS.add(OMName.DCT_DECODE.getName());
        DCT_FILTERS.add(OMName.DCT_DECODE_ABBREVIATION.getName());
    }

    public SMJpeg(SMStream jpeg) {
        super(jpeg, JPG);
    }

    public SMJpeg(SMDocument doc, InputStream is) throws IOException, PlpdfException {
        super(new SMStream(doc, is, true), JPG);
        OMStream dic = this.getOMStream();
        dic.setItem(OMName.FILTER, (OMBase)OMName.DCT_DECODE);
        dic.setItem(OMName.SUBTYPE, (OMBase)OMName.IMAGE);
        dic.setItem(OMName.TYPE, (OMBase)OMName.XOBJECT);
        this.getRGBImage();
        if (this.image != null) {
            this.setBitsPerComponent(8);
            if (this.image.getColorModel().getColorSpace().getType() == 5) {
                this.setColorSpace(SMDeviceRGB.INSTANCE);
            } else if (this.image.getColorModel().getColorSpace().getType() == 6) {
                this.setColorSpace(SMDeviceGray.INSTANCE);
            } else {
                throw new PlpdfException(CLASS_NAME, "ColorspaceNotSupported");
            }
            this.setHeight(this.image.getHeight());
            this.setWidth(this.image.getWidth());
        }
    }

    public SMJpeg(SMDocument doc, BufferedImage bi) throws IOException {
        super(new SMStream(doc), JPG);
        this.createImageStream(doc, bi, 0.75f);
    }

    public SMJpeg(SMDocument doc, BufferedImage bi, float compressionQuality) throws IOException {
        super(new SMStream(doc), JPG);
        this.createImageStream(doc, bi, compressionQuality);
    }

    private void createImageStream(SMDocument doc, BufferedImage bi, float compressionQuality) throws IOException {
        BufferedImage alpha = null;
        if (bi.getColorModel().hasAlpha()) {
            WritableRaster alphaRaster = bi.getAlphaRaster();
            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
            alpha = new BufferedImage(cm, alphaRaster, false, null);
            this.image = new BufferedImage(bi.getWidth(), bi.getHeight(), 1);
            Graphics2D g = this.image.createGraphics();
            g.setComposite(AlphaComposite.Src);
            g.drawImage((Image)bi, 0, 0, null);
            bi = this.image;
        }
        OutputStream os = this.getOMStream().createFilteredStream();
        try {
            ImageIOUtil.writeImage(bi, JPG, os, 72, compressionQuality);
            OMStream dic = this.getOMStream();
            dic.setItem(OMName.FILTER, (OMBase)OMName.DCT_DECODE);
            dic.setItem(OMName.SUBTYPE, (OMBase)OMName.IMAGE);
            dic.setItem(OMName.TYPE, (OMBase)OMName.XOBJECT);
            SMJpeg alphaPdImage = null;
            if (alpha != null) {
                alphaPdImage = new SMJpeg(doc, alpha, compressionQuality);
                dic.setItem(OMName.SMASK, (OMObjectable)alphaPdImage);
            }
            this.setBitsPerComponent(8);
            if (bi.getColorModel().getNumComponents() == 3) {
                this.setColorSpace(SMDeviceRGB.INSTANCE);
            } else if (bi.getColorModel().getNumComponents() == 1) {
                this.setColorSpace(new SMDeviceGray());
            } else {
                throw new IllegalStateException();
            }
            this.setHeight(bi.getHeight());
            this.setWidth(bi.getWidth());
        }
        finally {
            os.close();
        }
    }

    public BufferedImage getRGBImage() throws IOException {
        if (this.image != null) {
            return this.image;
        }
        BufferedImage bi = null;
        boolean readError = false;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.removeAllFiltersButDCT(os);
        os.close();
        byte[] img = os.toByteArray();
        SMColorSpace cs = this.getColorSpace();
        try {
            if (cs instanceof SMDeviceCMYK || cs instanceof SMICCBased && cs.getNumberOfComponents() == 4) {
                int transform = this.getApp14AdobeTransform(img);
                if (transform == 0) {
                    bi = this.convertCMYK2RGB(this.readImage(img), cs);
                } else if (transform != 1 && transform == 2) {
                    bi = this.convertYCCK2RGB(this.readImage(img));
                }
            } else if (cs instanceof SMSeparation) {
                bi = this.processTintTransformation(this.readImage(img), ((SMSeparation)cs).getTintTransform(), cs.getJavaColorSpace());
            } else if (cs instanceof SMDeviceN) {
                bi = this.processTintTransformation(this.readImage(img), ((SMDeviceN)cs).getTintTransform(), cs.getJavaColorSpace());
            } else {
                ByteArrayInputStream bai = new ByteArrayInputStream(img);
                bi = ImageIO.read(bai);
            }
        }
        catch (IIOException exception) {
            readError = true;
        }
        if (bi == null && readError) {
            byte[] newImage = this.replaceHeader(img);
            ByteArrayInputStream bai = new ByteArrayInputStream(newImage);
            bi = ImageIO.read(bai);
        }
        this.image = this.applyMasks(bi);
        return this.image;
    }

    public void write2OutputStream(OutputStream out) throws IOException {
        this.getRGBImage();
        if (this.image != null) {
            ImageIOUtil.writeImage(this.image, JPG, out);
        }
    }

    private void removeAllFiltersButDCT(OutputStream out) throws IOException {
        InputStream data = this.getSMStream().getPartiallyFilteredStream(DCT_FILTERS);
        byte[] buf = new byte[1024];
        int amountRead = -1;
        while ((amountRead = data.read(buf)) != -1) {
            out.write(buf, 0, amountRead);
        }
    }

    private int getHeaderEndPos(byte[] imageAsBytes) {
        int i = 0;
        while (i < imageAsBytes.length) {
            byte b = imageAsBytes[i];
            if (b == -37) {
                return i - 2;
            }
            ++i;
        }
        return 0;
    }

    private byte[] replaceHeader(byte[] imageAsBytes) {
        int pos = this.getHeaderEndPos(imageAsBytes);
        byte[] byArray = new byte[20];
        byArray[0] = -1;
        byArray[1] = -40;
        byArray[2] = -1;
        byArray[3] = -32;
        byArray[5] = 16;
        byArray[6] = 74;
        byArray[7] = 70;
        byArray[8] = 73;
        byArray[9] = 70;
        byArray[11] = 1;
        byArray[12] = 1;
        byArray[13] = 1;
        byArray[15] = 96;
        byArray[17] = 96;
        byte[] header = byArray;
        byte[] newImage = new byte[imageAsBytes.length - pos + header.length - 1];
        System.arraycopy(header, 0, newImage, 0, header.length);
        System.arraycopy(imageAsBytes, pos + 1, newImage, header.length, imageAsBytes.length - pos - 1);
        return newImage;
    }

    private int getApp14AdobeTransform(byte[] bytes) {
        int transformType = 0;
        ImageReader reader = null;
        ImageInputStream input = null;
        try {
            try {
                input = ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));
                Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
                if (readers == null || !readers.hasNext()) {
                    input.close();
                    throw new RuntimeException("No ImageReaders found");
                }
                reader = readers.next();
                reader.setInput(input);
                IIOMetadata meta = reader.getImageMetadata(0);
                if (meta != null) {
                    Node tree = meta.getAsTree("javax_imageio_jpeg_image_1.0");
                    NodeList children = tree.getChildNodes();
                    int i = 0;
                    while (i < children.getLength()) {
                        Node markerSequence = children.item(i);
                        if ("markerSequence".equals(markerSequence.getNodeName())) {
                            NodeList markerSequenceChildren = markerSequence.getChildNodes();
                            int j = 0;
                            while (j < markerSequenceChildren.getLength()) {
                                Node child = markerSequenceChildren.item(j);
                                if ("app14Adobe".equals(child.getNodeName()) && child.hasAttributes()) {
                                    NamedNodeMap attribs = child.getAttributes();
                                    Node transformNode = attribs.getNamedItem("transform");
                                    transformType = Integer.parseInt(transformNode.getNodeValue());
                                    break;
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (IOException iOException) {
                if (reader != null) {
                    reader.dispose();
                }
            }
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
        return transformType;
    }

    private Raster readImage(byte[] bytes) throws IOException {
        ImageInputStream input = ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));
        Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
        if (readers == null || !readers.hasNext()) {
            input.close();
            throw new RuntimeException("No ImageReaders found");
        }
        ImageReader reader = readers.next();
        reader.setInput(input);
        Raster raster = reader.readRaster(0, reader.getDefaultReadParam());
        input.close();
        reader.dispose();
        return raster;
    }

    private BufferedImage convertCMYK2RGB(Raster raster, SMColorSpace colorspace) throws IOException {
        ColorSpace cs = colorspace.getJavaColorSpace();
        int width = raster.getWidth();
        int height = raster.getHeight();
        byte[] rgb = new byte[width * height * 3];
        int rgbIndex = 0;
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                float[] srcColorValues = raster.getPixel(j, i, (float[])null);
                int k = 0;
                while (k < 4) {
                    int n = k++;
                    srcColorValues[n] = srcColorValues[n] / 255.0f;
                }
                float[] rgbValues = cs.toRGB(srcColorValues);
                int k2 = 0;
                while (k2 < 3) {
                    rgb[rgbIndex + k2] = (byte)(rgbValues[k2] * 255.0f);
                    ++k2;
                }
                rgbIndex += 3;
                ++j;
            }
            ++i;
        }
        return this.createRGBBufferedImage(ColorSpace.getInstance(1000), rgb, width, height);
    }

    private BufferedImage convertYCCK2RGB(Raster raster) throws IOException {
        int width = raster.getWidth();
        int height = raster.getHeight();
        byte[] rgb = new byte[width * height * 3];
        int rgbIndex = 0;
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                float[] srcColorValues = raster.getPixel(j, i, (float[])null);
                float k = srcColorValues[3];
                float y = srcColorValues[0];
                float c1 = srcColorValues[1];
                float c2 = srcColorValues[2];
                double val = (double)y + 1.402 * (double)(c2 - 128.0f) - (double)k;
                rgb[rgbIndex] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
                val = (double)y - 0.34414 * (double)(c1 - 128.0f) - 0.71414 * (double)(c2 - 128.0f) - (double)k;
                rgb[rgbIndex + 1] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
                val = (double)y + 1.772 * (double)(c1 - 128.0f) - (double)k;
                rgb[rgbIndex + 2] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
                rgbIndex += 3;
                ++j;
            }
            ++i;
        }
        return this.createRGBBufferedImage(ColorSpace.getInstance(1000), rgb, width, height);
    }

    private BufferedImage processTintTransformation(Raster raster, SMFunction function, ColorSpace colorspace) throws IOException {
        int numberOfInputValues = function.getNumberOfInputParameters();
        int numberOfOutputValues = function.getNumberOfOutputParameters();
        int width = raster.getWidth();
        int height = raster.getHeight();
        byte[] rgb = new byte[width * height * numberOfOutputValues];
        int bufferIndex = 0;
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                float[] srcColorValues = raster.getPixel(j, i, (float[])null);
                int k = 0;
                while (k < numberOfInputValues) {
                    int n = k++;
                    srcColorValues[n] = srcColorValues[n] / 255.0f;
                }
                float[] convertedValues = function.eval(srcColorValues);
                int k2 = 0;
                while (k2 < numberOfOutputValues) {
                    rgb[bufferIndex + k2] = (byte)(convertedValues[k2] * 255.0f);
                    ++k2;
                }
                bufferIndex += numberOfOutputValues;
                ++j;
            }
            ++i;
        }
        return this.createRGBBufferedImage(colorspace, rgb, width, height);
    }

    private BufferedImage createRGBBufferedImage(ColorSpace cs, byte[] rgb, int width, int height) {
        ComponentColorModel cm = new ComponentColorModel(cs, false, false, 1, 0);
        WritableRaster writeableRaster = ((ColorModel)cm).createCompatibleWritableRaster(width, height);
        DataBufferByte buffer = (DataBufferByte)writeableRaster.getDataBuffer();
        byte[] bufferData = buffer.getData();
        System.arraycopy(rgb, 0, bufferData, 0, rgb.length);
        return new BufferedImage(cm, writeableRaster, true, null);
    }
}

