/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.xobject;

import com.plpdf.filter.Filter;
import com.plpdf.filter.FilterManager;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.util.ImageParameters;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class SMInlinedImage {
    private ImageParameters params;
    private byte[] imageData;

    public ImageParameters getImageParameters() {
        return this.params;
    }

    public void setImageParameters(ImageParameters imageParams) {
        this.params = imageParams;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] value) {
        this.imageData = value;
    }

    public BufferedImage createImage() throws IOException {
        return this.createImage(null);
    }

    public BufferedImage createImage(Map colorSpaces) throws IOException {
        DataBuffer byteBuffer;
        SMColorSpace pcs = this.params.getColorSpace(colorSpaces);
        ColorModel colorModel = null;
        if (pcs != null) {
            colorModel = pcs.createColorModel(this.params.getBitsPerComponent());
        } else {
            byte[] transparentColors = new byte[]{-1, -1};
            byte[] byArray = new byte[2];
            byArray[1] = -1;
            byte[] colors = byArray;
            colorModel = new IndexColorModel(1, 2, colors, colors, colors, transparentColors);
        }
        List filters = this.params.getFilters();
        byte[] finalData = null;
        if (filters == null) {
            finalData = this.getImageData();
        } else {
            ByteArrayInputStream in = new ByteArrayInputStream(this.getImageData());
            ByteArrayOutputStream out = new ByteArrayOutputStream(this.getImageData().length);
            FilterManager filterManager = new FilterManager();
            int i = 0;
            while (i < filters.size()) {
                out.reset();
                Filter filter = filterManager.getFilter((String)filters.get(i));
                filter.decode(in, out, this.params.getDictionary(), i);
                in = new ByteArrayInputStream(out.toByteArray());
                ++i;
            }
            finalData = out.toByteArray();
        }
        WritableRaster raster = colorModel.createCompatibleWritableRaster(this.params.getWidth(), this.params.getHeight());
        DataBuffer rasterBuffer = raster.getDataBuffer();
        if (rasterBuffer instanceof DataBufferByte) {
            byteBuffer = (DataBufferByte)rasterBuffer;
            byte[] data = ((DataBufferByte)byteBuffer).getData();
            System.arraycopy(finalData, 0, data, 0, data.length);
        } else if (rasterBuffer instanceof DataBufferInt) {
            byteBuffer = (DataBufferInt)rasterBuffer;
            int[] data = ((DataBufferInt)byteBuffer).getData();
            int i = 0;
            while (i < finalData.length) {
                data[i] = (finalData[i] + 256) % 256;
                ++i;
            }
        }
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        image.setData(raster);
        return image;
    }
}

