/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.xobject;

import com.plpdf.io.IOUtils;
import com.plpdf.io.RandomAccess;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMDeviceGray;
import com.plpdf.smmodel.graphics.color.SMIndexed;
import com.plpdf.smmodel.graphics.xobject.SMXObjectImage;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SMCcitt
extends SMXObjectImage {
    private static final List<String> FAX_FILTERS = new ArrayList<String>();

    static {
        FAX_FILTERS.add(OMName.CCITTFAX_DECODE.getName());
        FAX_FILTERS.add(OMName.CCITTFAX_DECODE_ABBREVIATION.getName());
    }

    public SMCcitt(SMStream ccitt) {
        super(ccitt, "tiff");
    }

    public SMCcitt(SMDocument doc, RandomAccess raf) throws IOException {
        super(new SMStream(doc), "tiff");
        OMDictionary decodeParms = new OMDictionary();
        OMStream dic = this.getOMStream();
        this.extractFromTiff(raf, this.getOMStream().createFilteredStream(), decodeParms);
        dic.setItem(OMName.FILTER, (OMBase)OMName.CCITTFAX_DECODE);
        dic.setItem(OMName.SUBTYPE, (OMBase)OMName.IMAGE);
        dic.setItem(OMName.TYPE, (OMBase)OMName.XOBJECT);
        dic.setItem(OMName.DECODE_PARMS, (OMBase)decodeParms);
        this.setBitsPerComponent(1);
        this.setColorSpace(new SMDeviceGray());
        this.setWidth(decodeParms.getInt(OMName.COLUMNS));
        this.setHeight(decodeParms.getInt(OMName.ROWS));
    }

    public BufferedImage getRGBImage() throws IOException {
        OMStream stream = this.getOMStream();
        OMBase decodeP = stream.getDictionaryObject(OMName.DECODE_PARMS);
        OMDictionary decodeParms = null;
        if (decodeP instanceof OMDictionary) {
            decodeParms = (OMDictionary)decodeP;
        } else if (decodeP instanceof OMArray) {
            int index = 0;
            OMBase filters = stream.getFilters();
            if (filters instanceof OMArray) {
                OMArray filterArray = (OMArray)filters;
                while (index < filterArray.size()) {
                    OMName filtername = (OMName)filterArray.get(index);
                    if (OMName.CCITTFAX_DECODE.equals(filtername)) break;
                    ++index;
                }
            }
            decodeParms = (OMDictionary)((OMArray)decodeP).getObject(index);
        }
        int cols = decodeParms.getInt(OMName.COLUMNS, 1728);
        int rows = decodeParms.getInt(OMName.ROWS, 0);
        int height = stream.getInt(OMName.HEIGHT, 0);
        rows = rows > 0 && height > 0 ? Math.min(rows, height) : Math.max(rows, height);
        boolean blackIsOne = decodeParms.getBoolean(OMName.BLACK_IS_1, false);
        OMArray decode = this.getDecode();
        if (decode != null && decode.getInt(0) == 1) {
            blackIsOne = !blackIsOne;
        }
        byte[] bufferData = null;
        ColorModel colorModel = null;
        SMColorSpace colorspace = this.getColorSpace();
        if (colorspace instanceof SMIndexed) {
            SMIndexed csIndexed = (SMIndexed)colorspace;
            OMBase maskArray = this.getMask();
            colorModel = maskArray != null && maskArray instanceof OMArray ? csIndexed.createColorModel(1, ((OMArray)maskArray).getInt(0)) : csIndexed.createColorModel(1);
        } else {
            byte[] byArray = new byte[2];
            byArray[1] = -1;
            byte[] map = byArray;
            colorModel = new IndexColorModel(1, map.length, map, map, map, 1);
        }
        WritableRaster raster = colorModel.createCompatibleWritableRaster(cols, rows);
        DataBufferByte buffer = (DataBufferByte)raster.getDataBuffer();
        bufferData = buffer.getData();
        IOUtils.populateBuffer(stream.getUnfilteredStream(), bufferData);
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        if (!blackIsOne) {
            this.invertBitmap(bufferData);
        }
        if (this.hasMask()) {
            BufferedImage indexed;
            byte[] array;
            byte[] byArray = new byte[2];
            byArray[1] = -1;
            byte[] map = byArray;
            IndexColorModel cm = new IndexColorModel(1, map.length, map, map, map, 1);
            raster = cm.createCompatibleWritableRaster(cols, rows);
            bufferData = ((DataBufferByte)raster.getDataBuffer()).getData();
            System.arraycopy(array, 0, bufferData, 0, (array = ((DataBufferByte)image.getData().getDataBuffer()).getData()).length < bufferData.length ? array.length : bufferData.length);
            image = indexed = new BufferedImage(cm, raster, false, null);
        }
        return this.applyMasks(image);
    }

    private void invertBitmap(byte[] bufferData) {
        int i = 0;
        int c = bufferData.length;
        while (i < c) {
            bufferData[i] = (byte)(~bufferData[i] & 0xFF);
            ++i;
        }
    }

    public void write2OutputStream(OutputStream out) throws IOException {
        TiffWrapper data = new TiffWrapper(this.getSMStream().getPartiallyFilteredStream(FAX_FILTERS), this.getOMStream());
        IOUtils.copy(data, out);
    }

    private void extractFromTiff(RandomAccess raf, OutputStream os, OMDictionary parms) throws IOException {
        try {
            raf.seek(0L);
            char endianess = (char)raf.read();
            if ((char)raf.read() != endianess) {
                throw new IOException("Not a valid tiff file");
            }
            if (endianess != 'M' && endianess != 'I') {
                throw new IOException("Not a valid tiff file");
            }
            int magicNumber = this.readshort(endianess, raf);
            if (magicNumber != 42) {
                throw new IOException("Not a valid tiff file");
            }
            raf.seek(this.readlong(endianess, raf));
            int numtags = this.readshort(endianess, raf);
            if (numtags > 50) {
                throw new IOException("Not a valid tiff file");
            }
            int k = -1000;
            int dataoffset = 0;
            int datalength = 0;
            int i = 0;
            while (i < numtags) {
                int tag = this.readshort(endianess, raf);
                int type = this.readshort(endianess, raf);
                int count = this.readlong(endianess, raf);
                int val = this.readlong(endianess, raf);
                if (endianess == 'M') {
                    switch (type) {
                        case 1: {
                            val >>= 24;
                            break;
                        }
                        case 3: {
                            val >>= 16;
                            break;
                        }
                    }
                }
                switch (tag) {
                    case 256: {
                        parms.setInt(OMName.COLUMNS, val);
                        break;
                    }
                    case 257: {
                        parms.setInt(OMName.ROWS, val);
                        break;
                    }
                    case 259: {
                        if (val == 4) {
                            k = -1;
                        }
                        if (val != 3) break;
                        k = 0;
                        break;
                    }
                    case 262: {
                        if (val != 1) break;
                        parms.setBoolean(OMName.BLACK_IS_1, true);
                        break;
                    }
                    case 273: {
                        if (count != 1) break;
                        dataoffset = val;
                        break;
                    }
                    case 279: {
                        if (count != 1) break;
                        datalength = val;
                        break;
                    }
                    case 292: {
                        if (val != 1) break;
                        k = 50;
                        break;
                    }
                    case 324: {
                        if (count != 1) break;
                        dataoffset = val;
                        break;
                    }
                    case 325: {
                        if (count != 1) break;
                        datalength = val;
                    }
                }
                ++i;
            }
            if (k == -1000) {
                throw new IOException("First image in tiff is not CCITT T4 or T6 compressed");
            }
            if (dataoffset == 0) {
                throw new IOException("First image in tiff is not a single tile/strip");
            }
            parms.setInt(OMName.K, k);
            raf.seek(dataoffset);
            byte[] buf = new byte[8192];
            int amountRead = -1;
            while ((amountRead = raf.read(buf, 0, Math.min(8192, datalength))) > 0) {
                datalength -= amountRead;
                os.write(buf, 0, amountRead);
            }
        }
        finally {
            os.close();
        }
    }

    private int readshort(char endianess, RandomAccess raf) throws IOException {
        if (endianess == 'I') {
            return raf.read() | raf.read() << 8;
        }
        return raf.read() << 8 | raf.read();
    }

    private int readlong(char endianess, RandomAccess raf) throws IOException {
        if (endianess == 'I') {
            return raf.read() | raf.read() << 8 | raf.read() << 16 | raf.read() << 24;
        }
        return raf.read() << 24 | raf.read() << 16 | raf.read() << 8 | raf.read();
    }

    private class TiffWrapper
    extends InputStream {
        private int currentOffset;
        private byte[] tiffheader;
        private InputStream datastream;
        private final byte[] basicHeader;
        private int additionalOffset;

        private TiffWrapper(InputStream rawstream, OMDictionary options) {
            byte[] byArray = new byte[10];
            byArray[0] = 73;
            byArray[1] = 73;
            byArray[2] = 42;
            byArray[4] = 8;
            this.basicHeader = byArray;
            this.buildHeader(options);
            this.currentOffset = 0;
            this.datastream = rawstream;
        }

        public boolean markSupported() {
            return false;
        }

        public void reset() throws IOException {
            throw new IOException("reset not supported");
        }

        public int read() throws IOException {
            if (this.currentOffset < this.tiffheader.length) {
                return this.tiffheader[this.currentOffset++];
            }
            return this.datastream.read();
        }

        public int read(byte[] data) throws IOException {
            if (this.currentOffset < this.tiffheader.length) {
                int length = Math.min(this.tiffheader.length - this.currentOffset, data.length);
                if (length > 0) {
                    System.arraycopy(this.tiffheader, this.currentOffset, data, 0, length);
                }
                this.currentOffset += length;
                return length;
            }
            return this.datastream.read(data);
        }

        public int read(byte[] data, int off, int len) throws IOException {
            if (this.currentOffset < this.tiffheader.length) {
                int length = Math.min(this.tiffheader.length - this.currentOffset, len);
                if (length > 0) {
                    System.arraycopy(this.tiffheader, this.currentOffset, data, off, length);
                }
                this.currentOffset += length;
                return length;
            }
            return this.datastream.read(data, off, len);
        }

        public long skip(long n) throws IOException {
            if (this.currentOffset < this.tiffheader.length) {
                long length = Math.min((long)(this.tiffheader.length - this.currentOffset), n);
                this.currentOffset = (int)((long)this.currentOffset + length);
                return length;
            }
            return this.datastream.skip(n);
        }

        private void buildHeader(OMDictionary options) {
            int numOfTags = 10;
            int maxAdditionalData = 24;
            int ifdSize = 134;
            this.tiffheader = new byte[ifdSize + 24];
            Arrays.fill(this.tiffheader, (byte)0);
            System.arraycopy(this.basicHeader, 0, this.tiffheader, 0, this.basicHeader.length);
            this.additionalOffset = ifdSize;
            short cols = 1728;
            short rows = 0;
            short blackis1 = 0;
            int comptype = 3;
            long t4options = 0L;
            OMArray decode = SMCcitt.this.getDecode();
            if (decode != null && decode.getInt(0) == 1) {
                blackis1 = 1;
            }
            OMBase dicOrArrayParms = options.getDictionaryObject(OMName.DECODE_PARMS);
            OMDictionary decodeParms = null;
            if (dicOrArrayParms instanceof OMDictionary) {
                decodeParms = (OMDictionary)dicOrArrayParms;
            } else {
                OMArray parmsArray = (OMArray)dicOrArrayParms;
                if (parmsArray.size() == 1) {
                    decodeParms = (OMDictionary)parmsArray.getObject(0);
                } else {
                    int i = 0;
                    while (i < parmsArray.size() && decodeParms == null) {
                        OMDictionary dic = (OMDictionary)parmsArray.getObject(i);
                        if (dic != null && (dic.getDictionaryObject(OMName.COLUMNS) != null || dic.getDictionaryObject(OMName.ROWS) != null)) {
                            decodeParms = dic;
                        }
                        ++i;
                    }
                }
            }
            if (decodeParms != null) {
                int k;
                cols = (short)decodeParms.getInt(OMName.COLUMNS, (int)cols);
                rows = (short)decodeParms.getInt(OMName.ROWS, (int)rows);
                if (decodeParms.getBoolean(OMName.BLACK_IS_1, false)) {
                    blackis1 = 1;
                }
                if ((k = decodeParms.getInt(OMName.K, 0)) < 0) {
                    comptype = 4;
                }
                if (k > 0) {
                    comptype = 3;
                    t4options = 1L;
                }
            }
            if (rows == 0) {
                rows = (short)options.getInt(OMName.HEIGHT, (int)rows);
            }
            this.addTag(256, cols);
            this.addTag(257, rows);
            this.addTag(259, (short)comptype);
            this.addTag(262, blackis1);
            this.addTag(273, this.tiffheader.length);
            this.addTag(279, options.getInt(OMName.LENGTH));
            this.addTag(282, 300L, 1L);
            this.addTag(283, 300L, 1L);
            if (comptype == 3) {
                this.addTag(292, t4options);
            }
            this.addTag(305, "PDFBOX");
        }

        private void addTag(int tag, long value) {
            byte count = this.tiffheader[8] = (byte)(this.tiffheader[8] + 1);
            int offset = (count - 1) * 12 + 10;
            this.tiffheader[offset] = (byte)(tag & 0xFF);
            this.tiffheader[offset + 1] = (byte)(tag >> 8 & 0xFF);
            this.tiffheader[offset + 2] = 4;
            this.tiffheader[offset + 4] = 1;
            this.tiffheader[offset + 8] = (byte)(value & 0xFFL);
            this.tiffheader[offset + 9] = (byte)(value >> 8 & 0xFFL);
            this.tiffheader[offset + 10] = (byte)(value >> 16 & 0xFFL);
            this.tiffheader[offset + 11] = (byte)(value >> 24 & 0xFFL);
        }

        private void addTag(int tag, short value) {
            byte count = this.tiffheader[8] = (byte)(this.tiffheader[8] + 1);
            int offset = (count - 1) * 12 + 10;
            this.tiffheader[offset] = (byte)(tag & 0xFF);
            this.tiffheader[offset + 1] = (byte)(tag >> 8 & 0xFF);
            this.tiffheader[offset + 2] = 3;
            this.tiffheader[offset + 4] = 1;
            this.tiffheader[offset + 8] = (byte)(value & 0xFF);
            this.tiffheader[offset + 9] = (byte)(value >> 8 & 0xFF);
        }

        private void addTag(int tag, String value) {
            byte count = this.tiffheader[8] = (byte)(this.tiffheader[8] + 1);
            int offset = (count - 1) * 12 + 10;
            this.tiffheader[offset] = (byte)(tag & 0xFF);
            this.tiffheader[offset + 1] = (byte)(tag >> 8 & 0xFF);
            this.tiffheader[offset + 2] = 2;
            int len = value.length() + 1;
            this.tiffheader[offset + 4] = (byte)(len & 0xFF);
            this.tiffheader[offset + 8] = (byte)(this.additionalOffset & 0xFF);
            this.tiffheader[offset + 9] = (byte)(this.additionalOffset >> 8 & 0xFF);
            this.tiffheader[offset + 10] = (byte)(this.additionalOffset >> 16 & 0xFF);
            this.tiffheader[offset + 11] = (byte)(this.additionalOffset >> 24 & 0xFF);
            try {
                System.arraycopy(value.getBytes("US-ASCII"), 0, this.tiffheader, this.additionalOffset, value.length());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Incompatible VM without US-ASCII encoding", e);
            }
            this.additionalOffset += len;
        }

        private void addTag(int tag, long numerator, long denominator) {
            byte count = this.tiffheader[8] = (byte)(this.tiffheader[8] + 1);
            int offset = (count - 1) * 12 + 10;
            this.tiffheader[offset] = (byte)(tag & 0xFF);
            this.tiffheader[offset + 1] = (byte)(tag >> 8 & 0xFF);
            this.tiffheader[offset + 2] = 5;
            this.tiffheader[offset + 4] = 1;
            this.tiffheader[offset + 8] = (byte)(this.additionalOffset & 0xFF);
            this.tiffheader[offset + 9] = (byte)(this.additionalOffset >> 8 & 0xFF);
            this.tiffheader[offset + 10] = (byte)(this.additionalOffset >> 16 & 0xFF);
            this.tiffheader[offset + 11] = (byte)(this.additionalOffset >> 24 & 0xFF);
            this.tiffheader[this.additionalOffset++] = (byte)(numerator & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(numerator >> 8 & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(numerator >> 16 & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(numerator >> 24 & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(denominator & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(denominator >> 8 & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(denominator >> 16 & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(denominator >> 24 & 0xFFL);
        }
    }
}

