/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.shading;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.function.SMFunction;
import com.plpdf.smmodel.graphics.shading.SMShadingResources;
import java.io.IOException;

public class SMShadingType2
extends SMShadingResources {
    private OMArray coords = null;
    private OMArray domain = null;
    private OMArray extend = null;
    private SMFunction[] functionArray = null;

    public SMShadingType2(OMDictionary shadingDictionary) {
        super(shadingDictionary);
    }

    public int getShadingType() {
        return 2;
    }

    public OMArray getExtend() {
        if (this.extend == null) {
            this.extend = (OMArray)this.getOMDictionary().getDictionaryObject(OMName.EXTEND);
        }
        return this.extend;
    }

    public void setExtend(OMArray newExtend) {
        this.extend = newExtend;
        if (newExtend == null) {
            this.getOMDictionary().removeItem(OMName.EXTEND);
        } else {
            this.getOMDictionary().setItem(OMName.EXTEND, (OMBase)newExtend);
        }
    }

    public OMArray getDomain() {
        if (this.domain == null) {
            this.domain = (OMArray)this.getOMDictionary().getDictionaryObject(OMName.DOMAIN);
        }
        return this.domain;
    }

    public void setDomain(OMArray newDomain) {
        this.domain = newDomain;
        if (newDomain == null) {
            this.getOMDictionary().removeItem(OMName.DOMAIN);
        } else {
            this.getOMDictionary().setItem(OMName.DOMAIN, (OMBase)newDomain);
        }
    }

    public OMArray getCoords() {
        if (this.coords == null) {
            this.coords = (OMArray)this.getOMDictionary().getDictionaryObject(OMName.COORDS);
        }
        return this.coords;
    }

    public void setCoords(OMArray newCoords) {
        this.coords = newCoords;
        if (newCoords == null) {
            this.getOMDictionary().removeItem(OMName.COORDS);
        } else {
            this.getOMDictionary().setItem(OMName.COORDS, (OMBase)newCoords);
        }
    }

    public void setFunction(SMFunction newFunction) {
        this.functionArray = null;
        if (newFunction == null) {
            this.getOMDictionary().removeItem(OMName.FUNCTION);
        } else {
            this.getOMDictionary().setItem(OMName.FUNCTION, (OMObjectable)newFunction);
        }
    }

    public void setFunction(OMArray newFunctions) {
        this.functionArray = null;
        if (newFunctions == null) {
            this.getOMDictionary().removeItem(OMName.FUNCTION);
        } else {
            this.getOMDictionary().setItem(OMName.FUNCTION, (OMBase)newFunctions);
        }
    }

    public SMFunction getFunction() throws IOException {
        return null;
    }

    private SMFunction[] getFunctionsArray() throws IOException {
        if (this.functionArray == null) {
            OMBase functionObject = this.getOMDictionary().getDictionaryObject(OMName.FUNCTION);
            if (functionObject instanceof OMDictionary) {
                this.functionArray = new SMFunction[1];
                this.functionArray[0] = SMFunction.create(functionObject);
            } else {
                OMArray functionOMArray = (OMArray)functionObject;
                int numberOfFunctions = functionOMArray.size();
                this.functionArray = new SMFunction[numberOfFunctions];
                int i = 0;
                while (i < numberOfFunctions) {
                    this.functionArray[i] = SMFunction.create(functionOMArray.get(i));
                    ++i;
                }
            }
        }
        return this.functionArray;
    }

    public float[] evalFunction(float inputValue) throws IOException {
        float[] input = new float[]{inputValue};
        SMFunction[] functions = this.getFunctionsArray();
        int numberOfFunctions = functions.length;
        float[] returnValues = null;
        if (numberOfFunctions == 1) {
            returnValues = functions[0].eval(input);
        } else {
            returnValues = new float[numberOfFunctions];
            int i = 0;
            while (i < numberOfFunctions) {
                float[] newValue = functions[i].eval(input);
                returnValues[i] = newValue[0];
                ++i;
            }
        }
        return returnValues;
    }
}

