/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.shading;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMColorSpaceFactory;
import com.plpdf.smmodel.graphics.shading.SMShadingType1;
import com.plpdf.smmodel.graphics.shading.SMShadingType2;
import com.plpdf.smmodel.graphics.shading.SMShadingType3;
import com.plpdf.smmodel.graphics.shading.SMShadingType4;
import com.plpdf.smmodel.graphics.shading.SMShadingType5;
import com.plpdf.smmodel.graphics.shading.SMShadingType6;
import com.plpdf.smmodel.graphics.shading.SMShadingType7;
import java.io.IOException;

public abstract class SMShadingResources
implements OMObjectable {
    private OMDictionary dictionary;
    private OMArray background = null;
    private SMRectangle bBox = null;
    private SMColorSpace colorspace = null;
    public static final int SHADING_TYPE1 = 1;
    public static final int SHADING_TYPE2 = 2;
    public static final int SHADING_TYPE3 = 3;
    public static final int SHADING_TYPE4 = 4;
    public static final int SHADING_TYPE5 = 5;
    public static final int SHADING_TYPE6 = 6;
    public static final int SHADING_TYPE7 = 7;

    public SMShadingResources() {
        this.dictionary = new OMDictionary();
    }

    public SMShadingResources(OMDictionary shadingDictionary) {
        this.dictionary = shadingDictionary;
    }

    public OMDictionary getOMDictionary() {
        return this.dictionary;
    }

    public OMBase getOMObject() {
        return this.dictionary;
    }

    public String getType() {
        return OMName.SHADING.getName();
    }

    public void setShadingType(int shadingType) {
        this.dictionary.setInt(OMName.SHADING_TYPE, shadingType);
    }

    public abstract int getShadingType();

    public void setBackground(OMArray newBackground) {
        this.background = newBackground;
        this.dictionary.setItem(OMName.BACKGROUND, (OMBase)newBackground);
    }

    public OMArray getBackground() {
        if (this.background == null) {
            this.background = (OMArray)this.dictionary.getDictionaryObject(OMName.BACKGROUND);
        }
        return this.background;
    }

    public SMRectangle getBBox() {
        OMArray array;
        if (this.bBox == null && (array = (OMArray)this.dictionary.getDictionaryObject(OMName.BBOX)) != null) {
            this.bBox = new SMRectangle(array);
        }
        return this.bBox;
    }

    public void setBBox(SMRectangle newBBox) {
        this.bBox = newBBox;
        if (this.bBox == null) {
            this.dictionary.removeItem(OMName.BBOX);
        } else {
            this.dictionary.setItem(OMName.BBOX, (OMBase)this.bBox.getOMArray());
        }
    }

    public void setAntiAlias(boolean antiAlias) {
        this.dictionary.setBoolean(OMName.ANTI_ALIAS, antiAlias);
    }

    public boolean getAntiAlias() {
        return this.dictionary.getBoolean(OMName.ANTI_ALIAS, false);
    }

    public SMColorSpace getColorSpace() throws IOException {
        if (this.colorspace == null) {
            OMBase colorSpaceDictionary = this.dictionary.getDictionaryObject(OMName.CS, OMName.COLORSPACE);
            this.colorspace = SMColorSpaceFactory.createColorSpace(colorSpaceDictionary);
        }
        return this.colorspace;
    }

    public void setColorSpace(SMColorSpace newColorspace) {
        this.colorspace = newColorspace;
        if (newColorspace != null) {
            this.dictionary.setItem(OMName.COLORSPACE, newColorspace.getOMObject());
        } else {
            this.dictionary.removeItem(OMName.COLORSPACE);
        }
    }

    public static SMShadingResources create(OMDictionary resourceDictionary) throws IOException {
        SMShadingResources shading = null;
        int shadingType = resourceDictionary.getInt(OMName.SHADING_TYPE, 0);
        switch (shadingType) {
            case 1: {
                shading = new SMShadingType1(resourceDictionary);
                break;
            }
            case 2: {
                shading = new SMShadingType2(resourceDictionary);
                break;
            }
            case 3: {
                shading = new SMShadingType3(resourceDictionary);
                break;
            }
            case 4: {
                shading = new SMShadingType4(resourceDictionary);
                break;
            }
            case 5: {
                shading = new SMShadingType5(resourceDictionary);
                break;
            }
            case 6: {
                shading = new SMShadingType6(resourceDictionary);
                break;
            }
            case 7: {
                shading = new SMShadingType7(resourceDictionary);
                break;
            }
            default: {
                throw new IOException("Error: Unknown shading type " + shadingType);
            }
        }
        return shading;
    }
}

