/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.shading;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBoolean;
import com.plpdf.smmodel.common.function.SMFunction;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMDeviceN;
import com.plpdf.smmodel.graphics.color.SMDeviceRGB;
import com.plpdf.smmodel.graphics.color.SMSeparation;
import com.plpdf.smmodel.graphics.shading.SMShadingType3;
import com.plpdf.util.Matrix;
import java.awt.PaintContext;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.io.IOException;

public class RadialShadingContext
implements PaintContext {
    private ColorModel colorModel;
    private SMFunction function;
    private ColorSpace shadingColorSpace;
    private SMFunction shadingTinttransform;
    private float[] coords;
    private float[] domain;
    private int[] extend0Values;
    private int[] extend1Values;
    private boolean[] extend;
    private double x1x0;
    private double y1y0;
    private double r1r0;
    private double x1x0pow2;
    private double y1y0pow2;
    private double r0pow2;
    private float d1d0;
    private double denom;

    public RadialShadingContext(SMShadingType3 shadingType3, ColorModel colorModelValue, AffineTransform xform, Matrix ctm, int pageHeight) {
        this.coords = shadingType3.getCoords().toFloatArray();
        if (ctm != null) {
            float[] coordsTemp = new float[this.coords.length];
            ctm.createAffineTransform().transform(this.coords, 0, coordsTemp, 0, 1);
            ctm.createAffineTransform().transform(this.coords, 3, coordsTemp, 3, 1);
            coordsTemp[1] = (float)pageHeight - coordsTemp[1];
            coordsTemp[4] = (float)pageHeight - coordsTemp[4];
            xform.transform(coordsTemp, 0, this.coords, 0, 1);
            xform.transform(coordsTemp, 3, this.coords, 3, 1);
        } else {
            float translateY = (float)xform.getTranslateY();
            this.coords[1] = (float)pageHeight + translateY - this.coords[1];
            this.coords[4] = (float)pageHeight + translateY - this.coords[4];
        }
        try {
            SMColorSpace cs = shadingType3.getColorSpace();
            if (!(cs instanceof SMDeviceRGB)) {
                this.shadingColorSpace = cs.getJavaColorSpace();
                if (cs instanceof SMDeviceN) {
                    this.shadingTinttransform = ((SMDeviceN)cs).getTintTransform();
                } else if (cs instanceof SMSeparation) {
                    this.shadingTinttransform = ((SMSeparation)cs).getTintTransform();
                }
            }
        }
        catch (IOException cs) {
            // empty catch block
        }
        if (colorModelValue != null) {
            this.colorModel = colorModelValue;
        } else {
            try {
                this.colorModel = shadingType3.getColorSpace().createColorModel(8);
            }
            catch (IOException cs) {
                // empty catch block
            }
        }
        try {
            this.function = shadingType3.getFunction();
        }
        catch (IOException cs) {
            // empty catch block
        }
        this.domain = shadingType3.getDomain() != null ? shadingType3.getDomain().toFloatArray() : new float[]{0.0f, 1.0f};
        OMArray extendValues = shadingType3.getExtend();
        if (shadingType3.getExtend() != null) {
            this.extend = new boolean[2];
            this.extend[0] = ((OMBoolean)extendValues.get(0)).getValue();
            this.extend[1] = ((OMBoolean)extendValues.get(1)).getValue();
        } else {
            this.extend = new boolean[2];
        }
        this.x1x0 = this.coords[3] - this.coords[0];
        this.y1y0 = this.coords[4] - this.coords[1];
        this.r1r0 = this.coords[5] - this.coords[2];
        this.x1x0pow2 = Math.pow(this.x1x0, 2.0);
        this.y1y0pow2 = Math.pow(this.y1y0, 2.0);
        this.r0pow2 = Math.pow(this.coords[2], 2.0);
        this.denom = this.x1x0pow2 + this.y1y0pow2 - Math.pow(this.r1r0, 2.0);
        this.d1d0 = this.domain[1] - this.domain[0];
    }

    public void dispose() {
        this.colorModel = null;
        this.function = null;
        this.shadingColorSpace = null;
        this.shadingTinttransform = null;
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    /*
     * Unable to fully structure code
     */
    public Raster getRaster(int x, int y, int w, int h) {
        raster = this.getColorModel().createCompatibleWritableRaster(w, h);
        input = new float[1];
        saveExtend0 = false;
        saveExtend1 = false;
        data = new int[w * h * 3];
        j = 0;
        while (j < h) {
            i = 0;
            while (i < w) {
                block13: {
                    block12: {
                        block14: {
                            index = (j * w + i) * 3;
                            inputValues = this.calculateInputValues(x + i, y + j);
                            inputValue = inputValues[0] >= this.domain[0] && inputValues[0] <= this.domain[1] ? (inputValues[1] >= this.domain[0] && inputValues[1] <= this.domain[1] ? Math.max(inputValues[0], inputValues[1]) : inputValues[0]) : (inputValues[1] >= this.domain[0] && inputValues[1] <= this.domain[1] ? inputValues[1] : inputValues[0]);
                            if (!(inputValue < this.domain[0])) break block12;
                            if (!this.extend[0]) break block13;
                            if (this.extend0Values != null) break block14;
                            inputValue = this.domain[0];
                            saveExtend0 = true;
                            ** GOTO lbl30
                        }
                        System.arraycopy(this.extend0Values, 0, data, index, 3);
                        break block13;
                    }
                    if (!(inputValue > this.domain[1])) ** GOTO lbl30
                    if (!this.extend[1]) break block13;
                    if (this.extend1Values != null) {
                        System.arraycopy(this.extend1Values, 0, data, index, 3);
                    } else {
                        inputValue = this.domain[1];
                        saveExtend1 = true;
lbl30:
                        // 3 sources

                        input[0] = this.domain[0] + this.d1d0 * inputValue;
                        values = null;
                        try {
                            values = this.function.eval(input);
                            if (this.shadingColorSpace != null) {
                                if (this.shadingTinttransform != null) {
                                    values = this.shadingTinttransform.eval(values);
                                }
                                values = this.shadingColorSpace.toRGB(values);
                            }
                        }
                        catch (IOException var16_16) {
                            // empty catch block
                        }
                        data[index] = (int)(values[0] * 255.0f);
                        data[index + 1] = (int)(values[1] * 255.0f);
                        data[index + 2] = (int)(values[2] * 255.0f);
                        if (saveExtend0) {
                            this.extend0Values = new int[3];
                            System.arraycopy(data, index, this.extend0Values, 0, 3);
                        }
                        if (saveExtend1) {
                            this.extend1Values = new int[3];
                            System.arraycopy(data, index, this.extend1Values, 0, 3);
                        }
                    }
                }
                ++i;
            }
            ++j;
        }
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }

    private float[] calculateInputValues(int x, int y) {
        float[] values = new float[2];
        double p = -0.25 * ((double)((float)x - this.coords[0]) * this.x1x0 + (double)((float)y - this.coords[1]) * this.y1y0 - this.r1r0) / this.denom;
        double q = (Math.pow((float)x - this.coords[0], 2.0) + Math.pow((float)y - this.coords[1], 2.0) - this.r0pow2) / this.denom;
        double root = Math.sqrt(Math.pow(p, 2.0) - q);
        values[0] = (float)(-1.0 * p + root);
        values[1] = (float)(-1.0 * p - root);
        return values;
    }
}

