/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.shading;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBoolean;
import com.plpdf.smmodel.common.function.SMFunction;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMDeviceN;
import com.plpdf.smmodel.graphics.color.SMDeviceRGB;
import com.plpdf.smmodel.graphics.color.SMSeparation;
import com.plpdf.smmodel.graphics.shading.SMShadingType2;
import com.plpdf.util.Matrix;
import java.awt.PaintContext;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.io.IOException;

public class AxialShadingContext
implements PaintContext {
    private ColorModel colorModel;
    private ColorSpace shadingColorSpace;
    private SMFunction shadingTinttransform;
    private SMShadingType2 shadingType;
    private float[] coords;
    private float[] domain;
    private int[] extend0Values;
    private int[] extend1Values;
    private boolean[] extend;
    private double x1x0;
    private double y1y0;
    private float d1d0;
    private double denom;

    public AxialShadingContext(SMShadingType2 shadingType2, ColorModel colorModelValue, AffineTransform xform, Matrix ctm, int pageHeight) {
        this.shadingType = shadingType2;
        this.coords = this.shadingType.getCoords().toFloatArray();
        if (ctm != null) {
            float[] coordsTemp = new float[this.coords.length];
            ctm.createAffineTransform().transform(this.coords, 0, coordsTemp, 0, 2);
            coordsTemp[1] = (float)pageHeight - coordsTemp[1];
            coordsTemp[3] = (float)pageHeight - coordsTemp[3];
            xform.transform(coordsTemp, 0, this.coords, 0, 2);
        } else {
            float translateY = (float)xform.getTranslateY();
            this.coords[1] = (float)pageHeight + translateY - this.coords[1];
            this.coords[3] = (float)pageHeight + translateY - this.coords[3];
        }
        try {
            SMColorSpace cs = this.shadingType.getColorSpace();
            if (!(cs instanceof SMDeviceRGB)) {
                this.shadingColorSpace = cs.getJavaColorSpace();
                if (cs instanceof SMDeviceN) {
                    this.shadingTinttransform = ((SMDeviceN)cs).getTintTransform();
                } else if (cs instanceof SMSeparation) {
                    this.shadingTinttransform = ((SMSeparation)cs).getTintTransform();
                }
            }
        }
        catch (IOException cs) {
            // empty catch block
        }
        if (colorModelValue != null) {
            this.colorModel = colorModelValue;
        } else {
            try {
                this.colorModel = this.shadingType.getColorSpace().createColorModel(8);
            }
            catch (IOException cs) {
                // empty catch block
            }
        }
        this.domain = this.shadingType.getDomain() != null ? this.shadingType.getDomain().toFloatArray() : new float[]{0.0f, 1.0f};
        OMArray extendValues = this.shadingType.getExtend();
        if (this.shadingType.getExtend() != null) {
            this.extend = new boolean[2];
            this.extend[0] = ((OMBoolean)extendValues.get(0)).getValue();
            this.extend[1] = ((OMBoolean)extendValues.get(1)).getValue();
        } else {
            this.extend = new boolean[2];
        }
        this.x1x0 = this.coords[2] - this.coords[0];
        this.y1y0 = this.coords[3] - this.coords[1];
        this.d1d0 = this.domain[1] - this.domain[0];
        this.denom = Math.pow(this.x1x0, 2.0) + Math.pow(this.y1y0, 2.0);
    }

    public void dispose() {
        this.colorModel = null;
        this.shadingColorSpace = null;
        this.shadingTinttransform = null;
        this.shadingType = null;
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    /*
     * Unable to fully structure code
     */
    public Raster getRaster(int x, int y, int w, int h) {
        raster = this.getColorModel().createCompatibleWritableRaster(w, h);
        data = new int[w * h * 3];
        saveExtend0 = false;
        saveExtend1 = false;
        j = 0;
        while (j < h) {
            i = 0;
            while (i < w) {
                block13: {
                    block12: {
                        block14: {
                            index = (j * w + i) * 3;
                            inputValue = this.x1x0 * (double)((float)(x + i) - this.coords[0]);
                            inputValue += this.y1y0 * (double)((float)(y + j) - this.coords[1]);
                            if (!((inputValue /= this.denom) < (double)this.domain[0])) break block12;
                            if (!this.extend[0]) break block13;
                            if (this.extend0Values != null) break block14;
                            inputValue = this.domain[0];
                            saveExtend0 = true;
                            ** GOTO lbl29
                        }
                        System.arraycopy(this.extend0Values, 0, data, index, 3);
                        break block13;
                    }
                    if (!(inputValue > (double)this.domain[1])) ** GOTO lbl29
                    if (!this.extend[1]) break block13;
                    if (this.extend1Values != null) {
                        System.arraycopy(this.extend1Values, 0, data, index, 3);
                    } else {
                        inputValue = this.domain[1];
                        saveExtend1 = true;
lbl29:
                        // 3 sources

                        input = (float)((double)this.domain[0] + (double)this.d1d0 * inputValue);
                        values = null;
                        try {
                            values = this.shadingType.evalFunction(input);
                            if (this.shadingColorSpace != null) {
                                if (this.shadingTinttransform != null) {
                                    values = this.shadingTinttransform.eval(values);
                                }
                                values = this.shadingColorSpace.toRGB(values);
                            }
                        }
                        catch (IOException var16_15) {
                            // empty catch block
                        }
                        data[index] = (int)(values[0] * 255.0f);
                        data[index + 1] = (int)(values[1] * 255.0f);
                        data[index + 2] = (int)(values[2] * 255.0f);
                        if (saveExtend0) {
                            this.extend0Values = new int[3];
                            System.arraycopy(data, index, this.extend0Values, 0, 3);
                        }
                        if (saveExtend1) {
                            this.extend1Values = new int[3];
                            System.arraycopy(data, index, this.extend1Values, 0, 3);
                        }
                    }
                }
                ++i;
            }
            ++j;
        }
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }
}

