/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.predictor;

import com.plpdf.smmodel.graphics.predictor.PredictorAlgorithm;

public class Paeth
extends PredictorAlgorithm {
    public int paethPredictor(int a, int b, int c) {
        int p = a + b - c;
        int pa = Math.abs(p - a);
        int pb = Math.abs(p - b);
        int pc = Math.abs(p - c);
        if (pa <= pb && pa <= pc) {
            return a;
        }
        if (pb <= pc) {
            return b;
        }
        return c;
    }

    public void encodeLine(byte[] src, byte[] dest, int srcDy, int srcOffset, int destDy, int destOffset) {
        int bpl = this.getWidth() * this.getBpp();
        int x = 0;
        while (x < bpl) {
            dest[x + destOffset] = (byte)(src[x + srcOffset] - this.paethPredictor(this.leftPixel(src, srcOffset, srcDy, x), this.abovePixel(src, srcOffset, srcDy, x), this.aboveLeftPixel(src, srcOffset, srcDy, x)));
            ++x;
        }
    }

    public void decodeLine(byte[] src, byte[] dest, int srcDy, int srcOffset, int destDy, int destOffset) {
        int bpl = this.getWidth() * this.getBpp();
        int x = 0;
        while (x < bpl) {
            dest[x + destOffset] = (byte)(src[x + srcOffset] + this.paethPredictor(this.leftPixel(dest, destOffset, destDy, x), this.abovePixel(dest, destOffset, destDy, x), this.aboveLeftPixel(dest, destOffset, destDy, x)));
            ++x;
        }
    }
}

