/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.predictor;

import com.plpdf.smmodel.graphics.predictor.Average;
import com.plpdf.smmodel.graphics.predictor.None;
import com.plpdf.smmodel.graphics.predictor.Paeth;
import com.plpdf.smmodel.graphics.predictor.PredictorAlgorithm;
import com.plpdf.smmodel.graphics.predictor.Sub;
import com.plpdf.smmodel.graphics.predictor.Up;

public class Optimum
extends PredictorAlgorithm {
    PredictorAlgorithm[] filter = new PredictorAlgorithm[]{new None(), new Sub(), new Up(), new Average(), new Paeth()};

    public void checkBufsiz(byte[] filtered, byte[] raw) {
        if (filtered.length != (this.getWidth() * this.getBpp() + 1) * this.getHeight()) {
            throw new IllegalArgumentException("filtered.length != (width*bpp + 1) * height, " + filtered.length + " " + (this.getWidth() * this.getBpp() + 1) * this.getHeight() + "w,h,bpp=" + this.getWidth() + "," + this.getHeight() + "," + this.getBpp());
        }
        if (raw.length != this.getWidth() * this.getHeight() * this.getBpp()) {
            throw new IllegalArgumentException("raw.length != width * height * bpp, raw.length=" + raw.length + " w,h,bpp=" + this.getWidth() + "," + this.getHeight() + "," + this.getBpp());
        }
    }

    public void encodeLine(byte[] src, byte[] dest, int srcDy, int srcOffset, int destDy, int destOffset) {
        throw new UnsupportedOperationException("encodeLine");
    }

    public void decodeLine(byte[] src, byte[] dest, int srcDy, int srcOffset, int destDy, int destOffset) {
        throw new UnsupportedOperationException("decodeLine");
    }

    public void encode(byte[] src, byte[] dest) {
        this.checkBufsiz(dest, src);
        throw new UnsupportedOperationException("encode");
    }

    public void setBpp(int bpp) {
        super.setBpp(bpp);
        int i = 0;
        while (i < this.filter.length) {
            this.filter[i].setBpp(bpp);
            ++i;
        }
    }

    public void setHeight(int height) {
        super.setHeight(height);
        int i = 0;
        while (i < this.filter.length) {
            this.filter[i].setHeight(height);
            ++i;
        }
    }

    public void setWidth(int width) {
        super.setWidth(width);
        int i = 0;
        while (i < this.filter.length) {
            this.filter[i].setWidth(width);
            ++i;
        }
    }

    public void decode(byte[] src, byte[] dest) {
        this.checkBufsiz(src, dest);
        int bpl = this.getWidth() * this.getBpp();
        int srcDy = bpl + 1;
        int y = 0;
        while (y < this.getHeight()) {
            PredictorAlgorithm f = this.filter[src[y * srcDy]];
            int srcOffset = y * srcDy + 1;
            f.decodeLine(src, dest, srcDy, srcOffset, bpl, y * bpl);
            ++y;
        }
    }
}

