/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.pattern;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.graphics.SMExtendedGraphicsState;
import com.plpdf.smmodel.graphics.pattern.SMPatternResources;
import com.plpdf.smmodel.graphics.shading.AxialShadingPaint;
import com.plpdf.smmodel.graphics.shading.RadialShadingPaint;
import com.plpdf.smmodel.graphics.shading.SMShadingResources;
import com.plpdf.smmodel.graphics.shading.SMShadingType2;
import com.plpdf.smmodel.graphics.shading.SMShadingType3;
import com.plpdf.util.Matrix;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.io.IOException;

public class SMShadingPatternResources
extends SMPatternResources {
    private SMExtendedGraphicsState extendedGraphicsState;
    private SMShadingResources shading;
    private OMArray matrix = null;

    public SMShadingPatternResources() {
        this.getOMDictionary().setInt(OMName.PATTERN_TYPE, 2);
    }

    public SMShadingPatternResources(OMDictionary resourceDictionary) {
        super(resourceDictionary);
    }

    public int getPatternType() {
        return 2;
    }

    public Matrix getMatrix() {
        Matrix returnMatrix = null;
        if (this.matrix == null) {
            this.matrix = (OMArray)this.getOMDictionary().getDictionaryObject(OMName.MATRIX);
        }
        if (this.matrix != null) {
            returnMatrix = new Matrix();
            returnMatrix.setValue(0, 0, ((OMNumber)this.matrix.get(0)).floatValue());
            returnMatrix.setValue(0, 1, ((OMNumber)this.matrix.get(1)).floatValue());
            returnMatrix.setValue(1, 0, ((OMNumber)this.matrix.get(2)).floatValue());
            returnMatrix.setValue(1, 1, ((OMNumber)this.matrix.get(3)).floatValue());
            returnMatrix.setValue(2, 0, ((OMNumber)this.matrix.get(4)).floatValue());
            returnMatrix.setValue(2, 1, ((OMNumber)this.matrix.get(5)).floatValue());
        }
        return returnMatrix;
    }

    public void setMatrix(AffineTransform transform) {
        this.matrix = new OMArray();
        double[] values = new double[6];
        transform.getMatrix(values);
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            this.matrix.add(new OMFloat((float)v));
            ++n2;
        }
        this.getOMDictionary().setItem(OMName.MATRIX, (OMBase)this.matrix);
    }

    public SMExtendedGraphicsState getExtendedGraphicsState() {
        OMDictionary dictionary;
        if (this.extendedGraphicsState == null && (dictionary = (OMDictionary)this.getOMDictionary().getDictionaryObject(OMName.EXT_G_STATE)) != null) {
            this.extendedGraphicsState = new SMExtendedGraphicsState(dictionary);
        }
        return this.extendedGraphicsState;
    }

    public void setExtendedGraphicsState(SMExtendedGraphicsState extendedGraphicsState) {
        this.extendedGraphicsState = extendedGraphicsState;
        if (extendedGraphicsState != null) {
            this.getOMDictionary().setItem(OMName.EXT_G_STATE, (OMObjectable)extendedGraphicsState);
        } else {
            this.getOMDictionary().removeItem(OMName.EXT_G_STATE);
        }
    }

    public SMShadingResources getShading() throws IOException {
        OMDictionary dictionary;
        if (this.shading == null && (dictionary = (OMDictionary)this.getOMDictionary().getDictionaryObject(OMName.SHADING)) != null) {
            this.shading = SMShadingResources.create(dictionary);
        }
        return this.shading;
    }

    public void setShading(SMShadingResources shadingResources) {
        this.shading = shadingResources;
        if (shadingResources != null) {
            this.getOMDictionary().setItem(OMName.SHADING, (OMObjectable)shadingResources);
        } else {
            this.getOMDictionary().removeItem(OMName.SHADING);
        }
    }

    public Paint getPaint(int pageHeight) throws IOException {
        Paint paint = null;
        SMShadingResources shadingResources = this.getShading();
        int shadingType = shadingResources != null ? shadingResources.getShadingType() : 0;
        switch (shadingType) {
            case 2: {
                paint = new AxialShadingPaint((SMShadingType2)this.getShading(), null, pageHeight);
                break;
            }
            case 3: {
                paint = new RadialShadingPaint((SMShadingType3)this.getShading(), null, pageHeight);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new IOException("Error: Unknown shading type " + shadingType);
            }
        }
        return paint;
    }
}

