/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.pattern;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.graphics.pattern.SMShadingPatternResources;
import com.plpdf.smmodel.graphics.pattern.SMTilingPatternResources;
import java.awt.Paint;
import java.io.IOException;

public abstract class SMPatternResources
implements OMObjectable {
    private OMDictionary patternDictionary;
    public static final int TILING_PATTERN = 1;
    public static final int SHADING_PATTERN = 2;

    public SMPatternResources() {
        this.patternDictionary = new OMDictionary();
        this.patternDictionary.setName(OMName.TYPE, OMName.PATTERN.getName());
    }

    public SMPatternResources(OMDictionary resourceDictionary) {
        this.patternDictionary = resourceDictionary;
    }

    public OMDictionary getOMDictionary() {
        return this.patternDictionary;
    }

    public OMBase getOMObject() {
        return this.patternDictionary;
    }

    public void setFilter(String filter) {
        this.patternDictionary.setItem(OMName.FILTER, (OMBase)OMName.getPDFName(filter));
    }

    public String getFilter() {
        return this.patternDictionary.getNameAsString(OMName.FILTER);
    }

    public void setLength(int length) {
        this.patternDictionary.setInt(OMName.LENGTH, length);
    }

    public int getLength() {
        return this.patternDictionary.getInt(OMName.LENGTH, 0);
    }

    public void setPaintType(int paintType) {
        this.patternDictionary.setInt(OMName.PAINT_TYPE, paintType);
    }

    public String getType() {
        return OMName.PATTERN.getName();
    }

    public void setPatternType(int patternType) {
        this.patternDictionary.setInt(OMName.PATTERN_TYPE, patternType);
    }

    public abstract int getPatternType();

    public static SMPatternResources create(OMDictionary resourceDictionary) throws IOException {
        SMPatternResources pattern = null;
        int patternType = resourceDictionary.getInt(OMName.PATTERN_TYPE, 0);
        switch (patternType) {
            case 1: {
                pattern = new SMTilingPatternResources(resourceDictionary);
                break;
            }
            case 2: {
                pattern = new SMShadingPatternResources(resourceDictionary);
                break;
            }
            default: {
                throw new IOException("Error: Unknown pattern type " + patternType);
            }
        }
        return pattern;
    }

    public abstract Paint getPaint(int var1) throws IOException;
}

