/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.optionalcontent;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMObject;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.graphics.optionalcontent.SMOptionalContentGroup;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMOptionalContentProperties
implements OMObjectable {
    private OMDictionary dict;
    private OMArray ocgs = null;
    private OMDictionary configdict = null;
    private OMArray orders = null;
    private OMArray ons = null;
    private OMArray offs = null;
    private OMArray ass = null;
    private OMDictionary asprintdict = null;
    private OMDictionary asviewdict = null;
    private OMArray asprint = null;
    private OMArray asview = null;

    public SMOptionalContentProperties() {
        this.dict = new OMDictionary();
        this.dict.setItem(OMName.OCGS, (OMBase)new OMArray());
        this.dict.setItem(OMName.D, (OMBase)new OMDictionary());
    }

    public SMOptionalContentProperties(OMDictionary props) {
        this.dict = props;
    }

    @Override
    public OMBase getOMObject() {
        return this.dict;
    }

    private OMArray getOCGs() {
        OMArray ocgs = (OMArray)this.dict.getItem(OMName.OCGS);
        if (ocgs == null) {
            ocgs = new OMArray();
            this.dict.setItem(OMName.OCGS, (OMBase)ocgs);
        }
        return ocgs;
    }

    private OMDictionary getD() {
        OMDictionary d = (OMDictionary)this.dict.getDictionaryObject(OMName.D);
        if (d == null) {
            d = new OMDictionary();
            this.dict.setItem(OMName.D, (OMBase)d);
        }
        return d;
    }

    public SMOptionalContentGroup getGroup(String name) {
        OMArray ocgs = this.getOCGs();
        for (OMBase o : ocgs) {
            OMDictionary ocg = this.toDictionary(o);
            String groupName = ocg.getString(OMName.NAME);
            if (!groupName.equals(name)) continue;
            return new SMOptionalContentGroup(ocg);
        }
        return null;
    }

    public void addGroup(SMOptionalContentGroup ocg) {
        OMArray ocgs = this.getOCGs();
        ocgs.add(ocg.getOMObject());
        OMArray order = (OMArray)this.getD().getDictionaryObject(OMName.ORDER);
        if (order == null) {
            order = new OMArray();
            this.getD().setItem(OMName.ORDER, (OMBase)order);
        }
        order.add(ocg);
    }

    public Collection<SMOptionalContentGroup> getOptionalContentGroups() {
        ArrayList<SMOptionalContentGroup> coll = new ArrayList<SMOptionalContentGroup>();
        OMArray ocgs = this.getOCGs();
        for (OMBase base : ocgs) {
            OMObject obj = (OMObject)base;
            coll.add(new SMOptionalContentGroup((OMDictionary)obj.getObject()));
        }
        return coll;
    }

    public BaseState getBaseState() {
        OMDictionary d = this.getD();
        OMName name = (OMName)d.getItem(OMName.BASE_STATE);
        return BaseState.valueOf(name);
    }

    public void setBaseState(BaseState state) {
        OMDictionary d = this.getD();
        d.setItem(OMName.BASE_STATE, (OMBase)state.getName());
    }

    public String[] getGroupNames() {
        OMArray ocgs = (OMArray)this.dict.getDictionaryObject(OMName.OCGS);
        int size = ocgs.size();
        String[] groups = new String[size];
        int i = 0;
        while (i < size) {
            OMBase obj = ocgs.get(i);
            OMDictionary ocg = this.toDictionary(obj);
            groups[i] = ocg.getString(OMName.NAME);
            ++i;
        }
        return groups;
    }

    public boolean hasGroup(String groupName) {
        String[] layers;
        String[] stringArray = layers = this.getGroupNames();
        int n = layers.length;
        int n2 = 0;
        while (n2 < n) {
            String layer = stringArray[n2];
            if (layer.equals(groupName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isGroupEnabled(String groupName) {
        BaseState baseState;
        OMArray off;
        OMDictionary d = this.getD();
        OMArray on = (OMArray)d.getDictionaryObject(OMName.ON);
        if (on != null) {
            for (OMBase o : on) {
                OMDictionary group = this.toDictionary(o);
                String name = group.getString(OMName.NAME);
                if (!name.equals(groupName)) continue;
                return true;
            }
        }
        if ((off = (OMArray)d.getDictionaryObject(OMName.OFF)) != null) {
            for (OMBase o : off) {
                OMDictionary group = this.toDictionary(o);
                String name = group.getString(OMName.NAME);
                if (!name.equals(groupName)) continue;
                return false;
            }
        }
        boolean enabled = !(baseState = this.getBaseState()).equals((Object)BaseState.OFF);
        return enabled;
    }

    private OMDictionary toDictionary(OMBase o) {
        if (o instanceof OMObject) {
            return (OMDictionary)((OMObject)o).getObject();
        }
        return (OMDictionary)o;
    }

    public boolean setGroupEnabled(String groupName, boolean enable) {
        OMArray off;
        OMDictionary d = this.getD();
        OMArray on = (OMArray)d.getDictionaryObject(OMName.ON);
        if (on == null) {
            on = new OMArray();
            d.setItem(OMName.ON, (OMBase)on);
        }
        if ((off = (OMArray)d.getDictionaryObject(OMName.OFF)) == null) {
            off = new OMArray();
            d.setItem(OMName.OFF, (OMBase)off);
        }
        boolean found = false;
        if (enable) {
            for (OMBase o : off) {
                OMDictionary group = this.toDictionary(o);
                String name = group.getString(OMName.NAME);
                if (!name.equals(groupName)) continue;
                off.remove(group);
                on.add(group);
                found = true;
                break;
            }
        } else {
            for (OMBase o : on) {
                OMDictionary group = this.toDictionary(o);
                String name = group.getString(OMName.NAME);
                if (!name.equals(groupName)) continue;
                on.remove(group);
                off.add(group);
                found = true;
                break;
            }
        }
        if (!found) {
            SMOptionalContentGroup ocg = this.getGroup(groupName);
            if (enable) {
                on.add(ocg.getOMObject());
            } else {
                off.add(ocg.getOMObject());
            }
        }
        return found;
    }

    public void addLayer(SMOptionalContentGroup layer, boolean addorder) {
        this.getOCGs();
        this.getConfigDict();
        this.getOrder();
        this.addOCGs(layer);
        if (addorder) {
            this.addOrder(layer);
        }
    }

    public void addLayer(SMOptionalContentGroup layer, boolean addorder, boolean state) {
        this.getOCGs();
        this.getConfigDict();
        this.getOrder();
        this.getoffs();
        this.getons();
        this.getass();
        this.addOCGs(layer);
        if (addorder) {
            this.addOrder(layer);
        }
        if (state) {
            this.addons(layer);
        } else {
            this.addoffs(layer);
        }
        this.addass(layer);
    }

    public void getConfigDict() {
        if (this.configdict == null) {
            this.configdict = (OMDictionary)this.dict.getDictionaryObject(OMName.OC_CONFIG_DICT);
        }
        if (this.configdict == null) {
            this.configdict = new OMDictionary();
            this.dict.setItem(OMName.OC_CONFIG_DICT, (OMBase)this.configdict);
            this.configdict.setItem(OMName.getPDFName("ListMode"), (OMBase)OMName.getPDFName("VisiblePages"));
        }
    }

    public void getOrder() {
        if (this.orders == null) {
            this.orders = (OMArray)this.configdict.getDictionaryObject(OMName.OC_ORDER);
            if (this.orders == null) {
                this.orders = new OMArray();
                this.configdict.setItem(OMName.OC_ORDER, (OMBase)this.orders);
            }
        }
    }

    public void addOrder(SMOptionalContentGroup layer) {
        this.orders.add(layer);
    }

    public void getons() {
        if (this.ons == null) {
            this.ons = (OMArray)this.configdict.getDictionaryObject(OMName.ON);
            if (this.ons == null) {
                this.ons = new OMArray();
                this.configdict.setItem(OMName.ON, (OMBase)this.ons);
            }
        }
    }

    public void addons(SMOptionalContentGroup layer) {
        this.ons.add(layer);
    }

    public void getoffs() {
        if (this.offs == null) {
            this.offs = (OMArray)this.configdict.getDictionaryObject(OMName.OFF);
            if (this.offs == null) {
                this.offs = new OMArray();
                this.configdict.setItem(OMName.OFF, (OMBase)this.offs);
            }
        }
    }

    public void addoffs(SMOptionalContentGroup layer) {
        this.offs.add(layer);
    }

    public void getass() {
        if (this.ass == null) {
            this.ass = (OMArray)this.configdict.getDictionaryObject(OMName.AS);
            if (this.ass == null) {
                this.ass = new OMArray();
                this.configdict.setItem(OMName.AS, (OMBase)this.ass);
            }
        }
        this.asprintdict = new OMDictionary();
        this.asprint = new OMArray();
        this.ass.add(this.asprintdict);
        this.asprintdict.setItem(OMName.EVENT, (OMBase)OMName.PRINT);
        this.asprintdict.setItem(OMName.OCGS, (OMBase)this.asprint);
        OMArray catprint = new OMArray();
        catprint.add(OMName.PRINT);
        this.asprintdict.setItem(OMName.CATEGORY, (OMBase)catprint);
        this.asviewdict = new OMDictionary();
        this.asview = new OMArray();
        this.ass.add(this.asviewdict);
        this.asviewdict.setItem(OMName.EVENT, (OMBase)OMName.VIEW);
        this.asviewdict.setItem(OMName.OCGS, (OMBase)this.asview);
        OMArray catview = new OMArray();
        catview.add(OMName.VIEW);
        this.asviewdict.setItem(OMName.CATEGORY, (OMBase)catview);
    }

    public void addass(SMOptionalContentGroup layer) {
        this.asprint.add(layer);
    }

    public void addOCGs(SMOptionalContentGroup layer) {
        this.ocgs.add(layer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BaseState {
        ON(OMName.ON),
        OFF(OMName.OFF),
        UNCHANGED(OMName.UNCHANGED);

        private OMName name;

        private BaseState(OMName value) {
            this.name = value;
        }

        public OMName getName() {
            return this.name;
        }

        public static BaseState valueOf(String string) {
            return Enum.valueOf(BaseState.class, string);
        }
    }
}

