/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.optionalcontent;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.interactive.action.type.SMActionSetOCGState;
import java.io.IOException;

public class SMOptionalContentGroup
implements OMObjectable {
    private OMDictionary ocg;
    protected String title;
    SMActionSetOCGState setoffaction;
    SMActionSetOCGState setonaction;

    public SMOptionalContentGroup(String name) throws IOException {
        this.ocg = new OMDictionary();
        this.ocg.setItem(OMName.TYPE, (OMBase)OMName.OCG);
        this.setName(name);
    }

    public SMOptionalContentGroup(OMDictionary dict) {
        if (!dict.getItem(OMName.TYPE).equals(OMName.OCG)) {
            throw new IllegalArgumentException("Provided dictionary is not of type '" + OMName.OCG + "'");
        }
        this.ocg = dict;
    }

    public SMOptionalContentGroup(SMDocument doc, String name, boolean addorder) throws IOException, PlpdfException {
        this.ocg = new OMDictionary();
        this.ocg.setItem(OMName.TYPE, (OMBase)OMName.getPDFName("OCG"));
        this.setName(name);
        doc.addLayer(this, addorder);
    }

    public SMOptionalContentGroup(SMDocument doc, String name, boolean addorder, boolean state) throws IOException, PlpdfException {
        this.ocg = new OMDictionary();
        this.ocg.setItem(OMName.TYPE, (OMBase)OMName.getPDFName("OCG"));
        this.setName(name);
        doc.addLayer(this, addorder, state);
    }

    public OMBase getOMObject() {
        return this.ocg;
    }

    public String getName() {
        return this.ocg.getString(OMName.NAME);
    }

    public void setName(String name) throws IOException {
        this.ocg.setString(OMName.NAME, name);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " (" + this.getName() + ")";
    }

    private OMDictionary getUsage() {
        OMDictionary usage = (OMDictionary)this.ocg.getDictionaryObject(OMName.USAGE);
        if (usage == null) {
            usage = new OMDictionary();
            this.ocg.setItem(OMName.USAGE, (OMBase)usage);
        }
        return usage;
    }

    public void setCreatorInfo(String creator, String subtype) throws IOException, PlpdfException {
        OMDictionary usage = this.getUsage();
        OMDictionary dic = new OMDictionary();
        dic.setString(OMName.CREATOR, creator);
        dic.setName(OMName.SUBTYPE, subtype);
        usage.setItem(OMName.CREATORINFO, (OMBase)dic);
    }

    public void setLanguage(String lang, boolean preferred) throws IOException, PlpdfException {
        OMDictionary usage = this.getUsage();
        OMDictionary dic = new OMDictionary();
        dic.setString(OMName.LANG, lang);
        if (preferred) {
            dic.setName(OMName.PREFERRED, "ON");
        }
        usage.setItem(OMName.LANGUAGE, (OMBase)dic);
    }

    public void setExport(boolean export) {
        OMDictionary usage = this.getUsage();
        OMDictionary dic = new OMDictionary();
        if (export) {
            dic.setName(OMName.EXPORTSTATE, "ON");
        } else {
            dic.setName(OMName.EXPORTSTATE, "OFF");
        }
        usage.setItem(OMName.EXPORT, (OMBase)dic);
    }

    public void setZoom(float min, float max) {
        if (min <= 0.0f && max < 0.0f) {
            return;
        }
        OMDictionary usage = this.getUsage();
        OMDictionary dic = new OMDictionary();
        if (min > 0.0f) {
            dic.setFloat(OMName.MIN, min);
        }
        if (max >= 0.0f) {
            dic.setFloat(OMName.MAX, max);
        }
        usage.setItem(OMName.ZOOM, (OMBase)dic);
    }

    public void setPrint(String subtype, boolean printstate) {
        OMDictionary usage = this.getUsage();
        OMDictionary dic = new OMDictionary();
        dic.setName(OMName.SUBTYPE, subtype);
        if (printstate) {
            dic.setName(OMName.PRINTSTATE, "ON");
        } else {
            dic.setName(OMName.PRINTSTATE, "OFF");
        }
        usage.setItem(OMName.PRINT, (OMBase)dic);
    }

    public void setPrint(boolean printstate) {
        OMDictionary usage = this.getUsage();
        OMDictionary dic = new OMDictionary();
        if (printstate) {
            dic.setName(OMName.PRINTSTATE, "ON");
        } else {
            dic.setName(OMName.PRINTSTATE, "OFF");
        }
        usage.setItem(OMName.PRINT, (OMBase)dic);
    }

    public void setView(boolean view) {
        OMDictionary usage = this.getUsage();
        OMDictionary dic = new OMDictionary();
        if (view) {
            dic.setName(OMName.VIEWSTATE, "ON");
        } else {
            dic.setName(OMName.VIEWSTATE, "OFF");
        }
        usage.setItem(OMName.VIEW, (OMBase)dic);
    }

    public OMDictionary getDictionary() {
        return this.ocg;
    }

    public void addOffAction() throws PlpdfException {
        this.setoffaction = new SMActionSetOCGState();
        this.setoffaction.addState(this, "OFF");
    }

    public SMActionSetOCGState getOffAction() {
        return this.setoffaction;
    }

    public void addOnAction() throws PlpdfException {
        this.setonaction = new SMActionSetOCGState();
        this.setonaction.addState(this, "ON");
    }

    public SMActionSetOCGState getOnAction() {
        return this.setonaction;
    }

    public void addOffOnAction() throws PlpdfException {
        this.addOffAction();
        this.addOnAction();
    }
}

