/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.color;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.function.SMFunction;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMColorSpaceFactory;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.io.IOException;

public class SMSeparation
extends SMColorSpace {
    public static final String NAME = "Separation";

    public SMSeparation() {
        this.array = new OMArray();
        this.array.add(OMName.SEPARATION);
        this.array.add(OMName.getPDFName(""));
    }

    public SMSeparation(OMArray separation) {
        this.array = separation;
    }

    public String getName() {
        return NAME;
    }

    public int getNumberOfComponents() throws IOException {
        return this.getAlternateColorSpace().getNumberOfComponents();
    }

    protected ColorSpace createColorSpace() throws IOException {
        try {
            SMColorSpace alt = this.getAlternateColorSpace();
            return alt.getJavaColorSpace();
        }
        catch (IOException ioexception) {
            throw ioexception;
        }
        catch (Exception exception) {
            throw new IOException("Failed to Create ColorSpace");
        }
    }

    public ColorModel createColorModel(int bpc) throws IOException {
        return this.getAlternateColorSpace().createColorModel(bpc);
    }

    public String getColorantName() {
        OMName name = (OMName)this.array.getObject(1);
        return name.getName();
    }

    public void setColorantName(String name) {
        this.array.set(1, OMName.getPDFName(name));
    }

    public SMColorSpace getAlternateColorSpace() throws IOException {
        OMBase alternate = this.array.getObject(2);
        SMColorSpace cs = SMColorSpaceFactory.createColorSpace(alternate);
        return cs;
    }

    public void setAlternateColorSpace(SMColorSpace cs) {
        OMBase space = null;
        if (cs != null) {
            space = cs.getOMObject();
        }
        this.array.set(2, space);
    }

    public SMFunction getTintTransform() throws IOException {
        return SMFunction.create(this.array.getObject(3));
    }

    public void setTintTransform(SMFunction tint) {
        this.array.set(3, tint);
    }

    public OMArray calculateColorValues(OMBase tintValue) throws IOException {
        SMFunction tintTransform = this.getTintTransform();
        OMArray tint = new OMArray();
        tint.add(tintValue);
        return tintTransform.eval(tint);
    }
}

