/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.color;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMStream;
import java.io.IOException;
import java.io.InputStream;

public class SMOutputIntent
implements OMObjectable {
    private OMDictionary dictionary;

    public SMOutputIntent(SMDocument doc, InputStream colorProfile) throws Exception {
        this.dictionary = new OMDictionary();
        this.dictionary.setItem(OMName.TYPE, (OMBase)OMName.OUTPUT_INTENT);
        this.dictionary.setItem(OMName.S, (OMBase)OMName.GTS_PDFA1);
        SMStream destOutputIntent = this.configureOutputProfile(doc, colorProfile);
        this.dictionary.setItem(OMName.DEST_OUTPUT_PROFILE, (OMObjectable)destOutputIntent);
    }

    public SMOutputIntent(OMDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public OMBase getOMObject() {
        return this.dictionary;
    }

    public OMStream getDestOutputIntent() {
        return (OMStream)this.dictionary.getItem(OMName.DEST_OUTPUT_PROFILE);
    }

    public String getInfo() {
        return this.dictionary.getString(OMName.INFO);
    }

    public void setInfo(String value) throws IOException {
        this.dictionary.setString(OMName.INFO, value);
    }

    public String getOutputCondition() {
        return this.dictionary.getString(OMName.OUTPUT_CONDITION);
    }

    public void setOutputCondition(String value) throws IOException {
        this.dictionary.setString(OMName.OUTPUT_CONDITION, value);
    }

    public String getOutputConditionIdentifier() {
        return this.dictionary.getString(OMName.OUTPUT_CONDITION_IDENTIFIER);
    }

    public void setOutputConditionIdentifier(String value) throws IOException {
        this.dictionary.setString(OMName.OUTPUT_CONDITION_IDENTIFIER, value);
    }

    public String getRegistryName() {
        return this.dictionary.getString(OMName.REGISTRY_NAME);
    }

    public void setRegistryName(String value) throws IOException {
        this.dictionary.setString(OMName.REGISTRY_NAME, value);
    }

    private SMStream configureOutputProfile(SMDocument doc, InputStream colorProfile) throws IOException {
        SMStream stream = new SMStream(doc, colorProfile, false);
        stream.getStream().setFilters(OMName.FLATE_DECODE);
        stream.getStream().setInt(OMName.LENGTH, stream.getByteArray().length);
        stream.getStream().setInt(OMName.N, 3);
        stream.addCompression();
        return stream;
    }
}

