/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.color;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.SMRange;
import com.plpdf.smmodel.graphics.color.ColorSpaceLab;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMTristimulus;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.io.IOException;

public class SMLab
extends SMColorSpace {
    public static final String NAME = "Lab";
    private OMArray array;
    private OMDictionary dictionary;

    public SMLab() {
        this.array = new OMArray();
        this.dictionary = new OMDictionary();
        this.array.add(OMName.LAB);
        this.array.add(this.dictionary);
    }

    public SMLab(OMArray lab) {
        this.array = lab;
        this.dictionary = (OMDictionary)this.array.getObject(1);
    }

    public String getName() {
        return NAME;
    }

    public OMBase getOMObject() {
        return this.array;
    }

    protected ColorSpace createColorSpace() throws IOException {
        return new ColorSpaceLab(this.getWhitepoint(), this.getBlackPoint(), this.getARange(), this.getBRange());
    }

    public ColorModel createColorModel(int bpc) throws IOException {
        int[] nBits = new int[]{bpc, bpc, bpc};
        return new ComponentColorModel(this.getJavaColorSpace(), nBits, false, false, 1, 0);
    }

    public int getNumberOfComponents() throws IOException {
        return 3;
    }

    public SMTristimulus getWhitepoint() {
        OMArray wp = (OMArray)this.dictionary.getDictionaryObject(OMName.WHITE_POINT);
        if (wp == null) {
            wp = new OMArray();
            wp.add(new OMFloat(1.0f));
            wp.add(new OMFloat(1.0f));
            wp.add(new OMFloat(1.0f));
            this.dictionary.setItem(OMName.WHITE_POINT, (OMBase)wp);
        }
        return new SMTristimulus(wp);
    }

    public void setWhitepoint(SMTristimulus wp) {
        OMBase wpArray = wp.getOMObject();
        if (wpArray != null) {
            this.dictionary.setItem(OMName.WHITE_POINT, wpArray);
        }
    }

    public SMTristimulus getBlackPoint() {
        OMArray bp = (OMArray)this.dictionary.getDictionaryObject(OMName.BLACK_POINT);
        if (bp == null) {
            bp = new OMArray();
            bp.add(new OMFloat(0.0f));
            bp.add(new OMFloat(0.0f));
            bp.add(new OMFloat(0.0f));
            this.dictionary.setItem(OMName.BLACK_POINT, (OMBase)bp);
        }
        return new SMTristimulus(bp);
    }

    public void setBlackPoint(SMTristimulus bp) {
        OMBase bpArray = null;
        if (bp != null) {
            bpArray = bp.getOMObject();
        }
        this.dictionary.setItem(OMName.BLACK_POINT, bpArray);
    }

    private OMArray getRangeArray() {
        OMArray range = (OMArray)this.dictionary.getDictionaryObject(OMName.RANGE);
        if (range == null) {
            range = new OMArray();
            this.dictionary.setItem(OMName.RANGE, (OMBase)this.array);
            range.add(new OMFloat(-100.0f));
            range.add(new OMFloat(100.0f));
            range.add(new OMFloat(-100.0f));
            range.add(new OMFloat(100.0f));
        }
        return range;
    }

    public SMRange getARange() {
        OMArray range = this.getRangeArray();
        return new SMRange(range, 0);
    }

    public void setARange(SMRange range) {
        OMArray rangeArray = null;
        if (range == null) {
            rangeArray = this.getRangeArray();
            rangeArray.set(0, new OMFloat(-100.0f));
            rangeArray.set(1, new OMFloat(100.0f));
        } else {
            rangeArray = range.getOMArray();
        }
        this.dictionary.setItem(OMName.RANGE, (OMBase)rangeArray);
    }

    public SMRange getBRange() {
        OMArray range = this.getRangeArray();
        return new SMRange(range, 1);
    }

    public void setBRange(SMRange range) {
        OMArray rangeArray = null;
        if (range == null) {
            rangeArray = this.getRangeArray();
            rangeArray.set(2, new OMFloat(-100.0f));
            rangeArray.set(3, new OMFloat(100.0f));
        } else {
            rangeArray = range.getOMArray();
        }
        this.dictionary.setItem(OMName.RANGE, (OMBase)rangeArray);
    }
}

