/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.color;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNull;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMStream;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMColorSpaceFactory;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SMIndexed
extends SMColorSpace {
    public static final String NAME = "Indexed";
    public static final String ABBREVIATED_NAME = "I";
    private OMArray array;
    private SMColorSpace baseColorspace = null;
    private ColorModel baseColorModel = null;
    private byte[] lookupData;
    private byte[] indexedColorValues;
    private int indexNumOfComponents;
    private int maxIndex;
    private static final int INDEXED_BPC = 8;

    public SMIndexed() {
        this.array = new OMArray();
        this.array.add(OMName.INDEXED);
        this.array.add(OMName.DEVICERGB);
        this.array.add(OMInteger.get(255L));
        this.array.add(OMNull.NULL);
    }

    public SMIndexed(OMArray indexedArray) {
        this.array = indexedArray;
    }

    public int getNumberOfComponents() throws IOException {
        return this.getBaseColorSpace().getNumberOfComponents();
    }

    public String getName() {
        return NAME;
    }

    protected ColorSpace createColorSpace() throws IOException {
        return this.getBaseColorSpace().getJavaColorSpace();
    }

    public ColorModel createColorModel(int bpc) throws IOException {
        return this.createColorModel(bpc, -1);
    }

    public ColorModel createColorModel(int bpc, int mask) throws IOException {
        ColorModel colorModel = this.getBaseColorModel(8);
        this.calculateIndexedColorValues(colorModel, bpc);
        if (mask > -1) {
            return new IndexColorModel(bpc, this.maxIndex + 1, this.indexedColorValues, 0, colorModel.hasAlpha(), mask);
        }
        return new IndexColorModel(bpc, this.maxIndex + 1, this.indexedColorValues, 0, colorModel.hasAlpha());
    }

    public SMColorSpace getBaseColorSpace() throws IOException {
        if (this.baseColorspace == null) {
            OMBase base = this.array.getObject(1);
            this.baseColorspace = SMColorSpaceFactory.createColorSpace(base);
        }
        return this.baseColorspace;
    }

    public void setBaseColorSpace(SMColorSpace base) {
        this.array.set(1, base.getOMObject());
        this.baseColorspace = base;
    }

    public int getHighValue() {
        return ((OMNumber)this.array.getObject(2)).intValue();
    }

    public void setHighValue(int high) {
        this.array.set(2, high);
    }

    public int lookupColor(int lookupIndex, int componentNumber) throws IOException {
        SMColorSpace baseColor = this.getBaseColorSpace();
        byte[] data = this.getLookupData();
        int numberOfComponents = baseColor.getNumberOfComponents();
        return (data[lookupIndex * numberOfComponents + componentNumber] + 256) % 256;
    }

    public byte[] getLookupData() throws IOException {
        if (this.lookupData == null) {
            OMBase lookupTable = this.array.getObject(3);
            if (lookupTable instanceof OMString) {
                this.lookupData = ((OMString)lookupTable).getBytes();
            } else if (lookupTable instanceof OMStream) {
                int amountRead;
                OMStream lookupStream = (OMStream)lookupTable;
                InputStream input = lookupStream.getUnfilteredStream();
                ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
                byte[] buffer = new byte[1024];
                while ((amountRead = input.read(buffer, 0, buffer.length)) != -1) {
                    output.write(buffer, 0, amountRead);
                }
                this.lookupData = output.toByteArray();
            } else if (lookupTable == null) {
                this.lookupData = new byte[0];
            } else {
                throw new IOException("Error: Unknown type for lookup table " + lookupTable);
            }
        }
        return this.lookupData;
    }

    public void setLookupColor(int lookupIndex, int componentNumber, int color) throws IOException {
        SMColorSpace baseColor = this.getBaseColorSpace();
        int numberOfComponents = baseColor.getNumberOfComponents();
        byte[] data = this.getLookupData();
        data[lookupIndex * numberOfComponents + componentNumber] = (byte)color;
        OMString string = new OMString(data);
        this.array.set(3, string);
    }

    public float[] calculateColorValues(int index) throws IOException {
        this.calculateIndexedColorValues(this.getBaseColorModel(8), 8);
        float[] colorValues = null;
        if (index < this.maxIndex) {
            int bufferIndex = index * this.indexNumOfComponents;
            colorValues = new float[this.indexNumOfComponents];
            int i = 0;
            while (i < this.indexNumOfComponents) {
                colorValues[i] = this.indexedColorValues[bufferIndex + i];
                ++i;
            }
        }
        return colorValues;
    }

    private ColorModel getBaseColorModel(int bpc) throws IOException {
        if (this.baseColorModel == null) {
            this.baseColorModel = this.getBaseColorSpace().createColorModel(bpc);
            if (this.baseColorModel.getTransferType() != 0) {
                throw new IOException("Not implemented");
            }
        }
        return this.baseColorModel;
    }

    private void calculateIndexedColorValues(ColorModel colorModel, int bpc) throws IOException {
        if (this.indexedColorValues == null) {
            int numberOfColorValues = 1 << bpc;
            int highValue = this.getHighValue();
            this.maxIndex = Math.min(numberOfColorValues - 1, highValue);
            byte[] index = this.getLookupData();
            int numberOfColorValuesFromIndex = index.length / this.baseColorModel.getNumComponents() - 1;
            this.maxIndex = Math.min(this.maxIndex, numberOfColorValuesFromIndex);
            boolean hasAlpha = this.baseColorModel.hasAlpha();
            this.indexNumOfComponents = 3 + (hasAlpha ? 1 : 0);
            int buffersize = (this.maxIndex + 1) * this.indexNumOfComponents;
            this.indexedColorValues = new byte[buffersize];
            byte[] inData = new byte[this.baseColorModel.getNumComponents()];
            int bufferIndex = 0;
            int i = 0;
            while (i <= this.maxIndex) {
                System.arraycopy(index, i * inData.length, inData, 0, inData.length);
                this.indexedColorValues[bufferIndex] = (byte)colorModel.getRed(inData);
                this.indexedColorValues[bufferIndex + 1] = (byte)colorModel.getGreen(inData);
                this.indexedColorValues[bufferIndex + 2] = (byte)colorModel.getBlue(inData);
                if (hasAlpha) {
                    this.indexedColorValues[bufferIndex + 3] = (byte)colorModel.getAlpha(inData);
                }
                bufferIndex += this.indexNumOfComponents;
                ++i;
            }
        }
    }
}

