/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.color;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.SMRange;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMColorSpaceFactory;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class SMICCBased
extends SMColorSpace {
    private static final String CLASS_NAME = SMColorSpace.class.getName();
    public static final String NAME = "ICCBased";
    private SMStream stream;
    private int numberOfComponents = -1;

    public SMICCBased(SMDocument doc) {
        this.array = new OMArray();
        this.array.add(OMName.ICCBASED);
        this.array.add(new SMStream(doc));
    }

    public SMICCBased(OMArray iccArray) {
        this.array = iccArray;
        this.stream = new SMStream((OMStream)iccArray.getObject(1));
    }

    public String getName() {
        return NAME;
    }

    public OMBase getOMObject() {
        return this.array;
    }

    public SMStream getSMStream() {
        return this.stream;
    }

    protected ColorSpace createColorSpace() throws IOException {
        InputStream profile = null;
        ColorSpace cSpace = null;
        try {
            try {
                profile = this.stream.createInputStream();
                ICC_Profile iccProfile = ICC_Profile.getInstance(profile);
                cSpace = new ICC_ColorSpace(iccProfile);
                float[] components = new float[this.numberOfComponents];
                new Color(cSpace, components, 1.0f);
            }
            catch (RuntimeException e) {
                List alternateCSList = this.getAlternateColorSpaces();
                SMColorSpace alternate = (SMColorSpace)alternateCSList.get(0);
                cSpace = alternate.getJavaColorSpace();
                if (profile != null) {
                    profile.close();
                }
            }
        }
        finally {
            if (profile != null) {
                profile.close();
            }
        }
        return cSpace;
    }

    public ColorModel createColorModel(int bpc) throws IOException {
        int[] nbBits;
        int numOfComponents = this.getNumberOfComponents();
        switch (numOfComponents) {
            case 1: {
                nbBits = new int[]{bpc};
                break;
            }
            case 3: {
                nbBits = new int[]{bpc, bpc, bpc};
                break;
            }
            case 4: {
                nbBits = new int[]{bpc, bpc, bpc, bpc};
                break;
            }
            default: {
                throw new IOException("Unknown colorspace number of components:" + numOfComponents);
            }
        }
        ComponentColorModel componentColorModel = new ComponentColorModel(this.getJavaColorSpace(), nbBits, false, false, 1, 0);
        return componentColorModel;
    }

    public int getNumberOfComponents() throws IOException {
        if (this.numberOfComponents < 0) {
            this.numberOfComponents = this.stream.getStream().getInt(OMName.N);
        }
        return this.numberOfComponents;
    }

    public void setNumberOfComponents(int n) {
        this.numberOfComponents = n;
        this.stream.getStream().setInt(OMName.N, n);
    }

    public List getAlternateColorSpaces() throws IOException {
        OMBase alternate = this.stream.getStream().getDictionaryObject(OMName.ALTERNATE);
        OMArray alternateArray = null;
        if (alternate == null) {
            alternateArray = new OMArray();
            int numComponents = this.getNumberOfComponents();
            OMName csName = null;
            if (numComponents == 1) {
                csName = OMName.DEVICEGRAY;
            } else if (numComponents == 3) {
                csName = OMName.DEVICERGB;
            } else if (numComponents == 4) {
                csName = OMName.DEVICECMYK;
            } else {
                throw new IOException("Unknown colorspace number of components:" + numComponents);
            }
            alternateArray.add(csName);
        } else if (alternate instanceof OMArray) {
            alternateArray = (OMArray)alternate;
        } else if (alternate instanceof OMName) {
            alternateArray = new OMArray();
            alternateArray.add(alternate);
        } else {
            throw new IOException("Error: expected OMArray or OMName and not " + alternate.getClass().getName());
        }
        ArrayList<SMColorSpace> retval = new ArrayList<SMColorSpace>();
        int i = 0;
        while (i < alternateArray.size()) {
            retval.add(SMColorSpaceFactory.createColorSpace(alternateArray.get(i)));
            ++i;
        }
        return new OMArrayList(retval, alternateArray);
    }

    public void setAlternateColorSpaces(List list) {
        OMArray altArray = null;
        if (list != null) {
            altArray = OMArrayList.converterToOMArray(list);
        }
        this.stream.getStream().setItem(OMName.ALTERNATE, (OMBase)altArray);
    }

    private OMArray getRangeArray(int n) {
        OMArray rangeArray = (OMArray)this.stream.getStream().getDictionaryObject(OMName.RANGE);
        if (rangeArray == null) {
            rangeArray = new OMArray();
            this.stream.getStream().setItem(OMName.RANGE, (OMBase)rangeArray);
            while (rangeArray.size() < n * 2) {
                rangeArray.add(new OMFloat(-100.0f));
                rangeArray.add(new OMFloat(100.0f));
            }
        }
        return rangeArray;
    }

    public SMRange getRangeForComponent(int n) {
        OMArray rangeArray = this.getRangeArray(n);
        return new SMRange(rangeArray, n);
    }

    public void setRangeForComponent(SMRange range, int n) {
        OMArray rangeArray = this.getRangeArray(n);
        rangeArray.set(n * 2, new OMFloat(range.getMin()));
        rangeArray.set(n * 2 + 1, new OMFloat(range.getMax()));
    }

    public OMStream getMetadata() {
        return (OMStream)this.stream.getStream().getDictionaryObject(OMName.METADATA);
    }

    public void setMetadata(OMStream metadata) {
        this.stream.getStream().setItem(OMName.METADATA, (OMBase)metadata);
    }

    public String toString() {
        String retVal = String.valueOf(super.toString()) + "\n\t Number of Components: ";
        try {
            retVal = String.valueOf(retVal) + this.getNumberOfComponents();
        }
        catch (IOException exception) {
            retVal = String.valueOf(retVal) + exception.toString();
        }
        return retVal;
    }

    public SMICCBased(SMDocument doc, ICC_Profile profile) throws IOException, PlpdfException {
        this.array = new OMArray();
        this.array.add(OMName.getPDFName(NAME));
        ByteArrayInputStream is = new ByteArrayInputStream(profile.getData());
        SMStream s = new SMStream(doc, is, false);
        OMStream dic = s.getStream();
        dic.setItem(OMName.FILTER, (OMBase)OMName.FLATE_DECODE);
        dic.getFilteredStream();
        this.array.add(s);
        int numberOfComponents = profile.getNumComponents();
        switch (numberOfComponents) {
            case 1: {
                dic.setItem(OMName.ALTERNATE, (OMBase)OMName.DEVICEGRAY);
                break;
            }
            case 3: {
                dic.setItem(OMName.ALTERNATE, (OMBase)OMName.DEVICERGB);
                break;
            }
            case 4: {
                dic.setItem(OMName.ALTERNATE, (OMBase)OMName.DEVICECMYK);
                break;
            }
            default: {
                throw new PlpdfException(CLASS_NAME, "ComponentIsNotSupported");
            }
        }
        dic.setInt(OMName.N, numberOfComponents);
    }
}

