/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.color;

import com.plpdf.om.OMArray;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMDeviceGray;
import com.plpdf.smmodel.graphics.pattern.SMPatternResources;
import java.awt.Color;
import java.awt.Paint;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.io.IOException;
import java.util.Arrays;

public class SMColorState
implements Cloneable {
    private static volatile Color iccOverrideColor = Color.getColor("com.plpdf.ICC_override_color");
    private SMColorSpace colorSpace = new SMDeviceGray();
    private OMArray colorSpaceValue = new OMArray();
    private SMPatternResources pattern = null;
    private Color color = null;
    private Paint paint = null;

    public static void setIccOverrideColor(Color color) {
        iccOverrideColor = color;
    }

    public SMColorState() {
        this.setColorSpaceValue(new float[]{0.0f});
    }

    public Object clone() {
        SMColorState retval = new SMColorState();
        retval.colorSpace = this.colorSpace;
        retval.colorSpaceValue.clear();
        retval.colorSpaceValue.addAll(this.colorSpaceValue);
        retval.setPattern(this.getPattern());
        return retval;
    }

    public Color getJavaColor() throws IOException {
        if (this.color == null && this.colorSpaceValue.size() > 0) {
            this.color = this.createColor();
        }
        return this.color;
    }

    public Paint getPaint(int pageHeight) throws IOException {
        if (this.paint == null && this.pattern != null) {
            this.paint = this.pattern.getPaint(pageHeight);
        }
        return this.paint;
    }

    private Color createColor() throws IOException {
        float[] components = this.colorSpaceValue.toFloatArray();
        try {
            String csName = this.colorSpace.getName();
            if ("DeviceRGB".equals(csName) && components.length == 3) {
                return new Color(components[0], components[1], components[2]);
            }
            if ("Lab".equals(csName)) {
                float[] csComponents = this.colorSpace.getJavaColorSpace().toRGB(components);
                return new Color(csComponents[0], csComponents[1], csComponents[2]);
            }
            if (components.length == 1) {
                if ("Separation".equals(csName)) {
                    return new Color((int)components[0]);
                }
                if ("DeviceGray".equals(csName)) {
                    return new Color(components[0], components[0], components[0]);
                }
            }
            Color override = iccOverrideColor;
            ColorSpace cs = this.colorSpace.getJavaColorSpace();
            if (cs instanceof ICC_ColorSpace && override != null) {
                return override;
            }
            return new Color(cs, components, 1.0f);
        }
        catch (Exception e) {
            Color cGuess;
            String sMsg = "Unable to create the color instance " + Arrays.toString(components) + " in color space " + this.colorSpace + "; guessing color ... ";
            try {
                switch (components.length) {
                    case 1: {
                        cGuess = new Color((int)components[0]);
                        sMsg = String.valueOf(sMsg) + "\nInterpretating as single-integer RGB";
                        break;
                    }
                    case 3: {
                        cGuess = new Color(components[0], components[1], components[2]);
                        sMsg = String.valueOf(sMsg) + "\nInterpretating as RGB";
                        break;
                    }
                    case 4: {
                        float k = components[3];
                        float r = components[0] * (1.0f - k) + k;
                        float g = components[1] * (1.0f - k) + k;
                        float b = components[2] * (1.0f - k) + k;
                        r = 1.0f - r;
                        g = 1.0f - g;
                        b = 1.0f - b;
                        cGuess = new Color(r, g, b);
                        sMsg = String.valueOf(sMsg) + "\nInterpretating as CMYK";
                        break;
                    }
                    default: {
                        sMsg = String.valueOf(sMsg) + "\nUnable to guess using " + components.length + " components; using black instead";
                        cGuess = Color.BLACK;
                        break;
                    }
                }
            }
            catch (Exception e2) {
                sMsg = String.valueOf(sMsg) + "\nColor interpolation failed; using black instead\n";
                sMsg = String.valueOf(sMsg) + e2.toString();
                cGuess = Color.BLACK;
            }
            return cGuess;
        }
    }

    public SMColorState(OMArray csValues) {
        this.colorSpaceValue = csValues;
    }

    public SMColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public void setColorSpace(SMColorSpace value) {
        this.colorSpace = value;
        this.color = null;
        this.pattern = null;
    }

    public float[] getColorSpaceValue() {
        return this.colorSpaceValue.toFloatArray();
    }

    public OMArray getOMColorSpaceValue() {
        return this.colorSpaceValue;
    }

    public void setColorSpaceValue(float[] value) {
        this.colorSpaceValue.setFloatArray(value);
        this.color = null;
        this.pattern = null;
    }

    public SMPatternResources getPattern() {
        return this.pattern;
    }

    public void setPattern(SMPatternResources patternValue) {
        this.pattern = patternValue;
        this.color = null;
    }
}

