/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.color;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMName;
import com.plpdf.om.OMObject;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.graphics.color.SMCalGray;
import com.plpdf.smmodel.graphics.color.SMCalRGB;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMDeviceCMYK;
import com.plpdf.smmodel.graphics.color.SMDeviceGray;
import com.plpdf.smmodel.graphics.color.SMDeviceN;
import com.plpdf.smmodel.graphics.color.SMDeviceRGB;
import com.plpdf.smmodel.graphics.color.SMICCBased;
import com.plpdf.smmodel.graphics.color.SMIndexed;
import com.plpdf.smmodel.graphics.color.SMLab;
import com.plpdf.smmodel.graphics.color.SMPattern;
import com.plpdf.smmodel.graphics.color.SMSeparation;
import com.plpdf.smmodel.graphics.pattern.SMPatternResources;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SMColorSpaceFactory {
    private SMColorSpaceFactory() {
    }

    public static SMColorSpace createColorSpace(OMBase colorSpace) throws IOException {
        return SMColorSpaceFactory.createColorSpace(colorSpace, null);
    }

    public static SMColorSpace createColorSpace(OMBase colorSpace, Map<String, SMColorSpace> colorSpaces) throws IOException {
        return SMColorSpaceFactory.createColorSpace(colorSpace, colorSpaces, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SMColorSpace createColorSpace(OMBase colorSpace, Map<String, SMColorSpace> colorSpaces, Map<String, SMPatternResources> patterns) throws IOException {
        SMColorSpace retval = null;
        if (colorSpace instanceof OMObject) {
            return SMColorSpaceFactory.createColorSpace(((OMObject)colorSpace).getObject(), colorSpaces);
        }
        if (colorSpace instanceof OMName) {
            return SMColorSpaceFactory.createColorSpace(((OMName)colorSpace).getName(), colorSpaces);
        }
        if (!(colorSpace instanceof OMArray)) throw new IOException("Unknown colorspace type:" + colorSpace);
        OMArray array = (OMArray)colorSpace;
        String name = ((OMName)array.getObject(0)).getName();
        if (name.equals("CalGray")) {
            return new SMCalGray(array);
        }
        if (name.equals("DeviceRGB")) {
            return SMDeviceRGB.INSTANCE;
        }
        if (name.equals("DeviceGray")) {
            return new SMDeviceGray();
        }
        if (name.equals("DeviceCMYK")) {
            return SMDeviceCMYK.INSTANCE;
        }
        if (name.equals("CalRGB")) {
            return new SMCalRGB(array);
        }
        if (name.equals("DeviceN")) {
            return new SMDeviceN(array);
        }
        if (name.equals("Indexed")) return new SMIndexed(array);
        if (name.equals("I")) {
            return new SMIndexed(array);
        }
        if (name.equals("Lab")) {
            return new SMLab(array);
        }
        if (name.equals("Separation")) {
            return new SMSeparation(array);
        }
        if (name.equals("ICCBased")) {
            return new SMICCBased(array);
        }
        if (!name.equals("Pattern")) throw new IOException("Unknown colorspace array type:" + name);
        return new SMPattern(array);
    }

    public static SMColorSpace createColorSpace(String colorSpaceName) throws IOException {
        return SMColorSpaceFactory.createColorSpace(colorSpaceName, null);
    }

    public static SMColorSpace createColorSpace(String colorSpaceName, Map<String, SMColorSpace> colorSpaces) throws IOException {
        SMColorSpace cs = null;
        if (colorSpaceName.equals("DeviceCMYK") || colorSpaceName.equals("CMYK")) {
            cs = SMDeviceCMYK.INSTANCE;
        } else if (colorSpaceName.equals("DeviceRGB") || colorSpaceName.equals("RGB")) {
            cs = SMDeviceRGB.INSTANCE;
        } else if (colorSpaceName.equals("DeviceGray") || colorSpaceName.equals("G")) {
            cs = new SMDeviceGray();
        } else if (colorSpaces != null && colorSpaces.get(colorSpaceName) != null) {
            cs = colorSpaces.get(colorSpaceName);
        } else if (colorSpaceName.equals("Lab")) {
            cs = new SMLab();
        } else if (colorSpaceName.equals("Pattern")) {
            cs = new SMPattern();
        } else {
            throw new IOException("Error: Unknown colorspace '" + colorSpaceName + "'");
        }
        return cs;
    }

    public static SMColorSpace createColorSpace(SMDocument doc, ColorSpace cs) throws IOException {
        SMColorSpace retval = null;
        if (cs.isCS_sRGB()) {
            retval = SMDeviceRGB.INSTANCE;
        } else if (cs instanceof ICC_ColorSpace) {
            ICC_ColorSpace ics = (ICC_ColorSpace)cs;
            SMICCBased pdCS = new SMICCBased(doc);
            retval = pdCS;
            OMArray ranges = new OMArray();
            int i = 0;
            while (i < cs.getNumComponents()) {
                ranges.add(new OMFloat(ics.getMinValue(i)));
                ranges.add(new OMFloat(ics.getMaxValue(i)));
                ++i;
            }
            SMStream iccData = pdCS.getSMStream();
            OutputStream output = null;
            try {
                output = iccData.createOutputStream();
                output.write(ics.getProfile().getData());
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
            pdCS.setNumberOfComponents(cs.getNumComponents());
        } else {
            throw new IOException("Not yet implemented:" + cs);
        }
        return retval;
    }
}

