/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.color;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.SMMatrix;
import com.plpdf.smmodel.graphics.color.ColorSpaceCalRGB;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMGamma;
import com.plpdf.smmodel.graphics.color.SMTristimulus;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.io.IOException;

public class SMCalRGB
extends SMColorSpace {
    public static final String NAME = "CalRGB";
    private OMArray array;
    private OMDictionary dictionary;

    public SMCalRGB() {
        this.array = new OMArray();
        this.dictionary = new OMDictionary();
        this.array.add(OMName.CALRGB);
        this.array.add(this.dictionary);
    }

    public SMCalRGB(OMArray rgb) {
        this.array = rgb;
        this.dictionary = (OMDictionary)this.array.getObject(1);
    }

    public int getNumberOfComponents() throws IOException {
        return 3;
    }

    public String getName() {
        return NAME;
    }

    protected ColorSpace createColorSpace() {
        return new ColorSpaceCalRGB(this.getGamma(), this.getWhitepoint(), this.getBlackPoint(), this.getLinearInterpretation());
    }

    public ColorModel createColorModel(int bpc) throws IOException {
        int[] nBits = new int[]{bpc, bpc, bpc};
        return new ComponentColorModel(this.getJavaColorSpace(), nBits, false, false, 1, 0);
    }

    public OMBase getOMObject() {
        return this.array;
    }

    public SMTristimulus getWhitepoint() {
        OMArray wp = (OMArray)this.dictionary.getDictionaryObject(OMName.WHITE_POINT);
        if (wp == null) {
            wp = new OMArray();
            wp.add(new OMFloat(1.0f));
            wp.add(new OMFloat(1.0f));
            wp.add(new OMFloat(1.0f));
            this.dictionary.setItem(OMName.WHITE_POINT, (OMBase)wp);
        }
        return new SMTristimulus(wp);
    }

    public void setWhitepoint(SMTristimulus wp) {
        OMBase wpArray = wp.getOMObject();
        if (wpArray != null) {
            this.dictionary.setItem(OMName.WHITE_POINT, wpArray);
        }
    }

    public SMTristimulus getBlackPoint() {
        OMArray bp = (OMArray)this.dictionary.getDictionaryObject(OMName.BLACK_POINT);
        if (bp == null) {
            bp = new OMArray();
            bp.add(new OMFloat(0.0f));
            bp.add(new OMFloat(0.0f));
            bp.add(new OMFloat(0.0f));
            this.dictionary.setItem(OMName.BLACK_POINT, (OMBase)bp);
        }
        return new SMTristimulus(bp);
    }

    public void setBlackPoint(SMTristimulus bp) {
        OMBase bpArray = null;
        if (bp != null) {
            bpArray = bp.getOMObject();
        }
        this.dictionary.setItem(OMName.BLACK_POINT, bpArray);
    }

    public SMGamma getGamma() {
        OMArray gamma = (OMArray)this.dictionary.getDictionaryObject(OMName.GAMMA);
        if (gamma == null) {
            gamma = new OMArray();
            gamma.add(new OMFloat(1.0f));
            gamma.add(new OMFloat(1.0f));
            gamma.add(new OMFloat(1.0f));
            this.dictionary.setItem(OMName.GAMMA, (OMBase)gamma);
        }
        return new SMGamma(gamma);
    }

    public void setGamma(SMGamma value) {
        OMArray gamma = null;
        if (value != null) {
            gamma = value.getOMArray();
        }
        this.dictionary.setItem(OMName.GAMMA, (OMBase)gamma);
    }

    public SMMatrix getLinearInterpretation() {
        SMMatrix retval = null;
        OMArray matrix = (OMArray)this.dictionary.getDictionaryObject(OMName.MATRIX);
        if (matrix == null) {
            retval = new SMMatrix();
            this.setLinearInterpretation(retval);
        } else {
            retval = new SMMatrix(matrix);
        }
        return retval;
    }

    public void setLinearInterpretation(SMMatrix matrix) {
        OMArray matrixArray = null;
        if (matrix != null) {
            matrixArray = matrix.getOMArray();
        }
        this.dictionary.setItem(OMName.MATRIX, (OMBase)matrixArray);
    }
}

