/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.color;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMTristimulus;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.io.IOException;

public class SMCalGray
extends SMColorSpace {
    public static final String NAME = "CalGray";
    private OMArray array;
    private OMDictionary dictionary;

    public SMCalGray() {
        this.array = new OMArray();
        this.dictionary = new OMDictionary();
        this.array.add(OMName.CALGRAY);
        this.array.add(this.dictionary);
    }

    public SMCalGray(OMArray gray) {
        this.array = gray;
        this.dictionary = (OMDictionary)this.array.getObject(1);
    }

    public int getNumberOfComponents() throws IOException {
        return 1;
    }

    public String getName() {
        return NAME;
    }

    protected ColorSpace createColorSpace() throws IOException {
        throw new IOException("Not implemented");
    }

    public ColorModel createColorModel(int bpc) throws IOException {
        throw new IOException("Not implemented");
    }

    public OMBase getOMObject() {
        return this.array;
    }

    public float getGamma() {
        float retval = 1.0f;
        OMNumber gamma = (OMNumber)this.dictionary.getDictionaryObject(OMName.GAMMA);
        if (gamma != null) {
            retval = gamma.floatValue();
        }
        return retval;
    }

    public void setGamma(float value) {
        this.dictionary.setItem(OMName.GAMMA, (OMBase)new OMFloat(value));
    }

    public SMTristimulus getWhitepoint() {
        OMArray wp = (OMArray)this.dictionary.getDictionaryObject(OMName.WHITE_POINT);
        if (wp == null) {
            wp = new OMArray();
            wp.add(new OMFloat(1.0f));
            wp.add(new OMFloat(1.0f));
            wp.add(new OMFloat(1.0f));
            this.dictionary.setItem(OMName.WHITE_POINT, (OMBase)wp);
        }
        return new SMTristimulus(wp);
    }

    public void setWhitepoint(SMTristimulus wp) {
        OMBase wpArray = wp.getOMObject();
        if (wpArray != null) {
            this.dictionary.setItem(OMName.WHITE_POINT, wpArray);
        }
    }

    public SMTristimulus getBlackPoint() {
        OMArray bp = (OMArray)this.dictionary.getDictionaryObject(OMName.BLACK_POINT);
        if (bp == null) {
            bp = new OMArray();
            bp.add(new OMFloat(0.0f));
            bp.add(new OMFloat(0.0f));
            bp.add(new OMFloat(0.0f));
            this.dictionary.setItem(OMName.BLACK_POINT, (OMBase)bp);
        }
        return new SMTristimulus(bp);
    }

    public void setBlackPoint(SMTristimulus bp) {
        OMBase bpArray = null;
        if (bp != null) {
            bpArray = bp.getOMObject();
        }
        this.dictionary.setItem(OMName.BLACK_POINT, bpArray);
    }
}

