/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics.color;

import com.plpdf.smmodel.common.SMMatrix;
import com.plpdf.smmodel.graphics.color.SMGamma;
import com.plpdf.smmodel.graphics.color.SMTristimulus;
import java.awt.color.ColorSpace;

public class ColorSpaceCalRGB
extends ColorSpace {
    private SMGamma gamma = null;
    private SMTristimulus whitepoint = null;
    private SMTristimulus blackpoint = null;
    private SMMatrix matrix = null;
    private static final long serialVersionUID = -6362864473145799405L;

    public ColorSpaceCalRGB() {
        super(13, 3);
    }

    public ColorSpaceCalRGB(SMGamma gammaValue, SMTristimulus whitept, SMTristimulus blackpt, SMMatrix linearMatrix) {
        this();
        this.gamma = gammaValue;
        this.whitepoint = whitept;
        this.blackpoint = blackpt;
        this.matrix = linearMatrix;
    }

    private float[] fromRGBtoCIEXYZ(float[] rgbvalue) {
        ColorSpace colorspaceRGB = ColorSpace.getInstance(1000);
        return colorspaceRGB.toCIEXYZ(rgbvalue);
    }

    private float[] fromCIEXYZtoRGB(float[] xyzvalue) {
        ColorSpace colorspaceXYZ = ColorSpace.getInstance(1001);
        return colorspaceXYZ.toRGB(xyzvalue);
    }

    public float[] fromCIEXYZ(float[] colorvalue) {
        if (colorvalue != null && colorvalue.length == 3) {
            return this.fromCIEXYZtoRGB(colorvalue);
        }
        return null;
    }

    public float[] fromRGB(float[] rgbvalue) {
        if (rgbvalue != null && rgbvalue.length == 3) {
            return rgbvalue;
        }
        return null;
    }

    public float[] toCIEXYZ(float[] colorvalue) {
        if (colorvalue != null && colorvalue.length == 4) {
            return this.fromRGBtoCIEXYZ(this.toRGB(colorvalue));
        }
        return null;
    }

    public float[] toRGB(float[] colorvalue) {
        if (colorvalue != null && colorvalue.length == 3) {
            return colorvalue;
        }
        return null;
    }
}

