/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMBoolean;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.function.SMFunction;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMColorSpaceFactory;
import java.io.IOException;

public class SMShading
implements OMObjectable {
    private OMDictionary DictShading;
    private OMName shadingname;
    private OMArray domain = null;
    private OMArray extend = null;
    private SMFunction function = null;
    private SMColorSpace colorspace = null;
    public static final String NAME = "Shading";

    public SMShading() {
        this.DictShading = new OMDictionary();
    }

    public SMShading(OMName name, OMDictionary shading) {
        this.DictShading = shading;
        this.shadingname = name;
    }

    public String getName() {
        return NAME;
    }

    public OMBase getOMObject() {
        return OMName.SHADING;
    }

    public OMName getShadingName() {
        return this.shadingname;
    }

    public int getShadingType() {
        return this.DictShading.getInt(OMName.SHADING_TYPE);
    }

    public SMColorSpace getColorSpace() throws IOException {
        if (this.colorspace == null) {
            this.colorspace = SMColorSpaceFactory.createColorSpace(this.DictShading.getDictionaryObject(OMName.COLORSPACE));
        }
        return this.colorspace;
    }

    public boolean getAntiAlias() {
        return this.DictShading.getBoolean(OMName.ANTI_ALIAS, false);
    }

    public OMArray getCoords() {
        return (OMArray)this.DictShading.getDictionaryObject(OMName.COORDS);
    }

    public SMFunction getFunction() throws IOException {
        if (this.function == null) {
            this.function = SMFunction.create(this.DictShading.getDictionaryObject(OMName.FUNCTION));
        }
        return this.function;
    }

    public OMArray getDomain() {
        if (this.domain == null) {
            this.domain = (OMArray)this.DictShading.getDictionaryObject(OMName.DOMAIN);
            if (this.domain == null) {
                this.domain = new OMArray();
                this.domain.add(new OMFloat(0.0f));
                this.domain.add(new OMFloat(1.0f));
            }
        }
        return this.domain;
    }

    public OMArray getExtend() {
        if (this.extend == null) {
            this.extend = (OMArray)this.DictShading.getDictionaryObject(OMName.EXTEND);
            if (this.extend == null) {
                this.extend = new OMArray();
                this.extend.add(OMBoolean.FALSE);
                this.extend.add(OMBoolean.FALSE);
            }
        }
        return this.extend;
    }

    public String toString() {
        String sFunction;
        String sColorSpace;
        try {
            sColorSpace = this.getColorSpace().toString();
        }
        catch (IOException e) {
            sColorSpace = "Failure retrieving ColorSpace: " + e.toString();
        }
        try {
            sFunction = this.getFunction().toString();
        }
        catch (IOException e) {
            sFunction = "n/a";
        }
        String s = "Shading " + this.shadingname + "\n" + "\tShadingType: " + this.getShadingType() + "\n" + "\tColorSpace: " + sColorSpace + "\n" + "\tAntiAlias: " + this.getAntiAlias() + "\n" + "\tCoords: " + (this.getCoords() != null ? this.getCoords().toString() : "") + "\n" + "\tDomain: " + this.getDomain().toString() + "\n" + "\tFunction: " + sFunction + "\n" + "\tExtend: " + this.getExtend().toString() + "\n" + "\tRaw Value:\n" + this.DictShading.toString();
        return s;
    }
}

