/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMNumber;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMObjectable;
import java.util.List;

public class SMLineDashPattern
implements OMObjectable,
Cloneable {
    private OMArray lineDashPattern = null;

    public SMLineDashPattern() {
        this.lineDashPattern = new OMArray();
        this.lineDashPattern.add(new OMArray());
        this.lineDashPattern.add(OMInteger.ZERO);
    }

    public SMLineDashPattern(OMArray ldp) {
        this.lineDashPattern = ldp;
    }

    public SMLineDashPattern(OMArray ldp, int phase) {
        this.lineDashPattern = new OMArray();
        this.lineDashPattern.add(ldp);
        this.lineDashPattern.add(OMInteger.get(phase));
    }

    public Object clone() {
        SMLineDashPattern pattern = null;
        try {
            pattern = (SMLineDashPattern)super.clone();
            pattern.setDashPattern(this.getDashPattern());
            pattern.setPhaseStart(this.getPhaseStart());
        }
        catch (CloneNotSupportedException exception) {
            exception.printStackTrace();
        }
        return pattern;
    }

    public OMBase getOMObject() {
        return this.lineDashPattern;
    }

    public int getPhaseStart() {
        OMNumber phase = (OMNumber)this.lineDashPattern.get(1);
        return phase.intValue();
    }

    public void setPhaseStart(int phase) {
        this.lineDashPattern.set(1, phase);
    }

    public List getDashPattern() {
        OMArray dashPatterns = (OMArray)this.lineDashPattern.get(0);
        return OMArrayList.convertIntegerOMArrayToList(dashPatterns);
    }

    public OMArray getOMDashPattern() {
        return (OMArray)this.lineDashPattern.get(0);
    }

    public void setDashPattern(List dashPattern) {
        this.lineDashPattern.set(0, OMArrayList.converterToOMArray(dashPattern));
    }

    public boolean isDashPatternEmpty() {
        float[] dashPattern = this.getOMDashPattern().toFloatArray();
        boolean dashPatternEmpty = true;
        if (dashPattern != null) {
            int arraySize = dashPattern.length;
            int i = 0;
            while (i < arraySize) {
                if (dashPattern[i] > 0.0f) {
                    dashPatternEmpty = false;
                    break;
                }
                ++i;
            }
        }
        return dashPatternEmpty;
    }
}

