/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics;

import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.graphics.SMLineDashPattern;
import com.plpdf.smmodel.graphics.color.SMColorState;
import com.plpdf.smmodel.text.SMTextState;
import com.plpdf.util.Matrix;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class SMGraphicsState
implements Cloneable {
    private Matrix currentTransformationMatrix = new Matrix();
    private SMColorState strokingColor = new SMColorState();
    private SMColorState nonStrokingColor = new SMColorState();
    private SMTextState textState = new SMTextState();
    private double lineWidth = 0.0;
    private int lineCap = 0;
    private int lineJoin = 0;
    private double miterLimit = 0.0;
    private SMLineDashPattern lineDashPattern;
    private String renderingIntent;
    private boolean strokeAdjustment = false;
    private double alphaConstants = 1.0;
    private double nonStrokingAlphaConstants = 1.0;
    private boolean alphaSource = false;
    private boolean overprint = false;
    private double overprintMode = 0.0;
    private double flatness = 1.0;
    private double smoothness = 0.0;
    private GeneralPath currentClippingPath;

    public SMGraphicsState() {
    }

    public SMGraphicsState(SMRectangle page) {
        this.currentClippingPath = new GeneralPath(new Rectangle(page.createDimension()));
        if (page.getLowerLeftX() != 0.0f || page.getLowerLeftY() != 0.0f) {
            this.currentTransformationMatrix = this.currentTransformationMatrix.multiply(Matrix.getTranslatingInstance(-page.getLowerLeftX(), -page.getLowerLeftY()));
        }
    }

    public Matrix getCurrentTransformationMatrix() {
        return this.currentTransformationMatrix;
    }

    public void setCurrentTransformationMatrix(Matrix value) {
        this.currentTransformationMatrix = value;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double value) {
        this.lineWidth = value;
    }

    public int getLineCap() {
        return this.lineCap;
    }

    public void setLineCap(int value) {
        this.lineCap = value;
    }

    public int getLineJoin() {
        return this.lineJoin;
    }

    public void setLineJoin(int value) {
        this.lineJoin = value;
    }

    public double getMiterLimit() {
        return this.miterLimit;
    }

    public void setMiterLimit(double value) {
        this.miterLimit = value;
    }

    public boolean isStrokeAdjustment() {
        return this.strokeAdjustment;
    }

    public void setStrokeAdjustment(boolean value) {
        this.strokeAdjustment = value;
    }

    public double getAlphaConstants() {
        return this.alphaConstants;
    }

    public void setAlphaConstants(double value) {
        this.alphaConstants = value;
    }

    public double getNonStrokeAlphaConstants() {
        return this.nonStrokingAlphaConstants;
    }

    public void setNonStrokeAlphaConstants(double value) {
        this.nonStrokingAlphaConstants = value;
    }

    public boolean isAlphaSource() {
        return this.alphaSource;
    }

    public void setAlphaSource(boolean value) {
        this.alphaSource = value;
    }

    public boolean isOverprint() {
        return this.overprint;
    }

    public void setOverprint(boolean value) {
        this.overprint = value;
    }

    public double getOverprintMode() {
        return this.overprintMode;
    }

    public void setOverprintMode(double value) {
        this.overprintMode = value;
    }

    public double getFlatness() {
        return this.flatness;
    }

    public void setFlatness(double value) {
        this.flatness = value;
    }

    public double getSmoothness() {
        return this.smoothness;
    }

    public void setSmoothness(double value) {
        this.smoothness = value;
    }

    public SMTextState getTextState() {
        return this.textState;
    }

    public void setTextState(SMTextState value) {
        this.textState = value;
    }

    public SMLineDashPattern getLineDashPattern() {
        return this.lineDashPattern;
    }

    public void setLineDashPattern(SMLineDashPattern value) {
        this.lineDashPattern = value;
    }

    public String getRenderingIntent() {
        return this.renderingIntent;
    }

    public void setRenderingIntent(String value) {
        this.renderingIntent = value;
    }

    public Object clone() {
        SMGraphicsState clone = null;
        try {
            clone = (SMGraphicsState)super.clone();
            clone.setTextState((SMTextState)this.textState.clone());
            clone.setCurrentTransformationMatrix(this.currentTransformationMatrix.copy());
            clone.strokingColor = (SMColorState)this.strokingColor.clone();
            clone.nonStrokingColor = (SMColorState)this.nonStrokingColor.clone();
            if (this.lineDashPattern != null) {
                clone.setLineDashPattern((SMLineDashPattern)this.lineDashPattern.clone());
            }
            if (this.currentClippingPath != null) {
                clone.setCurrentClippingPath((GeneralPath)this.currentClippingPath.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    public SMColorState getStrokingColor() {
        return this.strokingColor;
    }

    public SMColorState getNonStrokingColor() {
        return this.nonStrokingColor;
    }

    public void setCurrentClippingPath(Shape pCurrentClippingPath) {
        if (pCurrentClippingPath != null) {
            if (pCurrentClippingPath instanceof GeneralPath) {
                this.currentClippingPath = (GeneralPath)pCurrentClippingPath;
            } else {
                this.currentClippingPath = new GeneralPath();
                this.currentClippingPath.append(pCurrentClippingPath, false);
            }
        } else {
            this.currentClippingPath = null;
        }
    }

    public Shape getCurrentClippingPath() {
        return this.currentClippingPath;
    }

    public Composite getStrokeJavaComposite() {
        return AlphaComposite.getInstance(3, (float)this.alphaConstants);
    }

    public Composite getNonStrokeJavaComposite() {
        return AlphaComposite.getInstance(3, (float)this.nonStrokingAlphaConstants);
    }
}

