/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.graphics;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.graphics.SMFontSetting;
import com.plpdf.smmodel.graphics.SMGraphicsState;
import com.plpdf.smmodel.graphics.SMLineDashPattern;
import java.io.IOException;

public class SMExtendedGraphicsState
implements OMObjectable {
    public static final String RENDERING_INTENT_ABSOLUTE_COLORIMETRIC = "AbsoluteColorimetric";
    public static final String RENDERING_INTENT_RELATIVE_COLORIMETRIC = "RelativeColorimetric";
    public static final String RENDERING_INTENT_SATURATION = "Saturation";
    public static final String RENDERING_INTENT_PERCEPTUAL = "Perceptual";
    private OMDictionary graphicsState;

    public SMExtendedGraphicsState() {
        this.graphicsState = new OMDictionary();
        this.graphicsState.setItem(OMName.TYPE, (OMBase)OMName.EXT_G_STATE);
    }

    public SMExtendedGraphicsState(OMDictionary dictionary) {
        this.graphicsState = dictionary;
    }

    public void copyIntoGraphicsState(SMGraphicsState gs) throws IOException {
        for (OMName key : this.graphicsState.keySet()) {
            if (key.equals(OMName.LW)) {
                gs.setLineWidth(this.getLineWidth().doubleValue());
                continue;
            }
            if (key.equals(OMName.LC)) {
                gs.setLineCap(this.getLineCapStyle());
                continue;
            }
            if (key.equals(OMName.LJ)) {
                gs.setLineJoin(this.getLineJoinStyle());
                continue;
            }
            if (key.equals(OMName.ML)) {
                gs.setMiterLimit(this.getMiterLimit().doubleValue());
                continue;
            }
            if (key.equals(OMName.D)) {
                gs.setLineDashPattern(this.getLineDashPattern());
                continue;
            }
            if (key.equals(OMName.RI)) {
                gs.setRenderingIntent(this.getRenderingIntent());
                continue;
            }
            if (key.equals(OMName.OPM)) {
                gs.setOverprintMode(this.getOverprintMode().doubleValue());
                continue;
            }
            if (key.equals(OMName.FONT)) {
                SMFontSetting setting = this.getFontSetting();
                gs.getTextState().setFont(setting.getFont());
                gs.getTextState().setFontSize(setting.getFontSize());
                continue;
            }
            if (key.equals(OMName.FL)) {
                gs.setFlatness(this.getFlatnessTolerance().floatValue());
                continue;
            }
            if (key.equals(OMName.SM)) {
                gs.setSmoothness(this.getSmoothnessTolerance().floatValue());
                continue;
            }
            if (key.equals(OMName.SA)) {
                gs.setStrokeAdjustment(this.getAutomaticStrokeAdjustment());
                continue;
            }
            if (key.equals(OMName.CA)) {
                gs.setAlphaConstants(this.getStrokingAlpaConstant().floatValue());
                continue;
            }
            if (key.equals(OMName.CA_NS)) {
                gs.setNonStrokeAlphaConstants(this.getNonStrokingAlpaConstant().floatValue());
                continue;
            }
            if (key.equals(OMName.AIS)) {
                gs.setAlphaSource(this.getAlphaSourceFlag());
                continue;
            }
            if (!key.equals(OMName.TK)) continue;
            gs.getTextState().setKnockoutFlag(this.getTextKnockoutFlag());
        }
    }

    public OMDictionary getOMDictionary() {
        return this.graphicsState;
    }

    public OMBase getOMObject() {
        return this.graphicsState;
    }

    public Float getLineWidth() {
        return this.getFloatItem(OMName.LW);
    }

    public void setLineWidth(Float width) {
        this.setFloatItem(OMName.LW, width);
    }

    public int getLineCapStyle() {
        return this.graphicsState.getInt(OMName.LC);
    }

    public void setLineCapStyle(int style) {
        this.graphicsState.setInt(OMName.LC, style);
    }

    public int getLineJoinStyle() {
        return this.graphicsState.getInt(OMName.LJ);
    }

    public void setLineJoinStyle(int style) {
        this.graphicsState.setInt(OMName.LJ, style);
    }

    public Float getMiterLimit() {
        return this.getFloatItem(OMName.ML);
    }

    public void setMiterLimit(Float miterLimit) {
        this.setFloatItem(OMName.ML, miterLimit);
    }

    public SMLineDashPattern getLineDashPattern() {
        SMLineDashPattern retval = null;
        OMArray dp = (OMArray)this.graphicsState.getDictionaryObject(OMName.D);
        if (dp != null) {
            retval = new SMLineDashPattern(dp);
        }
        return retval;
    }

    public void setLineDashPattern(SMLineDashPattern dashPattern) {
        this.graphicsState.setItem(OMName.D, dashPattern.getOMObject());
    }

    public String getRenderingIntent() {
        return this.graphicsState.getNameAsString("RI");
    }

    public void setRenderingIntent(String ri) {
        this.graphicsState.setName("RI", ri);
    }

    public boolean getStrokingOverprintControl() {
        return this.graphicsState.getBoolean(OMName.OP, false);
    }

    public void setStrokingOverprintControl(boolean op) {
        this.graphicsState.setBoolean(OMName.OP, op);
    }

    public boolean getNonStrokingOverprintControl() {
        return this.graphicsState.getBoolean(OMName.OP_NS, this.getStrokingOverprintControl());
    }

    public void setNonStrokingOverprintControl(boolean op) {
        this.graphicsState.setBoolean(OMName.OP_NS, op);
    }

    public Float getOverprintMode() {
        return this.getFloatItem(OMName.OPM);
    }

    public void setOverprintMode(Float overprintMode) {
        this.setFloatItem(OMName.OPM, overprintMode);
    }

    public SMFontSetting getFontSetting() {
        SMFontSetting setting = null;
        OMArray font = (OMArray)this.graphicsState.getDictionaryObject(OMName.FONT);
        if (font != null) {
            setting = new SMFontSetting(font);
        }
        return setting;
    }

    public void setFontSetting(SMFontSetting fs) {
        this.graphicsState.setItem(OMName.FONT, (OMObjectable)fs);
    }

    public Float getFlatnessTolerance() {
        return this.getFloatItem(OMName.FL);
    }

    public void setFlatnessTolerance(Float flatness) {
        this.setFloatItem(OMName.FL, flatness);
    }

    public Float getSmoothnessTolerance() {
        return this.getFloatItem(OMName.SM);
    }

    public void setSmoothnessTolerance(Float smoothness) {
        this.setFloatItem(OMName.SM, smoothness);
    }

    public boolean getAutomaticStrokeAdjustment() {
        return this.graphicsState.getBoolean(OMName.SA, false);
    }

    public void setAutomaticStrokeAdjustment(boolean sa) {
        this.graphicsState.setBoolean(OMName.SA, sa);
    }

    public Float getStrokingAlpaConstant() {
        return this.getFloatItem(OMName.CA);
    }

    public void setStrokingAlphaConstant(Float alpha) {
        this.setFloatItem(OMName.CA, alpha);
    }

    public Float getNonStrokingAlpaConstant() {
        return this.getFloatItem(OMName.CA_NS);
    }

    public void setNonStrokingAlphaConstant(Float alpha) {
        this.setFloatItem(OMName.CA_NS, alpha);
    }

    public boolean getAlphaSourceFlag() {
        return this.graphicsState.getBoolean(OMName.AIS, false);
    }

    public void setAlphaSourceFlag(boolean alpha) {
        this.graphicsState.setBoolean(OMName.AIS, alpha);
    }

    public boolean getTextKnockoutFlag() {
        return this.graphicsState.getBoolean(OMName.TK, true);
    }

    public void setTextKnockoutFlag(boolean tk) {
        this.graphicsState.setBoolean(OMName.TK, tk);
    }

    private Float getFloatItem(OMName key) {
        Float retval = null;
        OMNumber value = (OMNumber)this.graphicsState.getDictionaryObject(key);
        if (value != null) {
            retval = new Float(value.floatValue());
        }
        return retval;
    }

    private void setFloatItem(OMName key, Float value) {
        if (value == null) {
            this.graphicsState.removeItem(key);
        } else {
            this.graphicsState.setItem(key, (OMBase)new OMFloat(value.floatValue()));
        }
    }

    public void setNonStrokingAlphaConstant(float alpha) {
        this.setFloatItem(OMName.CA_NS, Float.valueOf(alpha));
    }

    public boolean equals(Object o) {
        float newalpha;
        SMExtendedGraphicsState o1 = (SMExtendedGraphicsState)o;
        OMDictionary origdict = this.getOMDictionary();
        OMDictionary newdict = o1.getOMDictionary();
        float origalpha = origdict.getFloat(OMName.CA_NS);
        return (double)Math.abs(origalpha - (newalpha = newdict.getFloat(OMName.CA_NS))) < 1.0E-8;
    }
}

