/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.font;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMMatrix;
import com.plpdf.smmodel.font.SMSimpleFont;
import com.plpdf.smmodel.font.Type3StreamParser;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;

public class SMType3Font
extends SMSimpleFont {
    private Map<Character, Image> images = new HashMap<Character, Image>();

    public SMType3Font() {
        this.font.setItem(OMName.SUBTYPE, (OMBase)OMName.TYPE3);
    }

    public SMType3Font(OMDictionary fontDictionary) {
        super(fontDictionary);
    }

    private Image createImageIfNecessary(char character) throws Exception {
        OMDictionary charProcs;
        OMStream stream;
        Character c = new Character(character);
        Image retval = this.images.get(c);
        if (retval == null && (stream = (OMStream)(charProcs = (OMDictionary)this.font.getDictionaryObject(OMName.CHAR_PROCS)).getDictionaryObject(OMName.getPDFName("" + character))) != null) {
            Type3StreamParser parser = new Type3StreamParser();
            retval = parser.createImage(stream);
            this.images.put(c, retval);
        }
        return retval;
    }

    public void drawString(String string, int[] codePoints, Graphics g, float fontSize, AffineTransform at, float x, float y) throws Exception {
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            Image image = this.createImageIfNecessary(c);
            if (image != null) {
                int newWidth = (int)(0.12 * (double)image.getWidth(null));
                int newHeight = (int)(0.12 * (double)image.getHeight(null));
                if (newWidth > 0 && newHeight > 0) {
                    image = image.getScaledInstance(newWidth, newHeight, 4);
                    g.drawImage(image, (int)x, (int)y, null);
                    x += (float)newWidth;
                }
            }
            ++i;
        }
    }

    public void setFontMatrix(SMMatrix matrix) {
        this.font.setItem(OMName.FONT_MATRIX, (OMObjectable)matrix);
    }
}

