/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.font;

import com.plpdf.encoding.AFMEncoding;
import com.plpdf.encoding.Encoding;
import com.plpdf.encoding.EncodingManager;
import com.plpdf.encoding.Type1Encoding;
import com.plpdf.encoding.WinAnsiEncoding;
import com.plpdf.font.afm.FontMetric;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.SMMatrix;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.font.FontManager;
import com.plpdf.smmodel.font.SMFontDescriptor;
import com.plpdf.smmodel.font.SMFontDescriptorDictionary;
import com.plpdf.smmodel.font.SMSimpleFont;
import com.plpdf.smmodel.font.SMType1CFont;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.GlyphVector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class SMType1Font
extends SMSimpleFont {
    private SMType1CFont type1CFont = null;
    public static final SMType1Font TIMES_ROMAN = new SMType1Font("Times-Roman");
    public static final SMType1Font TIMES_BOLD = new SMType1Font("Times-Bold");
    public static final SMType1Font TIMES_ITALIC = new SMType1Font("Times-Italic");
    public static final SMType1Font TIMES_BOLD_ITALIC = new SMType1Font("Times-BoldItalic");
    public static final SMType1Font HELVETICA = new SMType1Font("Helvetica");
    public static final SMType1Font HELVETICA_BOLD = new SMType1Font("Helvetica-Bold");
    public static final SMType1Font HELVETICA_OBLIQUE = new SMType1Font("Helvetica-Oblique");
    public static final SMType1Font HELVETICA_BOLD_OBLIQUE = new SMType1Font("Helvetica-BoldOblique");
    public static final SMType1Font COURIER = new SMType1Font("Courier");
    public static final SMType1Font COURIER_BOLD = new SMType1Font("Courier-Bold");
    public static final SMType1Font COURIER_OBLIQUE = new SMType1Font("Courier-Oblique");
    public static final SMType1Font COURIER_BOLD_OBLIQUE = new SMType1Font("Courier-BoldOblique");
    public static final SMType1Font SYMBOL = new SMType1Font("Symbol");
    public static final SMType1Font ZAPF_DINGBATS = new SMType1Font("ZapfDingbats");
    private static final Map<String, SMType1Font> STANDARD_14 = new HashMap<String, SMType1Font>();
    private Font awtFont = null;

    static {
        STANDARD_14.put(TIMES_ROMAN.getBaseFont(), TIMES_ROMAN);
        STANDARD_14.put(TIMES_BOLD.getBaseFont(), TIMES_BOLD);
        STANDARD_14.put(TIMES_ITALIC.getBaseFont(), TIMES_ITALIC);
        STANDARD_14.put(TIMES_BOLD_ITALIC.getBaseFont(), TIMES_BOLD_ITALIC);
        STANDARD_14.put(HELVETICA.getBaseFont(), HELVETICA);
        STANDARD_14.put(HELVETICA_BOLD.getBaseFont(), HELVETICA_BOLD);
        STANDARD_14.put(HELVETICA_OBLIQUE.getBaseFont(), HELVETICA_OBLIQUE);
        STANDARD_14.put(HELVETICA_BOLD_OBLIQUE.getBaseFont(), HELVETICA_BOLD_OBLIQUE);
        STANDARD_14.put(COURIER.getBaseFont(), COURIER);
        STANDARD_14.put(COURIER_BOLD.getBaseFont(), COURIER_BOLD);
        STANDARD_14.put(COURIER_OBLIQUE.getBaseFont(), COURIER_OBLIQUE);
        STANDARD_14.put(COURIER_BOLD_OBLIQUE.getBaseFont(), COURIER_BOLD_OBLIQUE);
        STANDARD_14.put(SYMBOL.getBaseFont(), SYMBOL);
        STANDARD_14.put(ZAPF_DINGBATS.getBaseFont(), ZAPF_DINGBATS);
    }

    public SMType1Font() {
        this.font.setItem(OMName.SUBTYPE, (OMBase)OMName.TYPE1);
    }

    public SMType1Font(OMDictionary fontDictionary) {
        super(fontDictionary);
        SMStream fontFile3;
        SMFontDescriptor fd = this.getFontDescriptor();
        if (fd != null && fd instanceof SMFontDescriptorDictionary && (fontFile3 = ((SMFontDescriptorDictionary)fd).getFontFile3()) != null) {
            try {
                this.type1CFont = new SMType1CFont(this.font);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public SMType1Font(String baseFont) {
        this();
        this.setBaseFont(baseFont);
        this.setFontEncoding(new WinAnsiEncoding());
        this.setEncoding(OMName.WIN_ANSI_ENCODING);
    }

    public static SMType1Font getStandardFont(String name) {
        return STANDARD_14.get(name);
    }

    public static String[] getStandard14Names() {
        return STANDARD_14.keySet().toArray(new String[14]);
    }

    public Font getawtFont() throws IOException {
        if (this.awtFont == null) {
            if (this.type1CFont != null) {
                this.awtFont = this.type1CFont.getawtFont();
            } else {
                String baseFont = this.getBaseFont();
                SMFontDescriptor fd = this.getFontDescriptor();
                if (fd != null && fd instanceof SMFontDescriptorDictionary) {
                    SMFontDescriptorDictionary fdDictionary = (SMFontDescriptorDictionary)fd;
                    if (fdDictionary.getFontFile() != null) {
                        try {
                            this.awtFont = Font.createFont(1, fdDictionary.getFontFile().createInputStream());
                        }
                        catch (FontFormatException fontFormatException) {
                            // empty catch block
                        }
                    }
                    if (this.awtFont == null) {
                        this.awtFont = FontManager.getAwtFont(fd.getFontName());
                    }
                } else {
                    this.awtFont = FontManager.getAwtFont(baseFont);
                }
            }
            if (this.awtFont == null) {
                this.awtFont = FontManager.getStandardFont();
            }
        }
        return this.awtFont;
    }

    protected void determineEncoding() {
        super.determineEncoding();
        Encoding fontEncoding = this.getFontEncoding();
        if (fontEncoding == null) {
            FontMetric metric = this.getAFM();
            if (metric != null) {
                fontEncoding = new AFMEncoding(metric);
            }
            this.setFontEncoding(fontEncoding);
        }
        this.getEncodingFromFont(this.getFontEncoding() == null);
    }

    private void getEncodingFromFont(boolean extractEncoding) {
        block32: {
            SMStream fontFile;
            SMFontDescriptor fontDescriptor = this.getFontDescriptor();
            if (fontDescriptor != null && fontDescriptor instanceof SMFontDescriptorDictionary && (fontFile = ((SMFontDescriptorDictionary)fontDescriptor).getFontFile()) != null) {
                BufferedReader in = null;
                try {
                    try {
                        in = new BufferedReader(new InputStreamReader(fontFile.createInputStream()));
                        String line = "";
                        Type1Encoding encoding = null;
                        while ((line = in.readLine()) != null) {
                            if (extractEncoding) {
                                StringTokenizer st;
                                if (line.startsWith("currentdict end")) {
                                    if (encoding != null) {
                                        this.setFontEncoding(encoding);
                                    }
                                    break;
                                }
                                if (line.startsWith("/Encoding")) {
                                    if (line.contains("array")) {
                                        st = new StringTokenizer(line);
                                        st.nextElement();
                                        int arraySize = Integer.parseInt(st.nextToken());
                                        encoding = new Type1Encoding(arraySize);
                                    } else if (this.getFontEncoding() == null) {
                                        st = new StringTokenizer(line);
                                        st.nextElement();
                                        String type1Encoding = st.nextToken();
                                        this.setFontEncoding(EncodingManager.INSTANCE.getEncoding(OMName.getPDFName(type1Encoding)));
                                        break;
                                    }
                                } else if (line.startsWith("dup")) {
                                    st = new StringTokenizer(line.replaceAll("/", " /"));
                                    st.nextElement();
                                    try {
                                        int index = Integer.parseInt(st.nextToken());
                                        String name = st.nextToken();
                                        if (encoding == null) continue;
                                        encoding.addCharacterEncoding(index, name.replace("/", ""));
                                    }
                                    catch (NumberFormatException index) {}
                                    continue;
                                }
                            }
                            if (!line.startsWith("/FontMatrix")) continue;
                            if (line.indexOf("[") > -1) {
                                String matrixValues = line.substring(line.indexOf("[") + 1, line.lastIndexOf("]"));
                                StringTokenizer st = new StringTokenizer(matrixValues);
                                OMArray array = new OMArray();
                                if (st.countTokens() < 6) continue;
                                try {
                                    int i = 0;
                                    while (i < 6) {
                                        OMFloat floatValue = new OMFloat(Float.parseFloat(st.nextToken()));
                                        array.add(floatValue);
                                        ++i;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                this.fontMatrix = new SMMatrix(array);
                                continue;
                            }
                            OMArray array = new OMArray();
                            while ((line = in.readLine()) != null) {
                                if (line.startsWith("[")) continue;
                                if (line.endsWith("]")) break;
                                try {
                                    OMFloat floatValue = new OMFloat(Float.parseFloat(line));
                                    array.add(floatValue);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (array.size() != 6) continue;
                            this.fontMatrix = new SMMatrix(array);
                        }
                    }
                    catch (IOException iOException) {
                        if (in == null) break block32;
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    public String encode(byte[] c, int offset, int length) throws IOException {
        if (this.type1CFont != null) {
            return this.type1CFont.encode(c, offset, length);
        }
        return super.encode(c, offset, length);
    }

    public int encodeToCID(byte[] c, int offset, int length) throws IOException {
        if (this.type1CFont != null && this.getFontEncoding() == null) {
            return this.type1CFont.encodeToCID(c, offset, length);
        }
        return super.encodeToCID(c, offset, length);
    }

    public SMMatrix getFontMatrix() {
        if (this.type1CFont != null) {
            return this.type1CFont.getFontMatrix();
        }
        return super.getFontMatrix();
    }

    protected GlyphVector remapGlyphs(GlyphVector glyphVector, String string) {
        try {
            Field fGlyphs = glyphVector.getClass().getDeclaredField("glyphs");
            fGlyphs.setAccessible(true);
            int[] glyphs = (int[])fGlyphs.get(glyphVector);
            if (glyphs.length == 1 && glyphs[0] != 65535) {
                return glyphVector;
            }
            if (this.type1CFont != null) {
                Field fuserGlyphs = glyphVector.getClass().getDeclaredField("userGlyphs");
                fuserGlyphs.setAccessible(true);
                int[] userGlyphs = (int[])fuserGlyphs.get(glyphVector);
                int j = 0;
                while (j < glyphs.length) {
                    if (glyphs[j] == 65535) {
                        char c = string.charAt(j);
                        glyphs[j] = this.type1CFont.getGlyphIndex(c);
                        userGlyphs[j] = this.type1CFont.getGlyphIndex(c);
                    }
                    ++j;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return glyphVector;
    }
}

