/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.font;

import com.plpdf.encoding.Encoding;
import com.plpdf.encoding.EncodingManager;
import com.plpdf.exceptions.WrappedIOException;
import com.plpdf.font.afm.AFMParser;
import com.plpdf.font.afm.FontMetric;
import com.plpdf.font.cff.AFMFormatter;
import com.plpdf.font.cff.CFFFont;
import com.plpdf.font.cff.CFFParser;
import com.plpdf.font.cff.Type1FontFormatter;
import com.plpdf.font.cff.charset.CFFCharset;
import com.plpdf.font.cff.encoding.CFFEncoding;
import com.plpdf.font.util.BoundingBox;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.smmodel.common.SMMatrix;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.font.SMFontDescriptor;
import com.plpdf.smmodel.font.SMFontDescriptorDictionary;
import com.plpdf.smmodel.font.SMSimpleFont;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMType1CFont
extends SMSimpleFont {
    private CFFFont cffFont = null;
    private Map<Integer, String> codeToName = new HashMap<Integer, String>();
    private Map<Integer, String> codeToCharacter = new HashMap<Integer, String>();
    private Map<String, Integer> characterToCode = new HashMap<String, Integer>();
    private FontMetric fontMetric = null;
    private Font awtFont = null;
    private Map<String, Float> glyphWidths = new HashMap<String, Float>();
    private Map<String, Float> glyphHeights = new HashMap<String, Float>();
    private Float avgWidth = null;
    private SMRectangle fontBBox = null;
    private static final byte[] SPACE_BYTES = new byte[]{32};
    private OMDictionary fontDict = null;
    private Map<Integer, Integer> codeToGlyph = new HashMap<Integer, Integer>();

    public SMType1CFont(OMDictionary fontDictionary) throws IOException {
        super(fontDictionary);
        this.fontDict = fontDictionary;
        this.load();
    }

    @Override
    public String encode(byte[] bytes, int offset, int length) throws IOException {
        String character = this.getCharacter(bytes, offset, length);
        if (character == null) {
            return null;
        }
        return character;
    }

    @Override
    public int encodeToCID(byte[] bytes, int offset, int length) {
        if (length > 2) {
            return -1;
        }
        int code = bytes[offset] & 0xFF;
        if (length == 2) {
            code = code * 256 + bytes[offset + 1] & 0xFF;
        }
        return code;
    }

    private String getCharacter(byte[] bytes, int offset, int length) {
        int code = this.encodeToCID(bytes, offset, length);
        if (code == -1) {
            return null;
        }
        return this.codeToCharacter.get(code);
    }

    @Override
    public float getFontWidth(byte[] bytes, int offset, int length) throws IOException {
        String name = this.getName(bytes, offset, length);
        if (name == null && !Arrays.equals(SPACE_BYTES, bytes)) {
            return 0.0f;
        }
        Float width = this.glyphWidths.get(name);
        if (width == null) {
            width = Float.valueOf(this.getFontMetric().getCharacterWidth(name));
            this.glyphWidths.put(name, width);
        }
        return width.floatValue();
    }

    @Override
    public float getFontHeight(byte[] bytes, int offset, int length) throws IOException {
        String name = this.getName(bytes, offset, length);
        if (name == null) {
            return 0.0f;
        }
        Float height = this.glyphHeights.get(name);
        if (height == null) {
            height = Float.valueOf(this.getFontMetric().getCharacterHeight(name));
            this.glyphHeights.put(name, height);
        }
        return height.floatValue();
    }

    private String getName(byte[] bytes, int offset, int length) {
        if (length > 2) {
            return null;
        }
        int code = bytes[offset] & 0xFF;
        if (length == 2) {
            code = code * 256 + bytes[offset + 1] & 0xFF;
        }
        return this.codeToName.get(code);
    }

    @Override
    public float getStringWidth(String string) throws IOException {
        float width = 0.0f;
        int i = 0;
        while (i < string.length()) {
            String character = string.substring(i, i + 1);
            Integer code = this.getCode(character);
            if (code == null) {
                return 0.0f;
            }
            width += this.getFontWidth(new byte[]{(byte)code.intValue()}, 0, 1);
            ++i;
        }
        return width;
    }

    private Integer getCode(String character) {
        return this.characterToCode.get(character);
    }

    protected Integer getGlyphIndex(int code) {
        return this.codeToGlyph.get(code);
    }

    @Override
    public float getAverageFontWidth() throws IOException {
        if (this.avgWidth == null) {
            this.avgWidth = Float.valueOf(this.getFontMetric().getAverageCharacterWidth());
        }
        return this.avgWidth.floatValue();
    }

    @Override
    public SMRectangle getFontBoundingBox() throws IOException {
        if (this.fontBBox == null) {
            this.fontBBox = new SMRectangle(this.getFontMetric().getFontBBox());
        }
        return this.fontBBox;
    }

    @Override
    public SMMatrix getFontMatrix() {
        if (this.fontMatrix == null) {
            List numbers = (List)this.cffFont.getProperty("FontMatrix");
            if (numbers != null && numbers.size() == 6) {
                OMArray array = new OMArray();
                for (Number number : numbers) {
                    array.add(new OMFloat(number.floatValue()));
                }
                this.fontMatrix = new SMMatrix(array);
            } else {
                super.getFontMatrix();
            }
        }
        return this.fontMatrix;
    }

    @Override
    public Font getawtFont() throws IOException {
        if (this.awtFont == null) {
            this.awtFont = SMType1CFont.prepareAwtFont(this.cffFont);
        }
        return this.awtFont;
    }

    private FontMetric getFontMetric() {
        if (this.fontMetric == null) {
            try {
                this.fontMetric = this.prepareFontMetric(this.cffFont);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.fontMetric;
    }

    private void load() throws IOException {
        byte[] cffBytes = this.loadBytes();
        CFFParser cffParser = new CFFParser();
        List<CFFFont> fonts = cffParser.parse(cffBytes);
        String baseFontName = this.getBaseFont();
        if (fonts.size() > 1 && baseFontName != null) {
            for (CFFFont font : fonts) {
                if (!baseFontName.equals(font.getName())) continue;
                this.cffFont = font;
                break;
            }
        }
        if (this.cffFont == null) {
            this.cffFont = fonts.get(0);
        }
        PDFEncoding pdfEncoding = new PDFEncoding();
        PDFCharset pdfCharset = new PDFCharset();
        Map<String, byte[]> charStringsDict = this.cffFont.getCharStringsDict();
        LinkedHashMap<String, byte[]> pdfCharStringsDict = new LinkedHashMap<String, byte[]>();
        pdfCharStringsDict.put(".notdef", charStringsDict.get(".notdef"));
        LinkedHashMap<Integer, String> codeToNameMap = new LinkedHashMap<Integer, String>();
        Collection<CFFFont.Mapping> mappings = this.cffFont.getMappings();
        for (CFFFont.Mapping mapping : mappings) {
            Integer code = mapping.getCode();
            String name = mapping.getName();
            codeToNameMap.put(code, name);
        }
        HashSet knownNames = new HashSet(codeToNameMap.values());
        Map<Integer, String> codeToNameOverride = this.loadOverride();
        for (Map.Entry<Integer, String> entry : codeToNameOverride.entrySet()) {
            Integer code = entry.getKey();
            String name = entry.getValue();
            if (!knownNames.contains(name)) continue;
            Iterator iter = codeToNameMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry existingEntry = iter.next();
                if (!((String)existingEntry.getValue()).equals(name)) continue;
                iter.remove();
                break;
            }
            codeToNameMap.put(code, name);
        }
        int glyphIndex = 0;
        for (Map.Entry entry : codeToNameMap.entrySet()) {
            Integer code = (Integer)entry.getKey();
            String name = (String)entry.getValue();
            String uniName = "uni" + SMType1CFont.hexString(code, 4);
            String character = String.valueOf((char)code.intValue());
            pdfEncoding.register(code, code);
            pdfCharset.register(code, uniName);
            this.codeToName.put(code, uniName);
            this.codeToCharacter.put(code, character);
            this.characterToCode.put(character, code);
            this.codeToGlyph.put(code, glyphIndex++);
            pdfCharStringsDict.put(uniName, charStringsDict.get(name));
        }
        this.cffFont.setEncoding(pdfEncoding);
        this.cffFont.setCharset(pdfCharset);
        charStringsDict.clear();
        charStringsDict.putAll(pdfCharStringsDict);
        Number defaultWidthX = (Number)this.cffFont.getProperty("defaultWidthX");
        this.glyphWidths.put(null, Float.valueOf(defaultWidthX.floatValue()));
    }

    private byte[] loadBytes() throws IOException {
        SMStream ff3Stream;
        SMFontDescriptor fd = this.getFontDescriptor();
        if (fd != null && fd instanceof SMFontDescriptorDictionary && (ff3Stream = ((SMFontDescriptorDictionary)fd).getFontFile3()) != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            InputStream is = ff3Stream.createInputStream();
            try {
                int count;
                byte[] buf = new byte[512];
                while ((count = is.read(buf)) >= 0) {
                    os.write(buf, 0, count);
                }
            }
            finally {
                is.close();
            }
            return os.toByteArray();
        }
        throw new IOException();
    }

    private Map<Integer, String> loadOverride() throws IOException {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        OMBase encoding = this.fontDict.getDictionaryObject(OMName.ENCODING);
        if (encoding instanceof OMName) {
            OMName name = (OMName)encoding;
            result.putAll(this.loadEncoding(name));
        } else if (encoding instanceof OMDictionary) {
            OMArray differences;
            OMDictionary encodingDic = (OMDictionary)encoding;
            OMName baseName = (OMName)encodingDic.getDictionaryObject(OMName.BASE_ENCODING);
            if (baseName != null) {
                result.putAll(this.loadEncoding(baseName));
            }
            if ((differences = (OMArray)encodingDic.getDictionaryObject(OMName.DIFFERENCES)) != null) {
                Map<Integer, String> diffs = this.loadDifferences(differences);
                if (baseName == null) {
                    result.putAll(diffs);
                } else {
                    HashSet knownNames = new HashSet(result.values());
                    for (Map.Entry<Integer, String> entry : diffs.entrySet()) {
                        Integer code = entry.getKey();
                        String name = entry.getValue();
                        if (knownNames.contains(name)) {
                            Iterator iter = result.entrySet().iterator();
                            while (iter.hasNext()) {
                                Map.Entry existingEntry = iter.next();
                                if (!((String)existingEntry.getValue()).equals(name)) continue;
                                iter.remove();
                                break;
                            }
                        }
                        result.put(code, name);
                    }
                }
            }
        }
        return result;
    }

    private Map<Integer, String> loadEncoding(OMName name) throws IOException {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        Encoding encoding = EncodingManager.INSTANCE.getEncoding(name);
        for (Map.Entry<Integer, String> entry : encoding.getCodeToNameMap().entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private Map<Integer, String> loadDifferences(OMArray differences) {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        Integer code = null;
        int i = 0;
        while (i < differences.size()) {
            OMBase element = differences.get(i);
            if (element instanceof OMNumber) {
                OMNumber number = (OMNumber)element;
                code = number.intValue();
            } else if (element instanceof OMName) {
                OMName name = (OMName)element;
                result.put(code, name.getName());
                code = code + 1;
            }
            ++i;
        }
        return result;
    }

    private static String hexString(int code, int length) {
        String string = Integer.toHexString(code).toUpperCase();
        while (string.length() < length) {
            string = "0" + string;
        }
        return string;
    }

    private FontMetric prepareFontMetric(CFFFont font) throws IOException {
        byte[] afmBytes = AFMFormatter.format(font);
        ByteArrayInputStream is = new ByteArrayInputStream(afmBytes);
        try {
            AFMParser afmParser = new AFMParser(is);
            afmParser.parse();
            FontMetric result = afmParser.getResult();
            BoundingBox bounds = result.getFontBBox();
            List<Integer> numbers = Arrays.asList((int)bounds.getLowerLeftX(), (int)bounds.getLowerLeftY(), (int)bounds.getUpperRightX(), (int)bounds.getUpperRightY());
            font.addValueToTopDict("FontBBox", numbers);
            FontMetric fontMetric = result;
            return fontMetric;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private static Font prepareAwtFont(CFFFont font) throws IOException {
        byte[] type1Bytes = Type1FontFormatter.format(font);
        ByteArrayInputStream is = new ByteArrayInputStream(type1Bytes);
        try {
            Font font2 = Font.createFont(1, is);
            return font2;
        }
        catch (FontFormatException ffe) {
            throw new WrappedIOException(ffe);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private static class PDFCharset
    extends CFFCharset {
        private PDFCharset() {
        }

        public boolean isFontSpecific() {
            return true;
        }
    }

    private static class PDFEncoding
    extends CFFEncoding {
        private PDFEncoding() {
        }

        public boolean isFontSpecific() {
            return true;
        }
    }
}

