/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.font;

import com.plpdf.encoding.AFMEncoding;
import com.plpdf.encoding.DictionaryEncoding;
import com.plpdf.encoding.Encoding;
import com.plpdf.font.afm.AFMParser;
import com.plpdf.font.afm.CharMetric;
import com.plpdf.font.afm.FontMetric;
import com.plpdf.font.pfb.PfbParser;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.font.SMFontDescriptorDictionary;
import com.plpdf.smmodel.font.SMType1Font;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SMType1AfmPfbFont
extends SMType1Font {
    private static final int BUFFERSIZE = 65535;
    private FontMetric metric;

    public SMType1AfmPfbFont(SMDocument doc, String afmname) throws IOException {
        BufferedInputStream afmin = new BufferedInputStream(new FileInputStream(afmname), 65535);
        String pfbname = String.valueOf(afmname.replaceAll(".AFM", "").replaceAll(".afm", "")) + ".pfb";
        BufferedInputStream pfbin = new BufferedInputStream(new FileInputStream(pfbname), 65535);
        this.load(doc, afmin, pfbin);
    }

    public SMType1AfmPfbFont(SMDocument doc, InputStream afm, InputStream pfb) throws IOException {
        this.load(doc, afm, pfb);
    }

    private void load(SMDocument doc, InputStream afm, InputStream pfb) throws IOException {
        SMFontDescriptorDictionary fd = new SMFontDescriptorDictionary();
        this.setFontDescriptor(fd);
        PfbParser pfbparser = new PfbParser(pfb);
        pfb.close();
        SMStream fontStream = new SMStream(doc, pfbparser.getInputStream(), false);
        fontStream.getStream().setInt("Length", pfbparser.size());
        int i = 0;
        while (i < pfbparser.getLengths().length) {
            fontStream.getStream().setInt("Length" + (i + 1), pfbparser.getLengths()[i]);
            ++i;
        }
        fontStream.addCompression();
        fd.setFontFile(fontStream);
        AFMParser parser = new AFMParser(afm);
        parser.parse();
        this.metric = parser.getResult();
        this.setFontEncoding(this.afmToDictionary(new AFMEncoding(this.metric)));
        this.setBaseFont(this.metric.getFontName());
        fd.setFontName(this.metric.getFontName());
        fd.setFontFamily(this.metric.getFamilyName());
        fd.setNonSymbolic(true);
        fd.setFontBoundingBox(new SMRectangle(this.metric.getFontBBox()));
        fd.setItalicAngle(this.metric.getItalicAngle());
        fd.setAscent(this.metric.getAscender());
        fd.setDescent(this.metric.getDescender());
        fd.setCapHeight(this.metric.getCapHeight());
        fd.setXHeight(this.metric.getXHeight());
        fd.setAverageWidth(this.metric.getAverageCharacterWidth());
        fd.setCharacterSet(this.metric.getCharacterSet());
        int firstchar = 255;
        int lastchar = 0;
        List<CharMetric> listmetric = this.metric.getCharMetrics();
        Encoding encoding = this.getFontEncoding();
        int maxWidths = 256;
        ArrayList<Integer> widths = new ArrayList<Integer>(maxWidths);
        int zero = 250;
        Iterator<CharMetric> iter = listmetric.iterator();
        int i2 = 0;
        while (i2 < maxWidths) {
            widths.add(zero);
            ++i2;
        }
        while (iter.hasNext()) {
            CharMetric m = iter.next();
            int n = m.getCharacterCode();
            if (n > 0) {
                firstchar = Math.min(firstchar, n);
                lastchar = Math.max(lastchar, n);
                if (!(m.getWx() > 0.0f)) continue;
                int width = Math.round(m.getWx());
                widths.set(n, width);
                if (!m.getName().equals("germandbls") || n == 223) continue;
                widths.set(223, width);
                continue;
            }
            if (m.getName().equals("adieresis")) {
                widths.set(228, (Integer)widths.get(encoding.getCode("a")));
                continue;
            }
            if (m.getName().equals("odieresis")) {
                widths.set(246, (Integer)widths.get(encoding.getCode("o")));
                continue;
            }
            if (m.getName().equals("udieresis")) {
                widths.set(252, (Integer)widths.get(encoding.getCode("u")));
                continue;
            }
            if (m.getName().equals("Adieresis")) {
                widths.set(196, (Integer)widths.get(encoding.getCode("A")));
                continue;
            }
            if (m.getName().equals("Odieresis")) {
                widths.set(214, (Integer)widths.get(encoding.getCode("O")));
                continue;
            }
            if (!m.getName().equals("Udieresis")) continue;
            widths.set(220, (Integer)widths.get(encoding.getCode("U")));
        }
        this.setFirstChar(0);
        this.setLastChar(255);
        this.setWidths(widths);
    }

    private DictionaryEncoding afmToDictionary(AFMEncoding encoding) throws IOException {
        OMArray array = new OMArray();
        array.add(OMInteger.ZERO);
        int i = 0;
        while (i < 256) {
            array.add(OMName.getPDFName(encoding.getName(i)));
            ++i;
        }
        array.set(224, OMName.getPDFName("germandbls"));
        array.set(229, OMName.getPDFName("adieresis"));
        array.set(247, OMName.getPDFName("odieresis"));
        array.set(253, OMName.getPDFName("udieresis"));
        array.set(197, OMName.getPDFName("Adieresis"));
        array.set(215, OMName.getPDFName("Odieresis"));
        array.set(221, OMName.getPDFName("Udieresis"));
        OMDictionary dictionary = new OMDictionary();
        dictionary.setItem(OMName.NAME, (OMBase)OMName.ENCODING);
        dictionary.setItem(OMName.DIFFERENCES, (OMBase)array);
        dictionary.setItem(OMName.BASE_ENCODING, (OMBase)OMName.STANDARD_ENCODING);
        return new DictionaryEncoding(dictionary);
    }
}

