/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.font;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.font.FontManager;
import com.plpdf.smmodel.font.SMFont;
import com.plpdf.smmodel.font.SMFontFactory;
import com.plpdf.smmodel.font.SMSimpleFont;
import java.awt.Font;
import java.io.IOException;

public class SMType0Font
extends SMSimpleFont {
    private OMArray descendantFontArray;
    private SMFont descendantFont;
    private OMDictionary descendantFontDictionary;
    private Font awtFont;

    public SMType0Font() {
        this.font.setItem(OMName.SUBTYPE, (OMBase)OMName.TYPE0);
    }

    public SMType0Font(OMDictionary fontDictionary) {
        super(fontDictionary);
        this.descendantFontDictionary = (OMDictionary)this.getDescendantFonts().getObject(0);
        if (this.descendantFontDictionary != null) {
            try {
                this.descendantFont = SMFontFactory.createFont(this.descendantFontDictionary);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Font getawtFont() throws IOException {
        if (this.awtFont == null) {
            if (this.descendantFont != null) {
                this.awtFont = ((SMSimpleFont)this.descendantFont).getawtFont();
            }
            if (this.awtFont != null) {
                this.setIsFontSubstituted(((SMSimpleFont)this.descendantFont).isFontSubstituted());
                this.awtFont.canDisplay(1);
            } else {
                this.awtFont = FontManager.getStandardFont();
                this.setIsFontSubstituted(true);
            }
            this.awtFont.canDisplay(1);
        }
        return this.awtFont;
    }

    public SMRectangle getFontBoundingBox() throws IOException {
        throw new RuntimeException("Not yet implemented");
    }

    public float getFontWidth(byte[] c, int offset, int length) throws IOException {
        return this.descendantFont.getFontWidth(c, offset, length);
    }

    public float getFontHeight(byte[] c, int offset, int length) throws IOException {
        return this.descendantFont.getFontHeight(c, offset, length);
    }

    public float getAverageFontWidth() throws IOException {
        return this.descendantFont.getAverageFontWidth();
    }

    private OMArray getDescendantFonts() {
        if (this.descendantFontArray == null) {
            this.descendantFontArray = (OMArray)this.font.getDictionaryObject(OMName.DESCENDANT_FONTS);
        }
        return this.descendantFontArray;
    }

    public float getFontWidth(int charCode) {
        return this.descendantFont.getFontWidth(charCode);
    }

    public String encode(byte[] c, int offset, int length) throws IOException {
        int result;
        String retval = null;
        if (this.hasToUnicode()) {
            retval = super.encode(c, offset, length);
        }
        if (retval == null && (result = this.cmap.lookupCID(c, offset, length)) != -1) {
            retval = this.descendantFont.cmapEncoding(result, 2, true, null);
        }
        return retval;
    }

    protected SMFont getDescendantFont() {
        return this.descendantFont;
    }
}

