/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.font;

import com.plpdf.encoding.Encoding;
import com.plpdf.encoding.WinAnsiEncoding;
import com.plpdf.font.ttf.CMAPEncodingEntry;
import com.plpdf.font.ttf.CMAPTable;
import com.plpdf.font.ttf.GlyphData;
import com.plpdf.font.ttf.GlyphTable;
import com.plpdf.font.ttf.HeaderTable;
import com.plpdf.font.ttf.HorizontalHeaderTable;
import com.plpdf.font.ttf.HorizontalMetricsTable;
import com.plpdf.font.ttf.NameRecord;
import com.plpdf.font.ttf.NamingTable;
import com.plpdf.font.ttf.OS2WindowsMetricsTable;
import com.plpdf.font.ttf.PostScriptTable;
import com.plpdf.font.ttf.TTFParser;
import com.plpdf.font.ttf.TTFSubFont;
import com.plpdf.font.ttf.TrueTypeFont;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.font.FontManager;
import com.plpdf.smmodel.font.SMFontDescriptorDictionary;
import com.plpdf.smmodel.font.SMSimpleFont;
import com.plpdf.util.ResourceLoader;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class SMTrueTypeFont
extends SMSimpleFont {
    public static final String UNKNOWN_FONT = "UNKNOWN_FONT";
    private Font awtFont = null;
    private static Properties externalFonts = new Properties();
    private static Map<String, TrueTypeFont> loadedExternalFonts = new HashMap<String, TrueTypeFont>();

    static {
        try {
            ResourceLoader.loadProperties("com/plpdf/res/PLPDF_External_Fonts.properties", externalFonts);
        }
        catch (IOException io) {
            throw new RuntimeException("Error loading font resources", io);
        }
    }

    public SMTrueTypeFont() {
        this.font.setItem(OMName.SUBTYPE, (OMBase)OMName.TRUE_TYPE);
    }

    public SMTrueTypeFont(OMDictionary fontDictionary) throws IOException {
        super(fontDictionary);
        this.ensureFontDescriptor();
    }

    public static SMTrueTypeFont loadTTF(SMDocument doc, String file) throws IOException {
        return SMTrueTypeFont.loadTTF(doc, new File(file));
    }

    public static SMTrueTypeFont loadTTF(SMDocument doc, File file) throws IOException {
        return SMTrueTypeFont.loadTTF(doc, new FileInputStream(file));
    }

    public static SMTrueTypeFont loadTTF(SMDocument doc, InputStream stream) throws IOException {
        return SMTrueTypeFont.loadTTF(doc, stream, new WinAnsiEncoding());
    }

    public static SMTrueTypeFont loadTTF(SMDocument doc, InputStream stream, Encoding enc) throws IOException {
        SMStream fontStream = new SMStream(doc, stream, false);
        fontStream.getStream().setInt(OMName.LENGTH1, fontStream.getByteArray().length);
        fontStream.addCompression();
        return SMTrueTypeFont.loadTTF(fontStream, enc);
    }

    public static SMTrueTypeFont loadTTF(SMStream fontStream, Encoding enc) throws IOException {
        SMTrueTypeFont retval = new SMTrueTypeFont();
        retval.setFontEncoding(enc);
        retval.setEncoding(enc.getOMObject());
        SMFontDescriptorDictionary fd = new SMFontDescriptorDictionary();
        retval.setFontDescriptor(fd);
        fd.setFontFile2(fontStream);
        InputStream stream = fontStream.createInputStream();
        try {
            retval.loadDescriptorDictionary(fd, stream);
        }
        finally {
            stream.close();
        }
        return retval;
    }

    private void ensureFontDescriptor() throws IOException {
        if (this.getFontDescriptor() == null) {
            SMFontDescriptorDictionary fdd = new SMFontDescriptorDictionary();
            this.setFontDescriptor(fdd);
            InputStream ttfData = this.getExternalTTFData();
            if (ttfData != null) {
                try {
                    this.loadDescriptorDictionary(fdd, ttfData);
                }
                finally {
                    ttfData.close();
                }
            }
        }
    }

    private void loadDescriptorDictionary(SMFontDescriptorDictionary fd, InputStream ttfData) throws IOException {
        TrueTypeFont ttf = null;
        try {
            TTFParser parser = new TTFParser();
            ttf = parser.parseTTF(ttfData);
            NamingTable naming = ttf.getNaming();
            List<NameRecord> records = naming.getNameRecords();
            int i = 0;
            while (i < records.size()) {
                NameRecord nr = records.get(i);
                if (nr.getNameId() == 6) {
                    this.setBaseFont(nr.getString());
                    fd.setFontName(nr.getString());
                } else if (nr.getNameId() == 1) {
                    fd.setFontFamily(nr.getString());
                }
                ++i;
            }
            OS2WindowsMetricsTable os2 = ttf.getOS2Windows();
            boolean isSymbolic = false;
            switch (os2.getFamilyClass()) {
                case 12: {
                    isSymbolic = true;
                    break;
                }
                case 10: {
                    fd.setScript(true);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    fd.setSerif(true);
                }
            }
            switch (os2.getWidthClass()) {
                case 1: {
                    fd.setFontStretch("UltraCondensed");
                    break;
                }
                case 2: {
                    fd.setFontStretch("ExtraCondensed");
                    break;
                }
                case 3: {
                    fd.setFontStretch("Condensed");
                    break;
                }
                case 4: {
                    fd.setFontStretch("SemiCondensed");
                    break;
                }
                case 5: {
                    fd.setFontStretch("Normal");
                    break;
                }
                case 6: {
                    fd.setFontStretch("SemiExpanded");
                    break;
                }
                case 7: {
                    fd.setFontStretch("Expanded");
                    break;
                }
                case 8: {
                    fd.setFontStretch("ExtraExpanded");
                    break;
                }
                case 9: {
                    fd.setFontStretch("UltraExpanded");
                }
            }
            fd.setFontWeight(os2.getWeightClass());
            fd.setSymbolic(isSymbolic);
            fd.setNonSymbolic(!isSymbolic);
            HeaderTable header = ttf.getHeader();
            SMRectangle rect = new SMRectangle();
            float scaling = 1000.0f / (float)header.getUnitsPerEm();
            rect.setLowerLeftX((float)header.getXMin() * scaling);
            rect.setLowerLeftY((float)header.getYMin() * scaling);
            rect.setUpperRightX((float)header.getXMax() * scaling);
            rect.setUpperRightY((float)header.getYMax() * scaling);
            fd.setFontBoundingBox(rect);
            HorizontalHeaderTable hHeader = ttf.getHorizontalHeader();
            fd.setAscent((float)hHeader.getAscender() * scaling);
            fd.setDescent((float)hHeader.getDescender() * scaling);
            GlyphTable glyphTable = ttf.getGlyph();
            GlyphData[] glyphs = glyphTable.getGlyphs();
            PostScriptTable ps = ttf.getPostScript();
            fd.setFixedPitch(ps.getIsFixedPitch() > 0L);
            fd.setItalicAngle(ps.getItalicAngle());
            String[] names = ps.getGlyphNames();
            if (names != null) {
                int i2 = 0;
                while (i2 < names.length) {
                    if (names[i2].equals("H")) {
                        fd.setCapHeight(glyphs[i2].getBoundingBox().getUpperRightY() / scaling);
                    }
                    if (names[i2].equals("x")) {
                        fd.setXHeight(glyphs[i2].getBoundingBox().getUpperRightY() / scaling);
                    }
                    ++i2;
                }
            }
            fd.setStemV(fd.getFontBoundingBox().getWidth() * 0.13f);
            CMAPTable cmapTable = ttf.getCMAP();
            CMAPEncodingEntry[] cmaps = cmapTable.getCmaps();
            CMAPEncodingEntry uniMap = null;
            int i3 = 0;
            while (i3 < cmaps.length) {
                int platformEncoding;
                if (cmaps[i3].getPlatformId() == 3 && 1 == (platformEncoding = cmaps[i3].getPlatformEncodingId())) {
                    uniMap = cmaps[i3];
                    break;
                }
                ++i3;
            }
            Map<Integer, String> codeToName = this.getFontEncoding().getCodeToNameMap();
            int firstChar = Collections.min(codeToName.keySet());
            int lastChar = Collections.max(codeToName.keySet());
            HorizontalMetricsTable hMet = ttf.getHorizontalMetrics();
            int[] widthValues = hMet.getAdvanceWidth();
            boolean isMonospaced = fd.isFixedPitch();
            int nWidths = lastChar - firstChar + 1;
            ArrayList<Integer> widths = new ArrayList<Integer>(nWidths);
            int defaultWidth = Math.round((float)widthValues[0] * scaling);
            int i4 = 0;
            while (i4 < nWidths) {
                widths.add(defaultWidth);
                ++i4;
            }
            WinAnsiEncoding glyphlist = WinAnsiEncoding.INSTANCE;
            for (Map.Entry<Integer, String> e : codeToName.entrySet()) {
                String name = e.getValue();
                String c = glyphlist.getCharacter(name);
                int charCode = c.codePointAt(0);
                int gid = uniMap.getGlyphId(charCode);
                if (gid == 0) continue;
                if (isMonospaced) {
                    widths.set(e.getKey() - firstChar, defaultWidth);
                    continue;
                }
                widths.set(e.getKey() - firstChar, Math.round((float)widthValues[gid] * scaling));
            }
            this.setWidths(widths);
            this.setFirstChar(firstChar);
            this.setLastChar(lastChar);
        }
        finally {
            if (ttf != null) {
                ttf.close();
            }
        }
    }

    public Font getawtFont() throws IOException {
        SMFontDescriptorDictionary fd = (SMFontDescriptorDictionary)this.getFontDescriptor();
        if (this.awtFont == null) {
            SMStream ff2Stream = fd.getFontFile2();
            if (ff2Stream != null) {
                try {
                    this.awtFont = Font.createFont(0, ff2Stream.createInputStream());
                }
                catch (FontFormatException f) {
                    try {
                        byte[] fontData = this.rebuildTTF(fd, ff2Stream.createInputStream());
                        if (fontData != null) {
                            ByteArrayInputStream bais = new ByteArrayInputStream(fontData);
                            this.awtFont = Font.createFont(0, bais);
                        }
                    }
                    catch (FontFormatException fontFormatException) {
                        // empty catch block
                    }
                }
                if (this.awtFont == null) {
                    this.awtFont = FontManager.getAwtFont(fd.getFontName());
                    this.setIsFontSubstituted(true);
                }
            } else {
                TrueTypeFont ttf;
                this.awtFont = FontManager.getAwtFont(fd.getFontName());
                if (this.awtFont == null && (ttf = this.getExternalFontFile2(fd)) != null) {
                    try {
                        this.awtFont = Font.createFont(0, ttf.getOriginalData());
                    }
                    catch (FontFormatException fontFormatException) {
                        // empty catch block
                    }
                }
            }
            if (this.awtFont == null) {
                this.awtFont = FontManager.getStandardFont();
                this.setIsFontSubstituted(true);
            }
        }
        return this.awtFont;
    }

    private byte[] rebuildTTF(SMFontDescriptorDictionary fd, InputStream inputStream) throws IOException {
        if (this.getFontEncoding() instanceof WinAnsiEncoding) {
            TTFParser ttfParser = new TTFParser(true);
            TrueTypeFont ttf = ttfParser.parseTTF(inputStream);
            TTFSubFont ttfSub = new TTFSubFont(ttf, "PDFBox-Rebuild");
            int i = this.getFirstChar();
            while (i <= this.getLastChar()) {
                ttfSub.addCharCode(i);
                ++i;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ttfSub.writeToStream(baos);
            return baos.toByteArray();
        }
        return null;
    }

    private InputStream getExternalTTFData() throws IOException {
        String ttfResource = externalFonts.getProperty(UNKNOWN_FONT);
        String baseFont = this.getBaseFont();
        if (baseFont != null && externalFonts.containsKey(baseFont)) {
            ttfResource = externalFonts.getProperty(baseFont);
        }
        return ttfResource != null ? ResourceLoader.loadResource(ttfResource) : null;
    }

    private TrueTypeFont getExternalFontFile2(SMFontDescriptorDictionary fd) throws IOException {
        TrueTypeFont retval = null;
        if (fd != null) {
            String baseFont = this.getBaseFont();
            String fontResource = externalFonts.getProperty(UNKNOWN_FONT);
            if (baseFont != null && externalFonts.containsKey(baseFont)) {
                fontResource = externalFonts.getProperty(baseFont);
            }
            if (fontResource != null && (retval = loadedExternalFonts.get(baseFont)) == null) {
                TTFParser ttfParser = new TTFParser();
                InputStream fontStream = ResourceLoader.loadResource(fontResource);
                if (fontStream == null) {
                    throw new IOException("Error missing font resource '" + externalFonts.get(baseFont) + "'");
                }
                retval = ttfParser.parseTTF(fontStream);
                loadedExternalFonts.put(baseFont, retval);
            }
        }
        return retval;
    }

    public static byte[] is2byte(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }
}

