/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.font;

import com.plpdf.encoding.DictionaryEncoding;
import com.plpdf.encoding.Encoding;
import com.plpdf.encoding.EncodingManager;
import com.plpdf.exceptions.PlpdfException;
import com.plpdf.font.afm.FontMetric;
import com.plpdf.font.cmap.CMap;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.font.SMCIDFontType2Font;
import com.plpdf.smmodel.font.SMFont;
import com.plpdf.smmodel.font.SMFontDescriptor;
import com.plpdf.smmodel.font.SMType0Font;
import com.plpdf.util.ResourceLoader;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.HashMap;

public abstract class SMSimpleFont
extends SMFont {
    private final HashMap<Integer, Float> mFontSizes = new HashMap(128);
    private float avgFontWidth = 0.0f;
    private float avgFontHeight = 0.0f;
    private float fontWidthOfSpace = -1.0f;
    private static final byte[] SPACE_BYTES = new byte[]{32};
    private boolean isFontSubstituted = false;

    public SMSimpleFont() {
    }

    public SMSimpleFont(OMDictionary fontDictionary) {
        super(fontDictionary);
    }

    public Font getawtFont() throws IOException {
        return null;
    }

    public void drawString(String string, int[] codePoints, Graphics g, float fontSize, AffineTransform at, float x, float y) throws IOException, Exception {
        SMFont descendantFont;
        Font awtFont = this.getawtFont();
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        GlyphVector glyphs = null;
        boolean useCodepoints = codePoints != null && this.isType0Font();
        SMFont sMFont = descendantFont = useCodepoints ? ((SMType0Font)this).getDescendantFont() : null;
        if (useCodepoints && !descendantFont.getFontDescriptor().isSymbolic()) {
            SMCIDFontType2Font cid2Font = null;
            if (descendantFont instanceof SMCIDFontType2Font) {
                cid2Font = (SMCIDFontType2Font)descendantFont;
            }
            glyphs = cid2Font != null && cid2Font.hasCIDToGIDMap() || this.isFontSubstituted ? awtFont.createGlyphVector(frc, string) : awtFont.createGlyphVector(frc, codePoints);
        } else {
            if (!this.isType1Font() && awtFont.canDisplayUpTo(string) != -1) {
                awtFont = Font.decode(null).deriveFont(1.0f);
            }
            glyphs = awtFont.createGlyphVector(frc, string);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.writeFont(g2d, at, x, y, glyphs);
    }

    public float getFontHeight(byte[] c, int offset, int length) throws IOException {
        if (this.avgFontHeight > 0.0f) {
            return this.avgFontHeight;
        }
        float retval = 0.0f;
        FontMetric metric = this.getAFM();
        if (metric != null) {
            int code = this.getCodeFromArray(c, offset, length);
            Encoding encoding = this.getFontEncoding();
            String characterName = encoding.getName(code);
            retval = metric.getCharacterHeight(characterName);
        } else {
            SMFontDescriptor desc = this.getFontDescriptor();
            if (desc != null) {
                SMRectangle fontBBox = desc.getFontBoundingBox();
                if (fontBBox != null) {
                    retval = fontBBox.getHeight() / 2.0f;
                }
                if (retval == 0.0f) {
                    retval = desc.getCapHeight();
                }
                if (retval == 0.0f) {
                    retval = desc.getAscent();
                }
                if (retval == 0.0f && (retval = desc.getXHeight()) > 0.0f) {
                    retval -= desc.getDescent();
                }
                this.avgFontHeight = retval;
            }
        }
        return retval;
    }

    public float getFontWidth(byte[] c, int offset, int length) throws IOException {
        int code = this.getCodeFromArray(c, offset, length);
        Float fontWidth = this.mFontSizes.get(code);
        if (fontWidth == null) {
            fontWidth = Float.valueOf(this.getFontWidth(code));
            if (fontWidth.floatValue() <= 0.0f) {
                fontWidth = Float.valueOf(this.getFontWidthFromAFMFile(code));
            }
            this.mFontSizes.put(code, fontWidth);
        }
        return fontWidth.floatValue();
    }

    public float getAverageFontWidth() throws IOException {
        float average = 0.0f;
        if (this.avgFontWidth != 0.0f) {
            average = this.avgFontWidth;
        } else {
            float totalWidth = 0.0f;
            float characterCount = 0.0f;
            OMArray widths = (OMArray)this.font.getDictionaryObject(OMName.WIDTHS);
            if (widths != null) {
                int i = 0;
                while (i < widths.size()) {
                    OMNumber fontWidth = (OMNumber)widths.getObject(i);
                    if (fontWidth.floatValue() > 0.0f) {
                        totalWidth += fontWidth.floatValue();
                        characterCount += 1.0f;
                    }
                    ++i;
                }
            }
            average = totalWidth > 0.0f ? totalWidth / characterCount : this.getAverageFontWidthFromAFMFile();
            this.avgFontWidth = average;
        }
        return average;
    }

    public OMBase getToUnicode() {
        return this.font.getDictionaryObject(OMName.TO_UNICODE);
    }

    public void setToUnicode(OMBase unicode) {
        this.font.setItem(OMName.TO_UNICODE, unicode);
    }

    public SMRectangle getFontBoundingBox() throws IOException {
        return this.getFontDescriptor().getFontBoundingBox();
    }

    protected void writeFont(Graphics2D g2d, AffineTransform at, float x, float y, GlyphVector glyphs) {
        if (!at.isIdentity()) {
            try {
                AffineTransform atInv = at.createInverse();
                g2d.transform(at);
                Point2D.Float newXy = new Point2D.Float(x, y);
                atInv.transform(new Point2D.Float(x, y), newXy);
                g2d.drawGlyphVector(glyphs, (float)newXy.getX(), (float)newXy.getY());
                g2d.transform(atInv);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {}
        } else {
            g2d.drawGlyphVector(glyphs, x, y);
        }
    }

    protected void determineEncoding() {
        String cmapName = null;
        OMName encodingName = null;
        OMBase encoding = this.getEncoding();
        Encoding fontEncoding = null;
        if (encoding != null) {
            if (encoding instanceof OMName) {
                if (this.cmap == null) {
                    encodingName = (OMName)encoding;
                    this.cmap = (CMap)cmapObjects.get(encodingName.getName());
                    if (this.cmap == null) {
                        cmapName = encodingName.getName();
                    }
                }
                if (this.cmap == null && cmapName != null) {
                    try {
                        fontEncoding = EncodingManager.INSTANCE.getEncoding(encodingName);
                    }
                    catch (IOException iOException) {}
                }
            } else if (encoding instanceof OMStream) {
                if (this.cmap == null) {
                    OMStream encodingStream = (OMStream)encoding;
                    try {
                        this.cmap = this.parseCmap(null, encodingStream.getUnfilteredStream());
                    }
                    catch (IOException iOException) {}
                }
            } else if (encoding instanceof OMDictionary) {
                try {
                    fontEncoding = new DictionaryEncoding((OMDictionary)encoding);
                }
                catch (IOException encodingStream) {
                    // empty catch block
                }
            }
        }
        this.setFontEncoding(fontEncoding);
        this.extractToUnicodeEncoding();
        if (this.cmap == null && cmapName != null) {
            String resourceName = "com/plpdf/res/cmap/" + cmapName;
            try {
                this.cmap = this.parseCmap("com/plpdf/res/cmap/", ResourceLoader.loadResource(resourceName));
                if (this.cmap == null) {
                    // empty if block
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void extractToUnicodeEncoding() {
        OMName encodingName = null;
        String cmapName = null;
        OMBase toUnicode = this.getToUnicode();
        if (toUnicode != null) {
            this.setHasToUnicode(true);
            if (toUnicode instanceof OMStream) {
                try {
                    this.toUnicodeCmap = this.parseCmap("com/plpdf/res/cmap/", ((OMStream)toUnicode).getUnfilteredStream());
                }
                catch (IOException iOException) {}
            } else if (toUnicode instanceof OMName) {
                encodingName = (OMName)toUnicode;
                this.toUnicodeCmap = (CMap)cmapObjects.get(encodingName.getName());
                if (this.toUnicodeCmap == null) {
                    cmapName = encodingName.getName();
                    String resourceName = "com/plpdf/res/cmap/" + cmapName;
                    try {
                        this.toUnicodeCmap = this.parseCmap("com/plpdf/res/cmap/", ResourceLoader.loadResource(resourceName));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected boolean isFontSubstituted() {
        return this.isFontSubstituted;
    }

    protected void setIsFontSubstituted(boolean isSubstituted) {
        this.isFontSubstituted = isSubstituted;
    }

    public float getSpaceWidth() {
        if (this.fontWidthOfSpace == -1.0f) {
            OMBase toUnicode = this.getToUnicode();
            try {
                if (toUnicode != null) {
                    int spaceMapping = this.toUnicodeCmap.getSpaceMapping();
                    if (spaceMapping > -1) {
                        this.fontWidthOfSpace = this.getFontWidth(spaceMapping);
                    }
                } else {
                    this.fontWidthOfSpace = this.getFontWidth(SPACE_BYTES, 0, 1);
                }
                if (this.fontWidthOfSpace <= 0.0f) {
                    this.fontWidthOfSpace = this.getAverageFontWidth();
                }
            }
            catch (Exception e) {
                this.fontWidthOfSpace = 250.0f;
            }
        }
        return this.fontWidthOfSpace;
    }

    protected GlyphVector remapGlyphs(GlyphVector glyphVector, String string) {
        return glyphVector;
    }

    public float getItalicAngle() throws IOException, PlpdfException {
        float retval = 0.0f;
        SMFontDescriptor metric1 = this.getFontDescriptor();
        if (metric1 != null) {
            retval = metric1.getItalicAngle();
        }
        return retval;
    }

    protected void writeFont(Graphics2D g2d, AffineTransform at, Font awtFont, float fontSize, float x, float y, String string) {
        if (!at.isIdentity()) {
            try {
                AffineTransform atInv = at.createInverse();
                g2d.setFont(awtFont.deriveFont(fontSize));
                g2d.transform(at);
                Point2D.Float newXy = new Point2D.Float(x, y);
                atInv.transform(new Point2D.Float(x, y), newXy);
                g2d.drawString(string, (float)newXy.getX(), (float)newXy.getY());
                g2d.transform(atInv);
            }
            catch (NoninvertibleTransformException e) {
                System.err.println("Error in " + this.getClass().getName() + ".writeFont:" + e);
            }
        } else {
            g2d.setFont(awtFont.deriveFont(at).deriveFont(fontSize));
            g2d.drawString(string, x, y);
        }
    }
}

